/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.draw.css.converter;

import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.function.Consumer;
import javafx.scene.paint.CycleMethod;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.base.converter.IdResolver;
import org.jhotdraw8.base.converter.IdSupplier;
import org.jhotdraw8.css.converter.AbstractCssConverter;
import org.jhotdraw8.css.parser.CssToken;
import org.jhotdraw8.css.parser.CssTokenizer;
import org.jhotdraw8.draw.css.converter.ColorCssConverter;
import org.jhotdraw8.draw.css.converter.CssStop;
import org.jhotdraw8.draw.css.value.CssColor;
import org.jhotdraw8.draw.css.value.CssLinearGradient;

public class LinearGradientCssConverter
extends AbstractCssConverter<CssLinearGradient> {
    private static final @NonNull ColorCssConverter colorConverter = new ColorCssConverter(false);
    public static final String LINEAR_GRADIENT_FUNCTION = "linear-gradient";

    public LinearGradientCssConverter(boolean nullable) {
        super(nullable);
    }

    public LinearGradientCssConverter() {
        this(false);
    }

    protected <TT extends CssLinearGradient> void produceTokensNonNull(@NonNull TT lg, @Nullable IdSupplier idSupplier, @NonNull Consumer<CssToken> out) {
        boolean needsFromTo;
        out.accept(new CssToken(-18, LINEAR_GRADIENT_FUNCTION));
        boolean proportional = lg.isProportional();
        double startX = lg.getStartX();
        double startY = lg.getStartY();
        double endX = lg.getEndX();
        double endY = lg.getEndY();
        boolean needsSpace = false;
        boolean needsComma = false;
        if (proportional) {
            if (startX == 0.0 && startY == 0.0 & endX == 0.0 && endY == 0.0) {
                needsFromTo = true;
            } else if (startX == 0.0 && startY == 0.0 & endX == 0.0 && endY == 1.0) {
                needsFromTo = false;
            } else if (startX == 0.0 && endX == 1.0 && startY == endY) {
                out.accept(new CssToken(-2, "to"));
                out.accept(new CssToken(-16, " "));
                out.accept(new CssToken(-2, "right"));
                needsComma = true;
                needsFromTo = false;
            } else if (startX == 0.0 && startY == 0.0 & endX == 1.0 && endY == 1.0) {
                out.accept(new CssToken(-2, "to"));
                out.accept(new CssToken(-16, " "));
                out.accept(new CssToken(-2, "right"));
                out.accept(new CssToken(-16, " "));
                out.accept(new CssToken(-2, "bottom"));
                needsComma = true;
                needsFromTo = false;
            } else if (startX == endX && startY == 1.0 && endY == 0.0) {
                out.accept(new CssToken(-2, "to"));
                out.accept(new CssToken(-16, " "));
                out.accept(new CssToken(-2, "top"));
                needsComma = true;
                needsFromTo = false;
            } else if (startX == 0.0 && startY == 1.0 && endX == 0.0 && endY == 1.0) {
                needsFromTo = true;
            } else if (startX == 0.0 && startY == 1.0 && endX == 1.0 && endY == 0.0) {
                out.accept(new CssToken(-2, "to"));
                out.accept(new CssToken(-16, " "));
                out.accept(new CssToken(-2, "right"));
                out.accept(new CssToken(-16, " "));
                out.accept(new CssToken(-2, "top"));
                needsComma = true;
                needsFromTo = false;
            } else if (startX == 1.0 && endX == 0.0 && endY == startY) {
                out.accept(new CssToken(-2, "to"));
                out.accept(new CssToken(-16, " "));
                out.accept(new CssToken(-2, "left"));
                needsComma = true;
                needsFromTo = false;
            } else if (startX == 1.0 && startY == 0.0 && endX == 0.0 && endY == 1.0) {
                out.accept(new CssToken(-2, "to"));
                out.accept(new CssToken(-16, " "));
                out.accept(new CssToken(-2, "left"));
                out.accept(new CssToken(-16, " "));
                out.accept(new CssToken(-2, "bottom"));
                needsComma = true;
                needsFromTo = false;
            } else if (startX == 1.0 && startY == 0.0 && endX == 1.0 && endY == 0.0) {
                needsFromTo = true;
            } else if (startX == 1.0 && startY == 0.0 && endX == 1.0 && endY == 1.0) {
                needsFromTo = false;
            } else if (startX == 1.0 && startY == 1.0 && endX == 0.0 && endY == 0.0) {
                out.accept(new CssToken(-2, "to"));
                out.accept(new CssToken(-16, " "));
                out.accept(new CssToken(-2, "left"));
                out.accept(new CssToken(-16, " "));
                out.accept(new CssToken(-2, "top"));
                needsComma = true;
                needsFromTo = false;
            } else {
                needsFromTo = startX == 1.0 && startY == 1.0 && endX == 1.0 && endY == 1.0 ? true : true;
            }
        } else {
            needsFromTo = true;
        }
        if (needsFromTo) {
            out.accept(new CssToken(-2, "from"));
            out.accept(new CssToken(-16, " "));
            if (proportional) {
                out.accept(new CssToken(-10, (Number)(startX * 100.0)));
                out.accept(new CssToken(-16, " "));
                out.accept(new CssToken(-10, (Number)(startY * 100.0)));
                out.accept(new CssToken(-16, " "));
            } else {
                out.accept(new CssToken(-9, (Number)startX));
                out.accept(new CssToken(-16, " "));
                out.accept(new CssToken(-9, (Number)startY));
            }
            needsSpace = true;
            needsComma = true;
            out.accept(new CssToken(-16, " "));
            out.accept(new CssToken(-2, "to"));
            out.accept(new CssToken(-16, " "));
            if (proportional) {
                out.accept(new CssToken(-10, (Number)(endX * 100.0)));
                out.accept(new CssToken(-16, " "));
                out.accept(new CssToken(-10, (Number)(endY * 100.0)));
                out.accept(new CssToken(-16, " "));
            } else {
                out.accept(new CssToken(-9, (Number)endX));
                out.accept(new CssToken(-16, " "));
                out.accept(new CssToken(-9, (Number)endY));
            }
            needsSpace = true;
            needsComma = true;
        }
        switch (lg.getCycleMethod()) {
            case NO_CYCLE: {
                break;
            }
            case REPEAT: {
                if (needsComma) {
                    out.accept(new CssToken(44));
                    out.accept(new CssToken(-16, " "));
                }
                out.accept(new CssToken(-2, "repeat"));
                needsComma = true;
                break;
            }
            case REFLECT: {
                if (needsComma) {
                    out.accept(new CssToken(44));
                    out.accept(new CssToken(-16, " "));
                }
                out.accept(new CssToken(-2, "reflect"));
                needsComma = true;
                break;
            }
            default: {
                throw new UnsupportedOperationException("not yet implemented");
            }
        }
        for (CssStop stop : lg.getStops()) {
            if (needsComma) {
                out.accept(new CssToken(44));
                out.accept(new CssToken(-16, " "));
            }
            colorConverter.produceTokens(stop.color(), idSupplier, out);
            if (stop.offset() != null) {
                out.accept(new CssToken(-16, " "));
                out.accept(new CssToken(-10, (Number)(stop.offset() * 100.0)));
            }
            needsComma = true;
        }
        out.accept(new CssToken(41));
    }

    public @NonNull CssLinearGradient parseNonNull(@NonNull CssTokenizer tt, @Nullable IdResolver idResolver) throws ParseException, IOException {
        PointToPoint fromTo;
        tt.requireNextToken(-18, "\u27e8LinearGradient\u27e9: \"linear-gradient(\"  expected");
        switch (tt.currentStringNonNull()) {
            case "linear-gradient": {
                break;
            }
            default: {
                throw new ParseException("\u27e8LinearGradient\u27e9: \"linear-gradient\" expected, found: " + tt.currentString(), tt.getStartPosition());
            }
        }
        if (tt.next() == -2 && "from".equals(tt.currentString())) {
            fromTo = this.parsePointToPoint(tt);
        } else if (tt.current() == -2 && "to".equals(tt.currentString())) {
            fromTo = this.parseSideOrCorner(tt);
        } else {
            fromTo = new PointToPoint(0.0, 0.0, 0.0, 1.0, true);
            tt.pushBack();
        }
        if (tt.next() != 44) {
            tt.pushBack();
        }
        CycleMethod cycleMethod = CycleMethod.NO_CYCLE;
        if (tt.next() == -2) {
            if ("repeat".equals(tt.currentString())) {
                cycleMethod = CycleMethod.REPEAT;
            } else if ("reflect".equals(tt.currentString())) {
                cycleMethod = CycleMethod.REFLECT;
            } else {
                tt.pushBack();
            }
        } else {
            tt.pushBack();
        }
        if (tt.next() != 44) {
            tt.pushBack();
        }
        ArrayList<CssStop> stops = new ArrayList<CssStop>();
        while (tt.next() != 41 && tt.current() != -1) {
            tt.pushBack();
            stops.add(this.parseColorStop(tt));
            if (tt.next() == 44) continue;
            tt.pushBack();
        }
        if (tt.current() != 41) {
            throw new ParseException("CSS LinearGradient: ')'  expected, found: " + tt.currentString(), tt.getStartPosition());
        }
        return new CssLinearGradient(fromTo.startX, fromTo.startY, fromTo.endX, fromTo.endY, fromTo.isProportional, cycleMethod, stops.toArray(new CssStop[0]));
    }

    private @NonNull PointToPoint parsePointToPoint(@NonNull CssTokenizer tt) throws IOException, ParseException {
        double endY;
        double endX;
        double startY;
        double startX;
        Boolean isProportional;
        block34: {
            block33: {
                isProportional = null;
                switch (tt.next()) {
                    case -9: {
                        startX = tt.currentNumberNonNull().doubleValue();
                        isProportional = false;
                        break;
                    }
                    case -10: {
                        isProportional = true;
                        startX = tt.currentNumberNonNull().doubleValue() / 100.0;
                        break;
                    }
                    case -11: {
                        isProportional = false;
                        if (!"px".equals(tt.currentString())) {
                            throw new ParseException("CSS LinearGradient: start-x given in pixels or percentage expected, found: " + tt.currentString() + " ttype:" + tt.current(), tt.getStartPosition());
                        }
                        startX = tt.currentNumberNonNull().doubleValue();
                        break;
                    }
                    default: {
                        throw new ParseException("CSS LinearGradient: start-x expected, found: " + tt.currentString() + " ttype:" + tt.current(), tt.getStartPosition());
                    }
                }
                switch (tt.next()) {
                    case -9: {
                        if (isProportional.booleanValue()) {
                            throw new ParseException("CSS LinearGradient: start-y as percentage value expected, found: " + tt.currentString() + " ttype:" + tt.current(), tt.getStartPosition());
                        }
                        startY = tt.currentNumberNonNull().doubleValue();
                        break;
                    }
                    case -10: {
                        if (!isProportional.booleanValue()) {
                            throw new ParseException("CSS LinearGradient: start-y as absolute value expected, found: " + tt.currentString() + " ttype:" + tt.current(), tt.getStartPosition());
                        }
                        startY = tt.currentNumberNonNull().doubleValue() / 100.0;
                        break;
                    }
                    case -11: {
                        if (isProportional.booleanValue()) {
                            throw new ParseException("CSS LinearGradient: start-y as percentage value expected, found: " + tt.currentString() + " ttype:" + tt.current(), tt.getStartPosition());
                        }
                        if (!"px".equals(tt.currentString())) {
                            throw new ParseException("CSS LinearGradient: start-y given in pixels or percentage expected, found: " + tt.currentString() + " ttype:" + tt.current(), tt.getStartPosition());
                        }
                        startY = tt.currentNumberNonNull().doubleValue();
                        break;
                    }
                    default: {
                        throw new ParseException("CSS LinearGradient: start-y expected, found: " + tt.currentString() + " ttype:" + tt.current(), tt.getStartPosition());
                    }
                }
                if (tt.next() != -2 || !"to".equals(tt.currentString())) break block33;
                switch (tt.next()) {
                    case -9: {
                        if (isProportional.booleanValue()) {
                            throw new ParseException("CSS LinearGradient: end-x as percentage value expected, found: " + tt.currentString() + " ttype:" + tt.current(), tt.getStartPosition());
                        }
                        endX = tt.currentNumberNonNull().doubleValue();
                        break;
                    }
                    case -10: {
                        if (!isProportional.booleanValue()) {
                            throw new ParseException("CSS LinearGradient: end-x as absolute value expected, found: " + tt.currentString() + " ttype:" + tt.current(), tt.getStartPosition());
                        }
                        endX = tt.currentNumberNonNull().doubleValue() / 100.0;
                        break;
                    }
                    case -11: {
                        if (isProportional.booleanValue()) {
                            throw new ParseException("CSS LinearGradient: end-x as percentage value expected, found: " + tt.currentString() + " ttype:" + tt.current(), tt.getStartPosition());
                        }
                        if (!"px".equals(tt.currentString())) {
                            throw new ParseException("CSS LinearGradient: end-x given in pixels or percentage expected, found: " + tt.currentString() + " ttype:" + tt.current(), tt.getStartPosition());
                        }
                        endX = tt.currentNumberNonNull().doubleValue();
                        break;
                    }
                    default: {
                        throw new ParseException("CSS LinearGradient: end-x expected, found: " + tt.currentString() + " ttype:" + tt.current(), tt.getStartPosition());
                    }
                }
                switch (tt.next()) {
                    case -9: {
                        if (isProportional.booleanValue()) {
                            throw new ParseException("CSS LinearGradient: end-y as proportional value expected, found: " + tt.currentString() + " ttype:" + tt.current(), tt.getStartPosition());
                        }
                        endY = tt.currentNumberNonNull().doubleValue();
                        break block34;
                    }
                    case -10: {
                        if (!isProportional.booleanValue()) {
                            throw new ParseException("CSS LinearGradient: end-y as absolute value expected, found: " + tt.currentString() + " ttype:" + tt.current(), tt.getStartPosition());
                        }
                        endY = tt.currentNumberNonNull().doubleValue() / 100.0;
                        break block34;
                    }
                    case -11: {
                        if (isProportional.booleanValue()) {
                            throw new ParseException("CSS LinearGradient: end-y as proportional value expected, found: " + tt.currentString() + " ttype:" + tt.current(), tt.getStartPosition());
                        }
                        if (!"px".equals(tt.currentString())) {
                            throw new ParseException("CSS LinearGradient: end-y given in pixels or percent expected, found: " + tt.currentString() + " ttype:" + tt.current(), tt.getStartPosition());
                        }
                        endY = tt.currentNumberNonNull().doubleValue();
                        break block34;
                    }
                    default: {
                        throw new ParseException("CSS LinearGradient: end-y expected, found: " + tt.currentString() + " ttype:" + tt.current(), tt.getStartPosition());
                    }
                }
            }
            throw new ParseException("CSS LinearGradient: 'to' expected, found: " + tt.currentString() + " ttype:" + tt.current(), tt.getStartPosition());
        }
        return new PointToPoint(startX, startY, endX, endY, isProportional);
    }

    private @NonNull PointToPoint parseSideOrCorner(@NonNull CssTokenizer tt) throws IOException, ParseException {
        double startX = 0.0;
        double startY = 0.0;
        double endX = 0.0;
        double endY = 1.0;
        boolean isProportional = true;
        String h = null;
        String v = null;
        block32: while (tt.next() == -2) {
            switch (tt.currentString()) {
                case "top": 
                case "bottom": {
                    if (v != null) {
                        throw new ParseException("CSS LinearGradient: you already specified '" + v + "', found: " + tt.currentString() + " ttype:" + tt.current(), tt.getStartPosition());
                    }
                    v = tt.currentString();
                    continue block32;
                }
                case "left": 
                case "right": {
                    if (h != null) {
                        throw new ParseException("CSS LinearGradient: you already specified '" + h + "', found: " + tt.currentString() + " ttype:" + tt.current(), tt.getStartPosition());
                    }
                    h = tt.currentString();
                    continue block32;
                }
            }
            throw new ParseException("CSS LinearGradient: 'top', 'bottom', 'left' or 'right' expected, found: " + tt.currentString() + " ttype:" + tt.current(), tt.getStartPosition());
        }
        tt.pushBack();
        switch (h + " " + v) {
            case "null null": {
                throw new ParseException("CSS LinearGradient: 'top', 'bottom', 'left' or 'right' expected after 'to'.", tt.getStartPosition());
            }
            case "left null": {
                startX = 1.0;
                endY = 0.0;
                endX = 0.0;
                startY = 0.0;
                break;
            }
            case "right null": {
                endY = 0.0;
                startY = 0.0;
                startX = 0.0;
                endX = 1.0;
                break;
            }
            case "null top": {
                endY = 0.0;
                endX = 0.0;
                startX = 0.0;
                startY = 1.0;
                break;
            }
            case "null bottom": {
                endX = 0.0;
                startY = 0.0;
                startX = 0.0;
                endY = 1.0;
                break;
            }
            case "left top": {
                startY = 1.0;
                startX = 1.0;
                endY = 0.0;
                endX = 0.0;
                break;
            }
            case "left bottom": {
                endY = 1.0;
                startX = 1.0;
                endX = 0.0;
                startY = 0.0;
                break;
            }
            case "right top": {
                endY = 0.0;
                startX = 0.0;
                endX = 1.0;
                startY = 1.0;
                break;
            }
            case "right bottom": {
                startY = 0.0;
                startX = 0.0;
                endY = 1.0;
                endX = 1.0;
            }
        }
        return new PointToPoint(startX, startY, endX, endY, isProportional);
    }

    private @NonNull CssStop parseColorStop(@NonNull CssTokenizer tt) throws IOException, ParseException {
        CssColor color = colorConverter.parse(tt, null);
        Double offset = null;
        switch (tt.next()) {
            case -9: {
                offset = tt.currentNumberNonNull().doubleValue();
                break;
            }
            case -10: {
                offset = tt.currentNumberNonNull().doubleValue() / 100.0;
                break;
            }
            default: {
                tt.pushBack();
            }
        }
        return new CssStop(offset, color);
    }

    public @Nullable String getHelpText() {
        return "Format of \u27e8LinearGradient\u27e9: linear-gradient(\uff3b\u27e8LinearGradientParameters\u27e9\uff3d\uff3b,\u27e8Cycle\u27e9\uff3d,\u27e8ColorStop\u27e9\uff5b,\u27e8ColorStop\u27e9\uff5d)\nFormat of \u27e8LinearGradientParameters\u27e9: \u27e8PointToPoint\u27e9\uff5c\u27e8SideOrCorners\u27e9\nFormat of \u27e8PointToPoint\u27e9: from \u27e8x1\u27e9,\u27e8y1\u27e9 to \u27e8x2\u27e9,\u27e8y2\u27e9\uff5cfrom \u27e8x1\u27e9%,\u27e8y1\u27e9% to \u27e8x2\u27e9%,\u27e8y2\u27e9%\nFormat of \u27e8SideOrCorners\u27e9: to\uff08left\uff5cright\uff5ctop\uff5cbottom\uff09\uff5cto\uff08left\uff5cright\uff09\uff08top\uff5cbottom\uff09\nFormat of \u27e8Cycle\u27e9: repeat\uff5creflect\nFormat of \u27e8ColorStop\u27e9: \u27e8Color\u27e9 \u27e8percentage\u27e9%\n" + colorConverter.getHelpText();
    }

    private record PointToPoint(double startX, double startY, double endX, double endY, boolean isProportional) {
    }
}

