/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.draw.css.converter;

import java.io.IOException;
import java.text.ParseException;
import java.util.function.Consumer;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.base.converter.IdResolver;
import org.jhotdraw8.base.converter.IdSupplier;
import org.jhotdraw8.css.converter.AbstractCssConverter;
import org.jhotdraw8.css.parser.CssToken;
import org.jhotdraw8.css.parser.CssTokenizer;
import org.jhotdraw8.draw.locator.BoundsLocator;
import org.jhotdraw8.draw.locator.Locator;

public class LocatorCssConverter
extends AbstractCssConverter<Locator> {
    public static final String RELATIVE_FUNCTION = "relative";

    public LocatorCssConverter() {
        this(false);
    }

    public LocatorCssConverter(boolean nullable) {
        super(nullable);
    }

    public @NonNull Locator parseNonNull(@NonNull CssTokenizer tt, @Nullable IdResolver idResolver) throws ParseException, IOException {
        tt.requireNextToken(-18, "Locator: function 'relative(' expected.");
        if (!RELATIVE_FUNCTION.equals(tt.currentStringNonNull())) {
            throw tt.createParseException("Locator: function 'relative(' expected.");
        }
        double x = switch (tt.next()) {
            case -9 -> tt.currentNumberNonNull().doubleValue();
            case -10 -> tt.currentNumberNonNull().doubleValue() / 100.0;
            default -> throw tt.createParseException("BoundsLocator: x-value expected.");
        };
        switch (tt.next()) {
            case 44: {
                break;
            }
            default: {
                tt.pushBack();
            }
        }
        double y = switch (tt.next()) {
            case -9 -> tt.currentNumberNonNull().doubleValue();
            case -10 -> tt.currentNumberNonNull().doubleValue() / 100.0;
            default -> throw tt.createParseException("BoundsLocator: y-value expected.");
        };
        tt.requireNextToken(41, "BoundsLocator: ')' expected.");
        return new BoundsLocator(x, y);
    }

    public @Nullable String getHelpText() {
        return "Format of \u27e8Locator\u27e9: relative(\u27e8x\u27e9%,\u27e8y\u27e9%)";
    }

    protected <TT extends Locator> void produceTokensNonNull(@NonNull TT value, @Nullable IdSupplier idSupplier, @NonNull Consumer<CssToken> out) {
        if (!(value instanceof BoundsLocator)) {
            throw new UnsupportedOperationException("only BoundsLocator supported, value:" + String.valueOf(value));
        }
        BoundsLocator rl = (BoundsLocator)value;
        out.accept(new CssToken(-18, RELATIVE_FUNCTION));
        out.accept(new CssToken(-10, (Number)(rl.getRelativeX() * 100.0)));
        out.accept(new CssToken(44));
        out.accept(new CssToken(-10, (Number)(rl.getRelativeY() * 100.0)));
        out.accept(new CssToken(41));
    }
}

