/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.draw.css.converter;

import java.io.IOException;
import java.text.ParseException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Consumer;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.base.converter.IdResolver;
import org.jhotdraw8.base.converter.IdSupplier;
import org.jhotdraw8.css.converter.AbstractCssConverter;
import org.jhotdraw8.css.converter.SizeCssConverter;
import org.jhotdraw8.css.parser.CssToken;
import org.jhotdraw8.css.parser.CssTokenizer;
import org.jhotdraw8.css.value.CssSize;
import org.jhotdraw8.draw.css.value.CssDimension2D;

public class PaperSizeCssConverter
extends AbstractCssConverter<CssDimension2D> {
    private final SizeCssConverter sizeConverter = new SizeCssConverter(false);
    private static final @NonNull Map<String, CssDimension2D> paperSizes;
    private static final @NonNull Map<CssDimension2D, String> sizePapers;
    private static final String LANDSCAPE = "landscape";
    private static final String PORTRAIT = "portrait";

    public PaperSizeCssConverter() {
        super(false);
    }

    private @Nullable CssDimension2D parsePageSize(@NonNull CssTokenizer tt, IdResolver idResolver) throws ParseException, IOException {
        if (tt.next() == -2) {
            CssDimension2D paperSize = paperSizes.get(tt.currentString());
            if (paperSize == null) {
                throw new ParseException("Illegal paper format:" + tt.currentString(), tt.getStartPosition());
            }
            if (tt.next() == -2) {
                switch (tt.currentString()) {
                    case "landscape": {
                        paperSize = new CssDimension2D(paperSize.getHeight(), paperSize.getWidth());
                        break;
                    }
                    case "portrait": {
                        break;
                    }
                    default: {
                        tt.pushBack();
                        break;
                    }
                }
            } else {
                tt.pushBack();
            }
            return paperSize;
        }
        tt.pushBack();
        CssSize x = this.sizeConverter.parse(tt, idResolver);
        CssSize y = this.sizeConverter.parse(tt, idResolver);
        return new CssDimension2D(x, y);
    }

    public void toString(@NonNull Appendable out, @Nullable IdSupplier idSupplier, @NonNull CssDimension2D value) throws IOException {
        String paper = sizePapers.get(value);
        if (paper != null) {
            out.append(paper);
        } else {
            out.append(this.sizeConverter.toString((Object)value.getWidth()));
            out.append(' ');
            out.append(this.sizeConverter.toString((Object)value.getHeight()));
        }
    }

    public @NonNull CssDimension2D parseNonNull(@NonNull CssTokenizer tt, @Nullable IdResolver idResolver) throws ParseException, IOException {
        return this.parsePageSize(tt, idResolver);
    }

    protected <TT extends CssDimension2D> void produceTokensNonNull(@NonNull TT value, @Nullable IdSupplier idSupplier, @NonNull Consumer<CssToken> out) {
        String paper = sizePapers.get(value);
        if (paper != null) {
            boolean first = true;
            for (String ident : paper.split("\\s+")) {
                if (first) {
                    first = false;
                } else {
                    out.accept(new CssToken(-16, " "));
                }
                out.accept(new CssToken(-2, ident));
            }
        } else {
            this.sizeConverter.produceTokens(value.getWidth(), idSupplier, out);
            out.accept(new CssToken(-16, " "));
            this.sizeConverter.produceTokens(value.getHeight(), idSupplier, out);
        }
    }

    public @Nullable CssDimension2D getDefaultValue() {
        return new CssDimension2D(CssSize.of((double)0.0), CssSize.of((double)0.0));
    }

    public @Nullable String getHelpText() {
        StringBuilder buf = new StringBuilder();
        for (String s : paperSizes.keySet()) {
            if (!buf.isEmpty()) {
                buf.append('\uff5c');
            }
            buf.append(s);
        }
        return "Format of \u27e8PageSize\u27e9: \u27e8width\u27e9mm \u27e8height\u27e9mm\uff5c\u27e8PaperFormat\u27e9 landscape\uff5c\u27e8PaperFormat\u27e9 portrait\nFormat of \u27e8PaperFormat\u27e9: " + String.valueOf(buf);
    }

    static {
        LinkedHashMap<String, CssDimension2D> m = new LinkedHashMap<String, CssDimension2D>();
        m.put("A0", new CssDimension2D(CssSize.of((double)841.0, (String)"mm"), CssSize.of((double)1189.0, (String)"mm")));
        m.put("A1", new CssDimension2D(CssSize.of((double)594.0, (String)"mm"), CssSize.of((double)841.0, (String)"mm")));
        m.put("A2", new CssDimension2D(CssSize.of((double)420.0, (String)"mm"), CssSize.of((double)594.0, (String)"mm")));
        m.put("A3", new CssDimension2D(CssSize.of((double)297.0, (String)"mm"), CssSize.of((double)420.0, (String)"mm")));
        m.put("A4", new CssDimension2D(CssSize.of((double)210.0, (String)"mm"), CssSize.of((double)297.0, (String)"mm")));
        m.put("A5", new CssDimension2D(CssSize.of((double)148.0, (String)"mm"), CssSize.of((double)210.0, (String)"mm")));
        m.put("A6", new CssDimension2D(CssSize.of((double)105.0, (String)"mm"), CssSize.of((double)148.0, (String)"mm")));
        m.put("DesignatedLong", new CssDimension2D(CssSize.of((double)110.0, (String)"mm"), CssSize.of((double)220.0, (String)"mm")));
        m.put("Letter", new CssDimension2D(CssSize.of((double)8.5, (String)"in"), CssSize.of((double)11.0, (String)"in")));
        m.put("Legal", new CssDimension2D(CssSize.of((double)8.4, (String)"in"), CssSize.of((double)14.0, (String)"in")));
        m.put("Tabloid", new CssDimension2D(CssSize.of((double)11.0, (String)"in"), CssSize.of((double)17.0, (String)"in")));
        m.put("Executive", new CssDimension2D(CssSize.of((double)7.25, (String)"in"), CssSize.of((double)10.5, (String)"in")));
        m.put("x8x10", new CssDimension2D(CssSize.of((double)8.0, (String)"in"), CssSize.of((double)10.0, (String)"in")));
        m.put("MonarchEnvelope", new CssDimension2D(CssSize.of((double)3.87, (String)"in"), CssSize.of((double)7.5, (String)"in")));
        m.put("Number10Envelope", new CssDimension2D(CssSize.of((double)4.125, (String)"in"), CssSize.of((double)9.5, (String)"in")));
        m.put("C", new CssDimension2D(CssSize.of((double)17.0, (String)"in"), CssSize.of((double)22.0, (String)"in")));
        m.put("B4", new CssDimension2D(CssSize.of((double)257.0, (String)"mm"), CssSize.of((double)364.0, (String)"mm")));
        m.put("B5", new CssDimension2D(CssSize.of((double)182.0, (String)"mm"), CssSize.of((double)257.0, (String)"mm")));
        m.put("B6", new CssDimension2D(CssSize.of((double)128.0, (String)"mm"), CssSize.of((double)182.0, (String)"mm")));
        m.put("JapanesePostcard", new CssDimension2D(CssSize.of((double)100.0, (String)"mm"), CssSize.of((double)148.0, (String)"mm")));
        paperSizes = m;
        LinkedHashMap<CssDimension2D, String> x = new LinkedHashMap<CssDimension2D, String>();
        for (Map.Entry e : m.entrySet()) {
            CssDimension2D v = (CssDimension2D)e.getValue();
            x.put(v, (String)e.getKey() + " portrait");
            x.put(new CssDimension2D(v.getHeight(), v.getWidth()), (String)e.getKey() + " landscape");
        }
        sizePapers = x;
    }
}

