/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.draw.css.converter;

import java.io.IOException;
import java.text.ParseException;
import java.util.function.Consumer;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.base.converter.IdResolver;
import org.jhotdraw8.base.converter.IdSupplier;
import org.jhotdraw8.css.converter.AbstractCssConverter;
import org.jhotdraw8.css.converter.SizeCssConverter;
import org.jhotdraw8.css.parser.CssToken;
import org.jhotdraw8.css.parser.CssTokenizer;
import org.jhotdraw8.css.value.CssSize;
import org.jhotdraw8.draw.css.value.CssPoint3D;

public class Point3DCssConverter
extends AbstractCssConverter<CssPoint3D> {
    private final boolean withSpace;
    private final boolean withComma;

    public Point3DCssConverter(boolean nullable) {
        this(nullable, true, false);
    }

    public Point3DCssConverter(boolean nullable, boolean withSpace, boolean withComma) {
        super(nullable);
        this.withSpace = withSpace || !withComma;
        this.withComma = withComma;
    }

    public @NonNull CssPoint3D parseNonNull(@NonNull CssTokenizer tt, @Nullable IdResolver idResolver) throws ParseException, IOException {
        CssSize z;
        CssSize x = SizeCssConverter.parseSize((CssTokenizer)tt, (String)"x");
        tt.skipIfPresent(44);
        CssSize y = SizeCssConverter.parseSize((CssTokenizer)tt, (String)"y");
        tt.skipIfPresent(44);
        if (tt.next() == -1) {
            z = CssSize.ZERO;
        } else {
            tt.pushBack();
            z = SizeCssConverter.parseSize((CssTokenizer)tt, (String)"z");
        }
        return new CssPoint3D(x, y, z);
    }

    protected <TT extends CssPoint3D> void produceTokensNonNull(@NonNull TT value, @Nullable IdSupplier idSupplier, @NonNull Consumer<CssToken> out) {
        CssSize x = value.getX();
        out.accept(new CssToken(-11, (Number)x.getValue(), x.getUnits()));
        this.produceDelimiter(out);
        CssSize y = value.getY();
        out.accept(new CssToken(-11, (Number)y.getValue(), y.getUnits()));
        CssSize z = value.getZ();
        if (z.getValue() != 0.0) {
            this.produceDelimiter(out);
            out.accept(new CssToken(-11, (Number)z.getValue(), z.getUnits()));
        }
    }

    private void produceDelimiter(@NonNull Consumer<CssToken> out) {
        if (this.withComma) {
            out.accept(new CssToken(44));
        }
        if (this.withSpace) {
            out.accept(new CssToken(-16, " "));
        }
    }

    public @Nullable String getHelpText() {
        return "Format of \u27e8CssPoint3D\u27e9: \u27e8x\u27e9 \u27e8y\u27e9 \uff5c \u27e8x\u27e9 \u27e8y\u27e9 \u27e8z\u27e9";
    }
}

