/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.draw.css.converter;

import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.function.Consumer;
import javafx.scene.shape.StrokeLineCap;
import javafx.scene.shape.StrokeLineJoin;
import javafx.scene.shape.StrokeType;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.base.converter.IdResolver;
import org.jhotdraw8.base.converter.IdSupplier;
import org.jhotdraw8.css.converter.AbstractCssConverter;
import org.jhotdraw8.css.parser.CssToken;
import org.jhotdraw8.css.parser.CssTokenizer;
import org.jhotdraw8.css.value.CssSize;
import org.jhotdraw8.draw.css.value.CssStrokeStyle;
import org.jhotdraw8.icollection.VectorList;
import org.jhotdraw8.icollection.immutable.ImmutableList;

public class StrokeStyleCssConverter
extends AbstractCssConverter<CssStrokeStyle> {
    public static final String INSIDE = "inside";
    public static final String OUTSIDE = "outside";
    public static final String CENTERED = "centered";
    public static final String BUTT = "butt";
    public static final String MITER = "miter";
    public static final String ROUND = "round";
    public static final String BEVEL = "bevel";
    public static final String SQUARE = "square";
    public static final String TYPE = "type";
    public static final String LINEJOIN = "linejoin";
    public static final String LINECAP = "linecap";
    public static final String DASHOFFSET = "dashoffset";
    public static final String DASHARRAY = "dasharray";
    public static final String MITERLIMIT = "miterlimit";
    private final boolean printAllValues = true;

    public StrokeStyleCssConverter(boolean nullable) {
        super(nullable);
    }

    public @NonNull CssStrokeStyle parseNonNull(@NonNull CssTokenizer tt, @Nullable IdResolver idResolver) throws ParseException, IOException {
        StrokeType type = StrokeType.CENTERED;
        StrokeLineCap lineCap = StrokeLineCap.BUTT;
        StrokeLineJoin lineJoin = StrokeLineJoin.MITER;
        CssSize miterLimit = CssSize.of((double)4.0);
        CssSize dashOffset = CssSize.of((double)0.0);
        ImmutableList<CssSize> dashArray = VectorList.of();
        block16: while (tt.next() == -18) {
            tt.pushBack();
            switch (tt.currentStringNonNull()) {
                case "type": {
                    type = this.parseStrokeType(tt);
                    continue block16;
                }
                case "linecap": {
                    lineCap = this.parseLineCap(tt);
                    continue block16;
                }
                case "linejoin": {
                    lineJoin = this.parseLineJoin(tt);
                    continue block16;
                }
                case "miterlimit": {
                    miterLimit = this.parseNumericFunction(MITERLIMIT, CssSize.of((double)10.0), tt, idResolver);
                    continue block16;
                }
                case "dashoffset": {
                    dashOffset = this.parseNumericFunction(DASHOFFSET, CssSize.of((double)0.0), tt, idResolver);
                    continue block16;
                }
                case "dasharray": {
                    dashArray = this.parseDashArray(tt, idResolver);
                    continue block16;
                }
            }
            throw new ParseException("\u27e8StrokeStyle\u27e9:: Unsupported function: " + tt.currentStringNonNull(), tt.getStartPosition());
        }
        return new CssStrokeStyle(type, lineCap, lineJoin, miterLimit, dashOffset, dashArray);
    }

    protected @NonNull StrokeLineJoin parseLineJoin(@NonNull CssTokenizer tt) throws ParseException, IOException {
        if (tt.next() != -18 || !LINEJOIN.equals(tt.currentStringNonNull())) {
            throw new ParseException("\u27e8StrokeStyle\u27e9:: Function linejoin() expected.", tt.getStartPosition());
        }
        tt.requireNextToken(-2, "\u27e8StrokeStyle\u27e9: One of miter, bevel, round expected.");
        StrokeLineJoin lineJoin = switch (tt.currentStringNonNull()) {
            case MITER -> StrokeLineJoin.MITER;
            case BEVEL -> StrokeLineJoin.BEVEL;
            case ROUND -> StrokeLineJoin.ROUND;
            default -> throw tt.createParseException("\u27e8StrokeStyle\u27e9: One of miter, bevel, round expected.");
        };
        tt.requireNextToken(41, "\u27e8StrokeStyle\u27e9:: \u27e8linejoin\u27e9 right bracket expected.");
        return lineJoin;
    }

    protected @NonNull StrokeLineCap parseLineCap(@NonNull CssTokenizer tt) throws ParseException, IOException {
        if (tt.next() != -18 || !LINECAP.equals(tt.currentStringNonNull())) {
            throw new ParseException("\u27e8StrokeStyle\u27e9:: Function linecap() expected.", tt.getStartPosition());
        }
        tt.requireNextToken(-2, "\u27e8StrokeStyle\u27e9: One of square, butt, round expected.");
        StrokeLineCap lineCap = switch (tt.currentStringNonNull()) {
            case SQUARE -> StrokeLineCap.SQUARE;
            case BUTT -> StrokeLineCap.BUTT;
            case ROUND -> StrokeLineCap.ROUND;
            default -> throw new ParseException("\u27e8StrokeStyle\u27e9: One of square, butt, round expected.", tt.getStartPosition());
        };
        tt.requireNextToken(41, "\u27e8StrokeStyle\u27e9:: \u27e8linecap\u27e9 right bracket expected.");
        return lineCap;
    }

    protected @NonNull StrokeType parseStrokeType(@NonNull CssTokenizer tt) throws ParseException, IOException {
        if (tt.next() != -18 || !TYPE.equals(tt.currentStringNonNull())) {
            throw new ParseException("\u27e8StrokeStyle\u27e9:: Function type() expected.", tt.getStartPosition());
        }
        tt.requireNextToken(-2, "One of inside, outside, centered expected.");
        StrokeType type = switch (tt.currentStringNonNull()) {
            case INSIDE -> StrokeType.INSIDE;
            case OUTSIDE -> StrokeType.OUTSIDE;
            case CENTERED -> StrokeType.CENTERED;
            default -> throw new ParseException("One of inside, outside, centered expected.", tt.getStartPosition());
        };
        tt.requireNextToken(41, "\u27e8StrokeStyle\u27e9:: \u27e8type\u27e9 right bracket expected.");
        return type;
    }

    private @NonNull ImmutableList<CssSize> parseDashArray(@NonNull CssTokenizer tt, @Nullable IdResolver idResolver) throws ParseException, IOException {
        if (tt.next() != -18 || !DASHARRAY.equals(tt.currentStringNonNull())) {
            throw new ParseException("\u27e8StrokeStyle\u27e9: Function dasharray() expected.", tt.getStartPosition());
        }
        ArrayList<CssSize> list = new ArrayList<CssSize>();
        while (tt.next() == -9 || tt.current() == -11) {
            tt.pushBack();
            list.add(this.parseSize(DASHARRAY, null, tt, idResolver));
            if (tt.next() == 44) continue;
            tt.pushBack();
        }
        tt.pushBack();
        tt.requireNextToken(41, "\u27e8StrokeStyle\u27e9: \u27e8dasharray\u27e9 right bracket expected.");
        return VectorList.copyOf(list);
    }

    private CssSize parseNumericFunction(@NonNull String functionName, CssSize defaultValue, @NonNull CssTokenizer tt, @Nullable IdResolver idResolver) throws ParseException, IOException {
        if (tt.next() != -18 || !functionName.equals(tt.currentStringNonNull())) {
            throw new ParseException("Function " + functionName + "() expected.", tt.getStartPosition());
        }
        CssSize value = this.parseSize(functionName, defaultValue, tt, idResolver);
        tt.requireNextToken(41, "\u27e8StrokeStyle\u27e9: \u27e8" + functionName + "\u27e9 right bracket expected.");
        return value;
    }

    private CssSize parseSize(String name, CssSize defaultValue, @NonNull CssTokenizer tt, IdResolver idResolver) throws IOException {
        CssSize value;
        switch (tt.next()) {
            case -9: {
                value = CssSize.of((double)tt.currentNumberNonNull().doubleValue());
                break;
            }
            case -11: {
                value = CssSize.of((double)tt.currentNumberNonNull().doubleValue(), (String)tt.currentStringNonNull());
                break;
            }
            default: {
                value = defaultValue;
                tt.pushBack();
            }
        }
        return value;
    }

    public @Nullable String getHelpText() {
        return "Format of \u27e8StrokeStyle\u27e9: [\u27e8Type\u27e9\uff3d\uff3b\u27e8Linecap\u27e9\uff3d\uff3b\u27e8Linejoin\u27e9\uff3d\uff3b\u27e8Miterlimit\u27e9\uff3d\uff3b\u27e8Dashoffset\u27e9\uff3d\uff3b\u27e8Dasharray\u27e9\uff3d\n  with \u27e8Type\u27e9: type(inside\uff5coutside\uff5ccentered)\n  with \u27e8Linecap\u27e9: linecap(square\uff5cbutt\uff5cround)\n  with \u27e8Linejoin\u27e9: linejoin(miter\uff5cbevel\uff5cround)\n  with \u27e8Miterlimit\u27e9: miterlimit(size)\n  with \u27e8Dashoffset\u27e9: dashoffset(size)\n  with \u27e8Dasharray\u27e9: dasharray(size...)";
    }

    public @NonNull ImmutableList<String> getExamples() {
        return VectorList.of((Object[])new String[]{"type(inside)", "type(centered)", "type(outside)", "linecap(round) linejoin(round)", "dashoffset(2) dasharray(5 10)"});
    }

    protected <TT extends CssStrokeStyle> void produceTokensNonNull(@NonNull TT value, @Nullable IdSupplier idSupplier, @NonNull Consumer<CssToken> out) {
        StrokeType type = value.getType();
        out.accept(new CssToken(-18, TYPE));
        switch (type) {
            case INSIDE: {
                out.accept(new CssToken(-2, INSIDE));
                break;
            }
            case OUTSIDE: {
                out.accept(new CssToken(-2, OUTSIDE));
                break;
            }
            case CENTERED: {
                out.accept(new CssToken(-2, CENTERED));
            }
        }
        out.accept(new CssToken(41));
        StrokeLineCap lineCap = value.getLineCap();
        out.accept(new CssToken(-16, " "));
        out.accept(new CssToken(-18, LINECAP));
        switch (lineCap) {
            case BUTT: {
                out.accept(new CssToken(-2, BUTT));
                break;
            }
            case ROUND: {
                out.accept(new CssToken(-2, ROUND));
                break;
            }
            case SQUARE: {
                out.accept(new CssToken(-2, SQUARE));
            }
        }
        out.accept(new CssToken(41));
        StrokeLineJoin lineJoin = value.getLineJoin();
        out.accept(new CssToken(-16, " "));
        out.accept(new CssToken(-18, LINEJOIN));
        switch (lineJoin) {
            case BEVEL: {
                out.accept(new CssToken(-2, BUTT));
                break;
            }
            case ROUND: {
                out.accept(new CssToken(-2, ROUND));
                break;
            }
            case MITER: {
                out.accept(new CssToken(-2, MITER));
            }
        }
        out.accept(new CssToken(41));
        CssSize miterLimit = value.getMiterLimit();
        out.accept(new CssToken(-16, " "));
        out.accept(new CssToken(-18, MITERLIMIT));
        out.accept(new CssToken(-11, (Number)miterLimit.getValue(), miterLimit.getUnits()));
        out.accept(new CssToken(41));
        CssSize dashOffset = value.getDashOffset();
        out.accept(new CssToken(-16, " "));
        out.accept(new CssToken(-18, DASHOFFSET));
        out.accept(new CssToken(-11, (Number)dashOffset.getValue(), dashOffset.getUnits()));
        out.accept(new CssToken(41));
        ImmutableList<CssSize> dashArray = value.getDashArray();
        out.accept(new CssToken(-16, " "));
        out.accept(new CssToken(-18, DASHARRAY));
        int n = dashArray.size();
        for (int i = 0; i < n; ++i) {
            if (i != 0) {
                out.accept(new CssToken(-16, " "));
            }
            CssSize dash = (CssSize)dashArray.get(i);
            out.accept(new CssToken(-11, (Number)dash.getValue(), dash.getUnits()));
        }
        out.accept(new CssToken(41));
    }
}

