/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.draw.css.converter;

import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.function.Consumer;
import javafx.geometry.Point3D;
import javafx.scene.transform.Affine;
import javafx.scene.transform.Rotate;
import javafx.scene.transform.Scale;
import javafx.scene.transform.Shear;
import javafx.scene.transform.Transform;
import javafx.scene.transform.Translate;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.base.converter.IdResolver;
import org.jhotdraw8.base.converter.IdSupplier;
import org.jhotdraw8.css.converter.AbstractCssConverter;
import org.jhotdraw8.css.parser.CssToken;
import org.jhotdraw8.css.parser.CssTokenizer;

public class TransformCssConverter
extends AbstractCssConverter<Transform> {
    public TransformCssConverter() {
        this(true);
    }

    public TransformCssConverter(boolean nullable) {
        super(nullable);
    }

    protected <TT extends Transform> void produceTokensNonNull(@NonNull TT tx, @Nullable IdSupplier idSupplier, @NonNull Consumer<CssToken> out) {
        if (tx instanceof Translate) {
            Translate tr = (Translate)tx;
            out.accept(new CssToken(-18, "translate"));
            out.accept(new CssToken(-9, (Number)tr.getTx()));
            out.accept(new CssToken(44));
            out.accept(new CssToken(-9, (Number)tr.getTy()));
            if (tr.getTz() != 0.0) {
                out.accept(new CssToken(44));
                out.accept(new CssToken(-9, (Number)tr.getTz()));
            }
            out.accept(new CssToken(41));
        } else if (tx instanceof Scale) {
            Scale ts = (Scale)tx;
            out.accept(new CssToken(-18, "scale"));
            out.accept(new CssToken(-9, (Number)ts.getX()));
            if (ts.getY() != ts.getX() || ts.getZ() != 1.0 || ts.getPivotX() != 0.0 || ts.getPivotY() != 0.0) {
                out.accept(new CssToken(44));
                out.accept(new CssToken(-9, (Number)ts.getY()));
            }
            if (ts.getZ() != 1.0) {
                out.accept(new CssToken(44));
                out.accept(new CssToken(-9, (Number)ts.getZ()));
                if (ts.getPivotX() != 0.0 || ts.getPivotY() != 0.0 || ts.getPivotZ() != 0.0) {
                    out.accept(new CssToken(44));
                    out.accept(new CssToken(-16, " "));
                    out.accept(new CssToken(-9, (Number)ts.getPivotX()));
                    out.accept(new CssToken(44));
                    out.accept(new CssToken(-9, (Number)ts.getPivotY()));
                    out.accept(new CssToken(44));
                    out.accept(new CssToken(-9, (Number)ts.getPivotZ()));
                }
            } else if (ts.getPivotX() != 0.0 || ts.getPivotY() != 0.0) {
                out.accept(new CssToken(44));
                out.accept(new CssToken(-16, " "));
                out.accept(new CssToken(-9, (Number)ts.getPivotX()));
                out.accept(new CssToken(44));
                out.accept(new CssToken(-9, (Number)ts.getPivotY()));
            }
            out.accept(new CssToken(41));
        } else if (tx instanceof Rotate) {
            Rotate tr = (Rotate)tx;
            out.accept(new CssToken(-18, "rotate"));
            out.accept(new CssToken(-9, (Number)tr.getAngle()));
            if (tr.getPivotX() != 0.0 || tr.getPivotY() != 0.0 || tr.getPivotZ() != 0.0 || !tr.getAxis().equals((Object)Rotate.Z_AXIS)) {
                out.accept(new CssToken(44));
                out.accept(new CssToken(-16, " "));
                out.accept(new CssToken(-9, (Number)tr.getPivotX()));
                out.accept(new CssToken(44));
                out.accept(new CssToken(-9, (Number)tr.getPivotY()));
            }
            if (tr.getPivotZ() != 0.0) {
                out.accept(new CssToken(44));
                out.accept(new CssToken(-9, (Number)tr.getPivotZ()));
            }
            if (!tr.getAxis().equals((Object)Rotate.Z_AXIS)) {
                Point3D a = tr.getAxis();
                out.accept(new CssToken(44));
                out.accept(new CssToken(-9, (Number)a.getX()));
                out.accept(new CssToken(44));
                out.accept(new CssToken(-9, (Number)a.getY()));
                out.accept(new CssToken(44));
                out.accept(new CssToken(-9, (Number)a.getZ()));
            }
            out.accept(new CssToken(41));
        } else if (tx instanceof Shear) {
            Shear tr = (Shear)tx;
            out.accept(new CssToken(-18, "shear"));
            out.accept(new CssToken(-9, (Number)tr.getX()));
            out.accept(new CssToken(44));
            out.accept(new CssToken(-9, (Number)tr.getY()));
            if (tr.getPivotX() != 0.0 || tr.getPivotY() != 0.0) {
                out.accept(new CssToken(44));
                out.accept(new CssToken(-9, (Number)tr.getPivotX()));
                out.accept(new CssToken(44));
                out.accept(new CssToken(-9, (Number)tr.getPivotY()));
            }
            out.accept(new CssToken(41));
        } else if (tx.isType2D()) {
            out.accept(new CssToken(-18, "matrix"));
            out.accept(new CssToken(-9, (Number)tx.getMxx()));
            out.accept(new CssToken(44));
            out.accept(new CssToken(-9, (Number)tx.getMyx()));
            out.accept(new CssToken(44));
            out.accept(new CssToken(-9, (Number)tx.getMxy()));
            out.accept(new CssToken(44));
            out.accept(new CssToken(-9, (Number)tx.getMyy()));
            out.accept(new CssToken(44));
            out.accept(new CssToken(-9, (Number)tx.getTx()));
            out.accept(new CssToken(44));
            out.accept(new CssToken(-9, (Number)tx.getTy()));
            out.accept(new CssToken(41));
        } else {
            out.accept(new CssToken(-18, "matrix"));
            out.accept(new CssToken(-9, (Number)tx.getMxx()));
            out.accept(new CssToken(44));
            out.accept(new CssToken(-9, (Number)tx.getMyx()));
            out.accept(new CssToken(44));
            out.accept(new CssToken(-9, (Number)tx.getMzx()));
            out.accept(new CssToken(44));
            out.accept(new CssToken(-9, (Number)tx.getMxy()));
            out.accept(new CssToken(44));
            out.accept(new CssToken(-9, (Number)tx.getMyy()));
            out.accept(new CssToken(44));
            out.accept(new CssToken(-9, (Number)tx.getMzy()));
            out.accept(new CssToken(44));
            out.accept(new CssToken(-9, (Number)tx.getMxz()));
            out.accept(new CssToken(44));
            out.accept(new CssToken(-9, (Number)tx.getMyz()));
            out.accept(new CssToken(44));
            out.accept(new CssToken(-9, (Number)tx.getMzz()));
            out.accept(new CssToken(44));
            out.accept(new CssToken(-9, (Number)tx.getTx()));
            out.accept(new CssToken(44));
            out.accept(new CssToken(-9, (Number)tx.getTy()));
            out.accept(new CssToken(44));
            out.accept(new CssToken(-9, (Number)tx.getTz()));
            out.accept(new CssToken(41));
        }
    }

    public @Nullable String getHelpText() {
        return "Format of \u27e8Transform\u27e9: \u27e8Affine\u27e9\uff5c\u27e8Translate\u27e9\uff5c\u27e8Scale\u27e9\uff5c\u27e8Rotate\u27e9\uff5c\u27e8Shear\u27e9\uff5c\u27e8Matrix\u27e9\nFormat of \u27e8Affine\u27e9: affine(\u27e8xx\u27e9,\u27e8xy\u27e9,\u27e8tx\u27e9, \u27e8yx\u27e9,\u27e8yy\u27e9,\u27e8ty\u27e9)\n                  \uff5caffine(\u27e8xx\u27e9,\u27e8xy\u27e9,\u27e8xz\u27e9,\u27e8tx\u27e9, \u27e8yx\u27e9,\u27e8yy\u27e9,\u27e8yz\u27e9,\u27e8ty\u27e9, \u27e8zx\u27e9,\u27e8zy\u27e9,\u27e8zz\u27e9,\u27e8tz\u27e9)\nFormat of \u27e8Translate\u27e9: translate(\u27e8tx\u27e9,\u27e8ty\u27e9)\nFormat of \u27e8Scale\u27e9: scale(\u27e8sx\u27e9,\u27e8sy\u27e9\uff3b,\u27e8pivotx\u27e9,\u27e8pivoty\u27e9\uff3d)\nFormat of \u27e8Rotate\u27e9: rotate(\u27e8angle\u27e9\uff3b,\u27e8pivotx\u27e9,\u27e8pivoty\u27e9\uff3d)\nFormat of \u27e8Shear\u27e9: shear(\u27e8shx\u27e9,\u27e8shy\u27e9\uff3b,\u27e8pivotx\u27e9,\u27e8pivoty\u27e9\uff3d)\n                 | skew(\u27e8shx\u27e9,\u27e8shy\u27e9\uff3b,\u27e8pivotx\u27e9,\u27e8pivoty\u27e9\uff3d)\nFormat of \u27e8Matrix\u27e9: matrix(\u27e8xx\u27e9,\u27e8yx\u27e9, \u27e8xy\u27e9,\u27e8yy\u27e9, \u27e8tx\u27e9,\u27e8ty\u27e9)\n                  \uff5cmatrix(\u27e8xx\u27e9,\u27e8yx\u27e9,\u27e8zx\u27e9, \u27e8xy\u27e9,\u27e8yy\u27e9,\u27e8zy\u27e9, \u27e8xz\u27e9,\u27e8yz\u27e9,\u27e8zz\u27e9, \u27e8tx\u27e9,\u27e8zx\u27e9,\u27e8tz\u27e9)";
    }

    public @NonNull Transform parseNonNull(@NonNull CssTokenizer tt, @Nullable IdResolver idResolver) throws ParseException, IOException {
        tt.requireNextToken(-18, "\u27e8Transform\u27e9: function expected");
        String func = tt.currentStringNonNull();
        int funcPos = tt.getStartPosition();
        ArrayList<Double> m = new ArrayList<Double>();
        while (tt.next() != 41 && tt.current() != -1) {
            if (tt.current() != 44) {
                tt.pushBack();
            }
            if (tt.next() != -9) {
                throw new ParseException("coefficient nb " + m.size() + " expected: \"" + tt.currentString() + "\"", tt.getStartPosition());
            }
            m.add(tt.currentNumberNonNull().doubleValue());
        }
        if (tt.current() != 41) {
            throw new ParseException("')' expected: \"" + tt.currentString() + "\"", tt.getStartPosition());
        }
        return switch (func) {
            case "affine" -> {
                switch (m.size()) {
                    case 0: {
                        yield new Affine(1.0, 0.0, 0.0, 0.0, 1.0, 0.0);
                    }
                    case 6: {
                        yield new Affine(((Double)m.get(0)).doubleValue(), ((Double)m.get(1)).doubleValue(), ((Double)m.get(2)).doubleValue(), ((Double)m.get(3)).doubleValue(), ((Double)m.get(4)).doubleValue(), ((Double)m.get(5)).doubleValue());
                    }
                    case 12: {
                        yield new Affine(((Double)m.get(0)).doubleValue(), ((Double)m.get(1)).doubleValue(), ((Double)m.get(2)).doubleValue(), ((Double)m.get(3)).doubleValue(), ((Double)m.get(4)).doubleValue(), ((Double)m.get(5)).doubleValue(), ((Double)m.get(6)).doubleValue(), ((Double)m.get(7)).doubleValue(), ((Double)m.get(8)).doubleValue(), ((Double)m.get(9)).doubleValue(), ((Double)m.get(10)).doubleValue(), ((Double)m.get(11)).doubleValue());
                    }
                }
                throw new ParseException("6 or 12 coefficients expected, but found " + m.size(), tt.getStartPosition());
            }
            case "matrix" -> {
                switch (m.size()) {
                    case 0: {
                        yield new Affine(1.0, 0.0, 0.0, 0.0, 1.0, 0.0);
                    }
                    case 6: {
                        yield new Affine(((Double)m.get(0)).doubleValue(), ((Double)m.get(2)).doubleValue(), ((Double)m.get(4)).doubleValue(), ((Double)m.get(1)).doubleValue(), ((Double)m.get(3)).doubleValue(), ((Double)m.get(5)).doubleValue());
                    }
                    case 12: {
                        yield new Affine(((Double)m.get(0)).doubleValue(), ((Double)m.get(3)).doubleValue(), ((Double)m.get(6)).doubleValue(), ((Double)m.get(9)).doubleValue(), ((Double)m.get(1)).doubleValue(), ((Double)m.get(4)).doubleValue(), ((Double)m.get(7)).doubleValue(), ((Double)m.get(10)).doubleValue(), ((Double)m.get(2)).doubleValue(), ((Double)m.get(5)).doubleValue(), ((Double)m.get(8)).doubleValue(), ((Double)m.get(11)).doubleValue());
                    }
                }
                throw new ParseException("6 or 12 coefficients expected, but found " + m.size(), tt.getStartPosition());
            }
            case "skew", "shear" -> {
                switch (m.size()) {
                    case 0: {
                        yield Transform.shear((double)0.0, (double)0.0);
                    }
                    case 2: {
                        yield Transform.shear((double)((Double)m.get(0)), (double)((Double)m.get(1)));
                    }
                    case 4: {
                        yield Transform.shear((double)((Double)m.get(0)), (double)((Double)m.get(1)), (double)((Double)m.get(2)), (double)((Double)m.get(3)));
                    }
                }
                throw new ParseException("2 or 4 coefficients expected, but found " + m.size(), tt.getStartPosition());
            }
            case "translate" -> {
                switch (m.size()) {
                    case 0: {
                        yield Transform.translate((double)0.0, (double)0.0);
                    }
                    case 1: {
                        yield Transform.translate((double)((Double)m.get(0)), (double)0.0);
                    }
                    case 2: {
                        yield Transform.translate((double)((Double)m.get(0)), (double)((Double)m.get(1)));
                    }
                    case 3: {
                        yield new Translate(((Double)m.get(0)).doubleValue(), ((Double)m.get(1)).doubleValue(), ((Double)m.get(2)).doubleValue());
                    }
                }
                throw new ParseException("1, 2 or 3 coefficients expected, but found " + m.size(), tt.getStartPosition());
            }
            case "scale" -> {
                switch (m.size()) {
                    case 0: {
                        yield Transform.scale((double)1.0, (double)1.0);
                    }
                    case 1: {
                        yield Transform.scale((double)((Double)m.get(0)), (double)((Double)m.get(0)));
                    }
                    case 2: {
                        yield Transform.scale((double)((Double)m.get(0)), (double)((Double)m.get(1)));
                    }
                    case 3: {
                        yield new Scale(((Double)m.get(0)).doubleValue(), ((Double)m.get(0)).doubleValue(), ((Double)m.get(1)).doubleValue(), ((Double)m.get(2)).doubleValue());
                    }
                    case 4: {
                        yield Transform.scale((double)((Double)m.get(0)), (double)((Double)m.get(1)), (double)((Double)m.get(2)), (double)((Double)m.get(3)));
                    }
                    case 6: {
                        yield new Scale(((Double)m.get(0)).doubleValue(), ((Double)m.get(1)).doubleValue(), ((Double)m.get(2)).doubleValue(), ((Double)m.get(3)).doubleValue(), ((Double)m.get(4)).doubleValue(), ((Double)m.get(5)).doubleValue());
                    }
                }
                throw new ParseException("1, 2, 3, 4, or 6 coefficients expected, but found " + m.size(), tt.getStartPosition());
            }
            case "rotate" -> {
                switch (m.size()) {
                    case 0: {
                        yield Transform.rotate((double)0.0, (double)0.0, (double)0.0);
                    }
                    case 1: {
                        yield Transform.rotate((double)((Double)m.get(0)), (double)0.0, (double)0.0);
                    }
                    case 3: {
                        yield Transform.rotate((double)((Double)m.get(0)), (double)((Double)m.get(1)), (double)((Double)m.get(2)));
                    }
                    case 4: {
                        yield new Rotate(((Double)m.get(0)).doubleValue(), ((Double)m.get(1)).doubleValue(), ((Double)m.get(2)).doubleValue(), ((Double)m.get(3)).doubleValue());
                    }
                    case 6: {
                        yield new Rotate(((Double)m.get(0)).doubleValue(), ((Double)m.get(1)).doubleValue(), ((Double)m.get(2)).doubleValue(), 0.0, new Point3D(((Double)m.get(3)).doubleValue(), ((Double)m.get(4)).doubleValue(), ((Double)m.get(5)).doubleValue()));
                    }
                    case 7: {
                        yield new Rotate(((Double)m.get(0)).doubleValue(), ((Double)m.get(1)).doubleValue(), ((Double)m.get(2)).doubleValue(), ((Double)m.get(3)).doubleValue(), new Point3D(((Double)m.get(4)).doubleValue(), ((Double)m.get(5)).doubleValue(), ((Double)m.get(6)).doubleValue()));
                    }
                }
                throw new ParseException("1, 3, 4, 6 or 7 coefficients expected, but found " + m.size(), tt.getStartPosition());
            }
            default -> throw new ParseException("unsupported function: \"" + func + "\"", funcPos);
        };
    }
}

