/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.draw.css.converter;

import java.io.IOException;
import java.text.ParseException;
import java.util.function.Consumer;
import javafx.geometry.Point3D;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.base.converter.IdResolver;
import org.jhotdraw8.base.converter.IdSupplier;
import org.jhotdraw8.css.converter.AbstractCssConverter;
import org.jhotdraw8.css.parser.CssToken;
import org.jhotdraw8.css.parser.CssTokenizer;

public class Translate3DCssConverter
extends AbstractCssConverter<Point3D> {
    public Translate3DCssConverter(boolean nullable) {
        super(nullable);
    }

    public @Nullable String getHelpText() {
        return "Format of \u27e8Translate3D\u27e9: \u27e8x\u27e9 \u27e8y\u27e9 \uff3b\u27e8z\u27e9\uff3d";
    }

    public @NonNull Point3D parseNonNull(@NonNull CssTokenizer tt, @Nullable IdResolver idResolver) throws ParseException, IOException {
        double z;
        tt.requireNextToken(-9, " \u27e8Translate3D\u27e9: \u27e8x\u27e9 expected.");
        double x = tt.currentNumberNonNull().doubleValue();
        tt.skipIfPresent(44);
        tt.requireNextToken(-9, " \u27e8Translate3D\u27e9: \u27e8y\u27e9 expected.");
        double y = tt.currentNumberNonNull().doubleValue();
        tt.skipIfPresent(44);
        if (tt.next() == -9) {
            z = tt.currentNumberNonNull().doubleValue();
        } else {
            tt.pushBack();
            z = 0.0;
        }
        return new Point3D(x, y, z);
    }

    protected <TT extends Point3D> void produceTokensNonNull(@NonNull TT value, @Nullable IdSupplier idSupplier, @NonNull Consumer<CssToken> out) {
        out.accept(new CssToken(-9, (Number)value.getX()));
        out.accept(new CssToken(-16, " "));
        out.accept(new CssToken(-9, (Number)value.getY()));
        if (value.getZ() != 0.0) {
            out.accept(new CssToken(-16, " "));
            out.accept(new CssToken(-9, (Number)value.getZ()));
        }
    }
}

