/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.draw.css.value;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javafx.scene.paint.CycleMethod;
import javafx.scene.paint.LinearGradient;
import javafx.scene.paint.Paint;
import javafx.scene.paint.Stop;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.draw.css.converter.CssStop;
import org.jhotdraw8.draw.css.value.CssColor;
import org.jhotdraw8.draw.css.value.Paintable;

public class CssLinearGradient
implements Paintable {
    private LinearGradient linearGradient;
    private final double startX;
    private final double startY;
    private final double endX;
    private final double endY;
    private final boolean proportional;
    private final CycleMethod cycleMethod;
    private final CssStop[] cstops;

    public CssLinearGradient(double startX, double startY, double endX, double endY, boolean proportional, CycleMethod cycleMethod, CssStop ... stops) {
        this.startX = startX;
        this.startY = startY;
        this.endX = endX;
        this.endY = endY;
        this.proportional = proportional;
        this.cycleMethod = cycleMethod;
        this.cstops = stops;
    }

    public CssLinearGradient(double startX, double startY, double endX, double endY, boolean proportional, CycleMethod cycleMethod, Collection<CssStop> stops) {
        this(startX, startY, endX, endY, proportional, cycleMethod, stops.toArray(new CssStop[0]));
    }

    public CssLinearGradient(@NonNull LinearGradient linearGradient) {
        this.linearGradient = linearGradient;
        this.startX = linearGradient.getStartX();
        this.startY = linearGradient.getStartY();
        this.endX = linearGradient.getEndX();
        this.endY = linearGradient.getEndY();
        this.proportional = linearGradient.isProportional();
        this.cycleMethod = linearGradient.getCycleMethod();
        List stopList = linearGradient.getStops();
        this.cstops = new CssStop[stopList.size()];
        for (int i = 0; i < this.cstops.length; ++i) {
            Stop stop = (Stop)stopList.get(i);
            this.cstops[i] = new CssStop(stop.getOffset(), new CssColor(stop.getColor()));
        }
    }

    public LinearGradient getLinearGradient() {
        if (this.linearGradient == null) {
            Stop[] stops = new Stop[this.cstops.length];
            for (int i = 0; i < this.cstops.length; ++i) {
                double offset;
                CssStop cstop = this.cstops[i];
                if (cstop.offset() == null) {
                    double rightOffset;
                    int left;
                    int right = i;
                    for (left = i; left > 0 && this.cstops[left].offset() == null; --left) {
                    }
                    while (right < this.cstops.length - 1 && this.cstops[right].offset() == null) {
                        ++right;
                    }
                    double leftOffset = this.cstops[left].offset() == null ? 0.0 : this.cstops[left].offset();
                    double d = rightOffset = this.cstops[right].offset() == null ? 1.0 : this.cstops[right].offset();
                    if (i == left) {
                        offset = leftOffset;
                    } else if (i == right) {
                        offset = rightOffset;
                    } else {
                        double mix = (double)(i - left) / (double)(right - left);
                        offset = leftOffset * (1.0 - mix) + rightOffset * mix;
                    }
                } else {
                    offset = cstop.offset();
                }
                stops[i] = new Stop(offset, cstop.color().getColor());
            }
            this.linearGradient = new LinearGradient(this.startX, this.startY, this.endX, this.endY, this.proportional, this.cycleMethod, stops);
        }
        return this.linearGradient;
    }

    @Override
    public Paint getPaint() {
        return this.getLinearGradient();
    }

    public @NonNull Iterable<CssStop> getStops() {
        return Arrays.asList(this.cstops);
    }

    public double getStartX() {
        return this.startX;
    }

    public double getStartY() {
        return this.startY;
    }

    public double getEndX() {
        return this.endX;
    }

    public double getEndY() {
        return this.endY;
    }

    public boolean isProportional() {
        return this.proportional;
    }

    public CycleMethod getCycleMethod() {
        return this.cycleMethod;
    }

    public int hashCode() {
        int hash = 7;
        return hash;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CssLinearGradient other = (CssLinearGradient)obj;
        if (Double.doubleToLongBits(this.startX) != Double.doubleToLongBits(other.startX)) {
            return false;
        }
        if (Double.doubleToLongBits(this.startY) != Double.doubleToLongBits(other.startY)) {
            return false;
        }
        if (Double.doubleToLongBits(this.endX) != Double.doubleToLongBits(other.endX)) {
            return false;
        }
        if (Double.doubleToLongBits(this.endY) != Double.doubleToLongBits(other.endY)) {
            return false;
        }
        if (this.proportional != other.proportional) {
            return false;
        }
        if (!Objects.equals(this.linearGradient, other.linearGradient)) {
            return false;
        }
        if (this.cycleMethod != other.cycleMethod) {
            return false;
        }
        return Arrays.deepEquals(this.cstops, other.cstops);
    }

    public @NonNull String toString() {
        return "CssLinearGradient{startX=" + this.startX + ", startY=" + this.startY + ", endX=" + this.endX + ", endY=" + this.endY + ", proportional=" + this.proportional + ", " + String.valueOf(this.cycleMethod) + ", stops=" + Arrays.toString(this.cstops) + "}";
    }
}

