/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.draw.css.value;

import java.util.Objects;
import javafx.scene.shape.StrokeLineCap;
import javafx.scene.shape.StrokeLineJoin;
import javafx.scene.shape.StrokeType;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.css.value.CssSize;
import org.jhotdraw8.icollection.VectorList;
import org.jhotdraw8.icollection.immutable.ImmutableList;

public class CssStrokeStyle {
    private final CssSize dashOffset;
    private final ImmutableList<CssSize> dashArray;
    private final StrokeType type;
    private final StrokeLineJoin lineJoin;
    private final StrokeLineCap lineCap;
    private final CssSize miterLimit;

    public CssStrokeStyle() {
        this(StrokeType.CENTERED, StrokeLineCap.BUTT, StrokeLineJoin.MITER, CssSize.of((double)4.0), CssSize.ZERO, (ImmutableList<CssSize>)VectorList.of());
    }

    public CssStrokeStyle(StrokeType type, StrokeLineCap lineCap, StrokeLineJoin lineJoin, CssSize miterLimit, CssSize dashOffset, ImmutableList<CssSize> dashArray) {
        this.dashOffset = dashOffset;
        this.dashArray = dashArray;
        this.type = type;
        this.lineJoin = lineJoin;
        this.lineCap = lineCap;
        this.miterLimit = miterLimit;
    }

    public CssSize getDashOffset() {
        return this.dashOffset;
    }

    public ImmutableList<CssSize> getDashArray() {
        return this.dashArray;
    }

    public StrokeType getType() {
        return this.type;
    }

    public StrokeLineJoin getLineJoin() {
        return this.lineJoin;
    }

    public StrokeLineCap getLineCap() {
        return this.lineCap;
    }

    public CssSize getMiterLimit() {
        return this.miterLimit;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CssStrokeStyle cssStroke = (CssStrokeStyle)o;
        return Objects.equals(this.dashOffset, cssStroke.dashOffset) && Objects.equals(this.dashArray, cssStroke.dashArray) && this.type == cssStroke.type && this.lineJoin == cssStroke.lineJoin && this.lineCap == cssStroke.lineCap && Objects.equals(this.miterLimit, cssStroke.miterLimit);
    }

    public int hashCode() {
        return Objects.hash(this.dashOffset, this.dashArray, this.type, this.lineJoin, this.lineCap, this.miterLimit);
    }

    public @NonNull String toString() {
        return "CssStrokeStyle{, type=" + String.valueOf(this.type) + ", lineJoin=" + String.valueOf(this.lineJoin) + ", lineCap=" + String.valueOf(this.lineCap) + ", miterLimit=" + String.valueOf(this.miterLimit) + ", dashOffset=" + String.valueOf(this.dashOffset) + ", dashArray=" + String.valueOf(this.dashArray) + "}";
    }
}

