/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.draw.figure;

import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.scene.transform.Transform;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.base.event.Listener;
import org.jhotdraw8.css.manager.StylesheetsManager;
import org.jhotdraw8.css.value.CssDefaultableValue;
import org.jhotdraw8.css.value.CssDefaulting;
import org.jhotdraw8.draw.figure.Drawing;
import org.jhotdraw8.draw.figure.Figure;
import org.jhotdraw8.draw.figure.FigurePropertyChangeEvent;
import org.jhotdraw8.draw.figure.TransformCachingFigure;
import org.jhotdraw8.draw.render.RenderContext;
import org.jhotdraw8.fxbase.styleable.AbstractStyleablePropertyBean;
import org.jhotdraw8.fxcollection.typesafekey.Key;
import org.jhotdraw8.fxcollection.typesafekey.MapAccessor;
import org.jhotdraw8.fxcollection.typesafekey.NonNullMapAccessor;
import org.jhotdraw8.icollection.ChampSet;
import org.jhotdraw8.icollection.facade.ReadOnlySetFacade;
import org.jhotdraw8.icollection.immutable.ImmutableSet;
import org.jhotdraw8.icollection.readonly.ReadOnlySet;

public abstract class AbstractFigure
extends AbstractStyleablePropertyBean
implements Figure,
TransformCachingFigure {
    private Set<Figure> layoutObservers;
    private @Nullable Drawing drawing;
    private final @NonNull ObjectProperty<Figure> parent = new SimpleObjectProperty((Object)this, "parent");
    private CopyOnWriteArrayList<Listener<FigurePropertyChangeEvent>> propertyChangeListeners;
    private Transform cachedLocalToWorld;
    private Transform cachedWorldToParent;
    private Transform cachedParentToWorld;
    private Transform cachedParentToLocal;
    private Transform cachedLocalToParent;
    private Transform cachedWorldToLocal;

    protected @NonNull Map<Key<?>, Integer> createKeyMap() {
        return keyMaps.computeIfAbsent(this.getClass(), k -> {
            int index = 0;
            ImmutableSet<MapAccessor<?>> accessors = Figure.getDeclaredAndInheritedMapAccessors(this.getClass());
            IdentityHashMap<Key, Integer> m = new IdentityHashMap<Key, Integer>(accessors.size());
            for (MapAccessor accessor : accessors) {
                if (!(accessor instanceof Key)) continue;
                m.put((Key)accessor, index++);
            }
            return m;
        });
    }

    @Override
    public final void addedToDrawing(@NonNull Drawing drawing) {
        this.drawing = drawing;
        this.doAddedToDrawing(drawing);
    }

    protected void doAddedToDrawing(@NonNull Drawing drawing) {
    }

    protected void doRemovedFromDrawing(Drawing drawing) {
    }

    @Override
    public final @Nullable Drawing getDrawing() {
        return this.drawing;
    }

    @Override
    public final @NonNull Set<Figure> getLayoutObservers() {
        if (this.layoutObservers == null) {
            this.layoutObservers = Collections.newSetFromMap(new IdentityHashMap(1));
        }
        return this.layoutObservers;
    }

    @Override
    public @NonNull ReadOnlySet<Figure> getReadOnlyLayoutObservers() {
        if (this.layoutObservers == null) {
            return ChampSet.of();
        }
        return new ReadOnlySetFacade(this.layoutObservers);
    }

    @Override
    public CopyOnWriteArrayList<Listener<FigurePropertyChangeEvent>> getPropertyChangeListeners() {
        if (this.propertyChangeListeners == null) {
            this.propertyChangeListeners = new CopyOnWriteArrayList();
        }
        return this.propertyChangeListeners;
    }

    @Override
    public boolean hasPropertyChangeListeners() {
        return this.propertyChangeListeners != null && !this.propertyChangeListeners.isEmpty();
    }

    @Override
    public @NonNull ObjectProperty<Figure> parentProperty() {
        return this.parent;
    }

    @Override
    public void removeAllLayoutSubjects() {
    }

    @Override
    public void removeLayoutSubject(Figure connectedFigure) {
    }

    @Override
    public final void removedFromDrawing(Drawing drawing) {
        this.drawing = null;
        this.doRemovedFromDrawing(drawing);
    }

    @Override
    public @Nullable Transform getCachedLocalToWorld() {
        return this.cachedLocalToWorld;
    }

    @Override
    public void setCachedLocalToWorld(@Nullable Transform newValue) {
        this.cachedLocalToWorld = newValue;
    }

    @Override
    public @Nullable Transform getCachedWorldToParent() {
        return this.cachedWorldToParent;
    }

    @Override
    public void setCachedWorldToParent(@Nullable Transform newValue) {
        this.cachedWorldToParent = newValue;
    }

    @Override
    public @Nullable Transform getCachedParentToLocal() {
        return this.cachedParentToLocal;
    }

    @Override
    public void setCachedParentToLocal(@Nullable Transform newValue) {
        this.cachedParentToLocal = newValue;
    }

    @Override
    public @Nullable Transform getCachedLocalToParent() {
        return this.cachedLocalToParent;
    }

    @Override
    public void setCachedLocalToParent(@Nullable Transform newValue) {
        this.cachedLocalToParent = newValue;
    }

    @Override
    public @Nullable Transform getCachedWorldToLocal() {
        return this.cachedWorldToLocal;
    }

    @Override
    public void setCachedWorldToLocal(@Nullable Transform newValue) {
        this.cachedWorldToLocal = newValue;
    }

    @Override
    public @Nullable Transform getCachedParentToWorld() {
        return this.cachedParentToWorld;
    }

    @Override
    public void setCachedParentToWorld(@Nullable Transform newValue) {
        this.cachedParentToWorld = newValue;
    }

    @Override
    public void updateCss(@NonNull RenderContext ctx) {
        StylesheetsManager<Figure> styleManager;
        Drawing d = this.getDrawing();
        if (d != null && (styleManager = d.getStyleManager()) != null) {
            styleManager.applyStylesheetsTo((Object)this);
        }
    }

    protected <T> void onPropertyChanged(Key<T> key, T oldValue, T newValue, boolean wasAdded, boolean wasRemoved) {
        this.firePropertyChangeEvent(this, key, oldValue, newValue, wasAdded, wasRemoved);
    }

    public <T> @NonNull T getStyledNonNull(@NonNull NonNullMapAccessor<T> key) {
        CssDefaultableValue dv;
        Object value = super.getStyledNonNull(key);
        if (value instanceof CssDefaultableValue && (dv = (CssDefaultableValue)value).getDefaulting() == CssDefaulting.INHERIT && this.getParent() != null) {
            value = this.getParent().getStyledNonNull(key);
        }
        return (T)value;
    }
}

