/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.draw.figure;

import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import javafx.geometry.BoundingBox;
import javafx.geometry.Bounds;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.Point2D;
import javafx.geometry.VPos;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.paint.Color;
import javafx.scene.shape.Path;
import javafx.scene.shape.Shape;
import javafx.scene.text.Text;
import javafx.scene.text.TextBoundsType;
import javafx.scene.transform.Transform;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.css.value.CssSize;
import org.jhotdraw8.css.value.UnitConverter;
import org.jhotdraw8.draw.connector.Connector;
import org.jhotdraw8.draw.connector.RectangleConnector;
import org.jhotdraw8.draw.css.value.CssColor;
import org.jhotdraw8.draw.css.value.CssDimension2D;
import org.jhotdraw8.draw.css.value.CssPoint2D;
import org.jhotdraw8.draw.css.value.CssRectangle2D;
import org.jhotdraw8.draw.css.value.Paintable;
import org.jhotdraw8.draw.figure.AbstractLeafFigure;
import org.jhotdraw8.draw.figure.ConnectableFigure;
import org.jhotdraw8.draw.figure.Figure;
import org.jhotdraw8.draw.figure.FillableFigure;
import org.jhotdraw8.draw.figure.IconPosition;
import org.jhotdraw8.draw.figure.PaddableFigure;
import org.jhotdraw8.draw.figure.PathIterableFigure;
import org.jhotdraw8.draw.figure.ShapeableFigure;
import org.jhotdraw8.draw.figure.StrokableFigure;
import org.jhotdraw8.draw.figure.TextFillableFigure;
import org.jhotdraw8.draw.figure.TextFontableFigure;
import org.jhotdraw8.draw.figure.TextLayoutableFigure;
import org.jhotdraw8.draw.key.CssDimension2DStyleableKey;
import org.jhotdraw8.draw.key.CssPoint2DStyleableMapAccessor;
import org.jhotdraw8.draw.key.CssSizeStyleableKey;
import org.jhotdraw8.draw.key.DoubleStyleableKey;
import org.jhotdraw8.draw.key.NonNullEnumStyleableKey;
import org.jhotdraw8.draw.key.NullableFXPathElementsStyleableKey;
import org.jhotdraw8.draw.key.NullablePaintableStyleableKey;
import org.jhotdraw8.draw.locator.BoundsLocator;
import org.jhotdraw8.draw.render.RenderContext;
import org.jhotdraw8.fxcollection.typesafekey.MapAccessor;
import org.jhotdraw8.fxcollection.typesafekey.NonNullMapAccessor;
import org.jhotdraw8.geom.FXPreciseRotate;
import org.jhotdraw8.geom.FXShapes;
import org.jhotdraw8.icollection.immutable.ImmutableList;

public abstract class AbstractLabelFigure
extends AbstractLeafFigure
implements TextFillableFigure,
FillableFigure,
StrokableFigure,
TextFontableFigure,
TextLayoutableFigure,
ConnectableFigure,
PathIterableFigure,
ShapeableFigure,
PaddableFigure {
    public static final @NonNull CssSizeStyleableKey ORIGIN_X = new CssSizeStyleableKey("originX", CssSize.ZERO);
    public static final @NonNull CssSizeStyleableKey ORIGIN_Y = new CssSizeStyleableKey("originY", CssSize.ZERO);
    public static final @NonNull CssPoint2DStyleableMapAccessor ORIGIN = new CssPoint2DStyleableMapAccessor("origin", (NonNullMapAccessor<CssSize>)ORIGIN_X, (NonNullMapAccessor<CssSize>)ORIGIN_Y);
    public static final @NonNull NullableFXPathElementsStyleableKey ICON_SHAPE = new NullableFXPathElementsStyleableKey("iconShape", null);
    public static final @NonNull CssDimension2DStyleableKey ICON_SIZE = new CssDimension2DStyleableKey("iconSize", new CssDimension2D(16.0, 16.0));
    public static final @NonNull CssSizeStyleableKey ICON_TEXT_GAP = new CssSizeStyleableKey("iconTextGap", CssSize.of((double)4.0));
    public static final @NonNull NonNullEnumStyleableKey<IconPosition> ICON_POSITION = new NonNullEnumStyleableKey<IconPosition>("iconPosition", IconPosition.class, IconPosition.LEFT);
    public static final NullablePaintableStyleableKey ICON_FILL = new NullablePaintableStyleableKey("iconFill", new CssColor("canvastext", Color.BLACK));
    public static final @NonNull DoubleStyleableKey ICON_ROTATE = new DoubleStyleableKey("iconRotate", 0.0);
    public static final @NonNull CssSizeStyleableKey ICON_TRANSLATE_Y = new CssSizeStyleableKey("iconTranslateY", CssSize.ZERO);
    public static final @NonNull CssSizeStyleableKey ICON_TRANSLATE_X = new CssSizeStyleableKey("iconTranslateX", CssSize.ZERO);
    public static final @NonNull CssPoint2DStyleableMapAccessor ICON_TRANSLATE = new CssPoint2DStyleableMapAccessor("iconTranslate", (NonNullMapAccessor<CssSize>)ICON_TRANSLATE_X, (NonNullMapAccessor<CssSize>)ICON_TRANSLATE_Y);
    public static final @NonNull NonNullEnumStyleableKey<HPos> TEXT_HPOS = new NonNullEnumStyleableKey<HPos>("textHPos", HPos.class, HPos.LEFT);
    private @Nullable Bounds cachedLayoutBounds;

    public AbstractLabelFigure() {
        this(0.0, 0.0);
    }

    public AbstractLabelFigure(@NonNull Point2D position) {
        this(position.getX(), position.getY());
    }

    public AbstractLabelFigure(double x, double y) {
        if (x != 0.0) {
            this.set((MapAccessor)ORIGIN_X, CssSize.of((double)x));
        }
        if (y != 0.0) {
            this.set((MapAccessor)ORIGIN_Y, CssSize.of((double)y));
        }
    }

    @Override
    public @NonNull Node createNode(@NonNull RenderContext ctx) {
        Group g = new Group();
        g.setManaged(false);
        g.setAutoSizeChildren(false);
        Path p = new Path();
        p.setManaged(false);
        Text text = new Text();
        text.setManaged(false);
        g.getProperties().put((Object)"pathNode", (Object)p);
        g.getProperties().put((Object)"textNode", (Object)text);
        Group ii = new Group();
        ii.setManaged(false);
        g.getProperties().put((Object)"iconNode", (Object)ii);
        return g;
    }

    @Override
    public @Nullable Connector findConnector(@NonNull Point2D p, @Nullable Figure prototype, double tolerance) {
        return new RectangleConnector(new BoundsLocator(this.getLayoutBounds(), p));
    }

    protected @Nullable Bounds getCachedLayoutBounds() {
        return this.cachedLayoutBounds;
    }

    protected void setCachedLayoutBounds(@NonNull Bounds newValue) {
        if (!Objects.equals(this.cachedLayoutBounds, newValue)) {
            this.cachedLayoutBounds = newValue;
        }
    }

    @Override
    public @NonNull Bounds getLayoutBounds() {
        Bounds boundsInLocal = this.getCachedLayoutBounds();
        if (boundsInLocal == null) {
            Point2D origin = ((CssPoint2D)this.getNonNull(ORIGIN)).getConvertedValue();
            return new BoundingBox(origin.getX(), origin.getY(), 0.0, 0.0);
        }
        return boundsInLocal;
    }

    @Override
    public @NonNull CssRectangle2D getCssLayoutBounds() {
        return new CssRectangle2D(this.getLayoutBounds());
    }

    protected boolean hasIcon() {
        return this.getStyled((MapAccessor)ICON_SHAPE) != null;
    }

    @Override
    public @NonNull PathIterator getPathIterator(@NonNull RenderContext ctx, @Nullable AffineTransform tx) {
        Text tn = new Text();
        tn.setX(((CssSize)this.getStyledNonNull(ORIGIN_X)).getConvertedValue());
        tn.setY(((CssSize)this.getStyledNonNull(ORIGIN_Y)).getConvertedValue());
        tn.setBoundsType(TextBoundsType.VISUAL);
        this.applyTextFontableFigureProperties(null, tn);
        this.applyTextLayoutableFigureProperties(null, tn);
        tn.setText(this.getText(ctx));
        return FXShapes.fxShapeToAwtShape((Shape)tn).getPathIterator(tx);
    }

    protected abstract @Nullable String getText(@NonNull RenderContext var1);

    @Override
    public void layout(@NonNull RenderContext ctx) {
        double width;
        Text textNode = new Text();
        this.updateTextNode(ctx, textNode);
        Bounds textBounds = textNode.getLayoutBounds();
        UnitConverter units = (UnitConverter)ctx.getNonNull((NonNullMapAccessor)RenderContext.UNIT_CONVERTER_KEY);
        Insets padding = this.getStyledNonNull(PADDING).getConvertedValue(units);
        boolean hasIcon = this.hasIcon();
        if (hasIcon) {
            CssDimension2D iconSize = (CssDimension2D)this.getStyledNonNull(ICON_SIZE);
            double iconWidth = iconSize.getWidth().getConvertedValue(units);
            double gap = ((CssSize)this.getStyledNonNull(ICON_TEXT_GAP)).getConvertedValue(units);
            width = textBounds.getWidth() + iconWidth + gap;
        } else {
            width = textBounds.getWidth();
        }
        double height = textBounds.getHeight();
        double originX = ((CssSize)this.getNonNull((NonNullMapAccessor)ORIGIN_X)).getConvertedValue(units);
        double originY = ((CssSize)this.getNonNull((NonNullMapAccessor)ORIGIN_Y)).getConvertedValue(units);
        double x = switch (this.getStyledNonNull(TEXT_HPOS)) {
            default -> originX;
            case HPos.CENTER -> originX - width * 0.5;
            case HPos.RIGHT -> originX - width;
        };
        double y = switch ((VPos)this.getStyledNonNull(TEXT_VPOS)) {
            case VPos.TOP -> originY;
            case VPos.CENTER -> originY - height * 0.5;
            default -> originY - textNode.getBaselineOffset();
            case VPos.BOTTOM -> originY - height;
        };
        BoundingBox b = new BoundingBox(x - padding.getLeft(), y - padding.getTop(), width + padding.getLeft() + padding.getRight(), height + padding.getTop() + padding.getBottom());
        this.setCachedLayoutBounds((Bounds)b);
    }

    @Override
    public void reshapeInLocal(@NonNull CssSize x, @NonNull CssSize y, @NonNull CssSize width, @NonNull CssSize height) {
        CssRectangle2D layoutBounds = this.getCssLayoutBounds();
        CssSize dx = x.subtract(layoutBounds.getMinX());
        CssSize dy = y.subtract(layoutBounds.getMinY());
        CssPoint2D p = (CssPoint2D)this.getNonNull(ORIGIN);
        this.set((MapAccessor)ORIGIN_X, p.getX().add(dx));
        this.set((MapAccessor)ORIGIN_Y, p.getY().add(dy));
    }

    @Override
    public void translateInLocal(@NonNull CssPoint2D delta) {
        this.set((MapAccessor)ORIGIN, ((CssPoint2D)this.getNonNull(ORIGIN)).add(delta));
    }

    protected void updateGroupNode(@NonNull RenderContext ctx, @NonNull Group node) {
    }

    @Override
    public void updateNode(@NonNull RenderContext ctx, @NonNull Node node) {
        Group g = (Group)node;
        Path p = (Path)g.getProperties().get((Object)"pathNode");
        Text t = (Text)g.getProperties().get((Object)"textNode");
        Group ii = (Group)g.getProperties().get((Object)"iconNode");
        this.updateGroupNode(ctx, g);
        this.updateTextNode(ctx, t);
        this.updatePathNode(ctx, p);
        this.updateIconNode(ctx, ii);
        ArrayList<Object> newChildren = new ArrayList<Object>(2);
        if (p.getStroke() != null || p.getFill() != null) {
            newChildren.add(p);
        }
        if (t.getStroke() != null || t.getFill() != null) {
            newChildren.add(t);
        }
        newChildren.add(ii);
        if (!newChildren.equals(g.getChildren())) {
            g.getChildren().setAll(newChildren);
        }
    }

    protected void updateIconNode(@NonNull RenderContext ctx, @NonNull Group iconGroupNode) {
        this.updateIconNodeImage(ctx, iconGroupNode);
        this.updateIconNodeTransform(ctx, iconGroupNode);
    }

    protected void updateIconNodeImage(@NonNull RenderContext ctx, @NonNull Group iconGroupNode) {
        Path path;
        ImmutableList elements = (ImmutableList)this.getStyled((MapAccessor)ICON_SHAPE);
        iconGroupNode.setVisible(elements != null);
        if (elements == null) {
            return;
        }
        if (!iconGroupNode.getChildren().isEmpty() && iconGroupNode.getChildren().getFirst() instanceof Path) {
            path = (Path)iconGroupNode.getChildren().getFirst();
        } else {
            path = new Path();
            iconGroupNode.getChildren().setAll((Object[])new Node[]{path});
        }
        path.setFill(Paintable.getPaint((Paintable)this.getStyled((MapAccessor)ICON_FILL), ctx));
        path.setStroke(null);
        path.getElements().setAll((Collection)elements.asList());
    }

    protected void updateIconNodeTransform(@NonNull RenderContext ctx, @NonNull Group iconGroupNode) {
        UnitConverter units = (UnitConverter)ctx.getNonNull((NonNullMapAccessor)RenderContext.UNIT_CONVERTER_KEY);
        CssPoint2D iconTranslate = this.getStyledNonNull(ICON_TRANSLATE);
        double tx = iconTranslate.getX().getConvertedValue(units);
        double ty = iconTranslate.getY().getConvertedValue(units);
        Insets padding = this.getStyledNonNull(PADDING).getConvertedValue(units);
        Bounds b = this.getLayoutBounds();
        iconGroupNode.setTranslateY(b.getMinY() + padding.getTop() + ty);
        double w = ((CssDimension2D)this.getStyledNonNull(ICON_SIZE)).getWidth().getConvertedValue(units);
        double h = ((CssDimension2D)this.getStyledNonNull(ICON_SIZE)).getHeight().getConvertedValue(units);
        switch (this.getStyledNonNull(ICON_POSITION)) {
            default: {
                iconGroupNode.setTranslateX(b.getMinX() + padding.getLeft() + tx);
                break;
            }
            case RIGHT: {
                iconGroupNode.setTranslateX(b.getMaxX() - padding.getRight() - w + tx);
            }
        }
        double iconRotate = (Double)this.getStyledNonNull(ICON_ROTATE);
        if (iconRotate != 0.0) {
            iconGroupNode.getTransforms().setAll((Object[])new Transform[]{new FXPreciseRotate(iconRotate, w * 0.5, h * 0.5)});
        } else {
            iconGroupNode.getTransforms().clear();
        }
    }

    protected void updatePathNode(@NonNull RenderContext ctx, @NonNull Path node) {
        this.applyFillableFigureProperties(ctx, (Shape)node);
        this.applyStrokableFigureProperties(ctx, (Shape)node);
        this.applyShapeableProperties(ctx, node, this.getVisualBounds());
    }

    protected void updateTextNode(@NonNull RenderContext ctx, @NonNull Text tn) {
        this.updateTextNodeFontAndText(ctx, tn);
        this.updateTextNodeLayout(ctx, tn);
        this.updateTextNodePaint(ctx, tn);
    }

    protected void updateTextNodePaint(@NonNull RenderContext ctx, @NonNull Text tn) {
        this.applyTextFillableFigureProperties(ctx, tn);
    }

    protected void updateTextNodeLayout(@NonNull RenderContext ctx, @NonNull Text tn) {
        UnitConverter units = (UnitConverter)ctx.getNonNull((NonNullMapAccessor)RenderContext.UNIT_CONVERTER_KEY);
        IconPosition iconPosition = this.getStyledNonNull(ICON_POSITION);
        CssDimension2D iconSize = (CssDimension2D)this.getStyledNonNull(ICON_SIZE);
        CssSize gap = (CssSize)this.getStyledNonNull(ICON_TEXT_GAP);
        Insets padding = this.getStyledNonNull(PADDING).getConvertedValue(units);
        Bounds boundsInLocal = this.getLayoutBounds();
        double iconPaddingLeft = 0.0;
        if (this.hasIcon() && iconPosition == IconPosition.LEFT) {
            iconPaddingLeft = gap.getConvertedValue(units) + iconSize.getWidth().getConvertedValue(units);
        }
        tn.setTextOrigin(VPos.TOP);
        tn.setX(boundsInLocal.getMinX() + padding.getLeft() + iconPaddingLeft);
        tn.setY(boundsInLocal.getMinY() + padding.getTop());
    }

    protected void updateTextNodeFontAndText(@NonNull RenderContext ctx, @NonNull Text tn) {
        this.applyTextFontableFigureProperties(ctx, tn);
        this.applyTextLayoutableFigureProperties(ctx, tn);
        String text = this.getText(ctx);
        if (!Objects.equals(text, tn.getText())) {
            tn.setText(text);
        }
    }
}

