/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.draw.figure;

import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.List;
import javafx.geometry.Point2D;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.shape.Path;
import javafx.scene.shape.PathElement;
import javafx.scene.transform.Scale;
import javafx.scene.transform.Transform;
import javafx.scene.transform.Translate;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.base.converter.Converter;
import org.jhotdraw8.draw.connector.Connector;
import org.jhotdraw8.draw.css.converter.BezierPathCssConverter;
import org.jhotdraw8.draw.css.value.CssPoint2D;
import org.jhotdraw8.draw.figure.AbstractLineConnectionFigure;
import org.jhotdraw8.draw.figure.Figure;
import org.jhotdraw8.draw.figure.FillRulableFigure;
import org.jhotdraw8.draw.figure.PathIterableFigure;
import org.jhotdraw8.draw.handle.BezierControlPointEditHandle;
import org.jhotdraw8.draw.handle.BezierNodeEditHandle;
import org.jhotdraw8.draw.handle.BezierNodeNonMovableEditHandle;
import org.jhotdraw8.draw.handle.BezierNodeTangentHandle;
import org.jhotdraw8.draw.handle.BezierPathEditHandle;
import org.jhotdraw8.draw.handle.Handle;
import org.jhotdraw8.draw.handle.HandleType;
import org.jhotdraw8.draw.handle.LineConnectorHandle;
import org.jhotdraw8.draw.handle.LineOutlineHandle;
import org.jhotdraw8.draw.handle.MoveHandle;
import org.jhotdraw8.draw.handle.PathIterableOutlineHandle;
import org.jhotdraw8.draw.handle.SelectionHandle;
import org.jhotdraw8.draw.key.NonNullObjectStyleableKey;
import org.jhotdraw8.draw.locator.PointLocator;
import org.jhotdraw8.draw.render.RenderContext;
import org.jhotdraw8.fxcollection.typesafekey.MapAccessor;
import org.jhotdraw8.fxcollection.typesafekey.NonNullMapAccessor;
import org.jhotdraw8.geom.FXPreciseRotate;
import org.jhotdraw8.geom.FXShapes;
import org.jhotdraw8.geom.PointAndDerivative;
import org.jhotdraw8.geom.intersect.IntersectionPointEx;
import org.jhotdraw8.geom.shape.BezierNode;
import org.jhotdraw8.geom.shape.BezierPath;
import org.jhotdraw8.geom.shape.PathMetrics;
import org.jhotdraw8.geom.shape.SimplePathMetrics;
import org.jhotdraw8.icollection.immutable.ImmutableList;

public abstract class AbstractPathConnectionWithMarkersFigure
extends AbstractLineConnectionFigure
implements PathIterableFigure {
    public static final @NonNull NonNullObjectStyleableKey<BezierPath> PATH = new NonNullObjectStyleableKey<BezierPath>("path", (Type)((Object)BezierPath.class), (Converter<BezierPath>)new BezierPathCssConverter(true), BezierPath.of());

    public AbstractPathConnectionWithMarkersFigure() {
        this(0.0, 0.0, 1.0, 1.0);
    }

    public AbstractPathConnectionWithMarkersFigure(@NonNull Point2D start, @NonNull Point2D end) {
        this(start.getX(), start.getY(), end.getX(), end.getY());
    }

    public AbstractPathConnectionWithMarkersFigure(double startX, double startY, double endX, double endY) {
        super(startX, startY, endX, endY);
    }

    @Override
    public void createHandles(@NonNull HandleType handleType, @NonNull List<Handle> list) {
        if (handleType == HandleType.SELECT) {
            list.add(new PathIterableOutlineHandle(this, true));
        } else if (handleType == HandleType.MOVE) {
            list.add(new PathIterableOutlineHandle(this, true));
            if (this.get((MapAccessor)START_CONNECTOR) == null) {
                list.add(new MoveHandle(this, new PointLocator(START)));
            } else {
                list.add(new SelectionHandle(this, new PointLocator(START)));
            }
            if (this.get((MapAccessor)END_CONNECTOR) == null) {
                list.add(new MoveHandle(this, new PointLocator(END)));
            } else {
                list.add(new SelectionHandle(this, new PointLocator(END)));
            }
        } else if (handleType == HandleType.RESIZE) {
            list.add(new PathIterableOutlineHandle(this, true));
            list.add(new LineConnectorHandle(this, START, (MapAccessor<Connector>)START_CONNECTOR, (MapAccessor<Figure>)START_TARGET));
            list.add(new LineConnectorHandle(this, END, (MapAccessor<Connector>)END_CONNECTOR, (MapAccessor<Figure>)END_TARGET));
        } else if (handleType == HandleType.POINT) {
            list.add(new BezierPathEditHandle(this, (MapAccessor<BezierPath>)PATH));
            list.add(new LineConnectorHandle(this, START, (MapAccessor<Connector>)START_CONNECTOR, (MapAccessor<Figure>)START_TARGET));
            list.add(new LineConnectorHandle(this, END, (MapAccessor<Connector>)END_CONNECTOR, (MapAccessor<Figure>)END_TARGET));
            BezierPath nodes = (BezierPath)this.get((MapAccessor)PATH);
            int n = nodes.size();
            for (int i = 0; i < n; ++i) {
                list.add(new BezierNodeTangentHandle(this, (MapAccessor<BezierPath>)PATH, i));
                if (i == 0 || i == n - 1) {
                    list.add(new BezierNodeNonMovableEditHandle(this, (MapAccessor<BezierPath>)PATH, i));
                } else {
                    list.add(new BezierNodeEditHandle(this, (MapAccessor<BezierPath>)PATH, i));
                }
                if (nodes.get(i).hasIn()) {
                    list.add(new BezierControlPointEditHandle(this, (MapAccessor<BezierPath>)PATH, i, 2));
                }
                if (!nodes.get(i).hasOut()) continue;
                list.add(new BezierControlPointEditHandle(this, (MapAccessor<BezierPath>)PATH, i, 4));
            }
        } else if (handleType == HandleType.TRANSFORM) {
            list.add(new LineOutlineHandle(this));
        } else {
            super.createHandles(handleType, list);
        }
    }

    @Override
    public @NonNull Node createNode(@NonNull RenderContext drawingView) {
        Group g = new Group();
        Path line = new Path();
        Path startMarker = new Path();
        Path endMarker = new Path();
        startMarker.setStroke(null);
        endMarker.setStroke(null);
        g.getChildren().addAll((Object[])new Node[]{line, startMarker, endMarker});
        return g;
    }

    public abstract double getMarkerCenterScaleFactor();

    public abstract @Nullable ImmutableList<PathElement> getMarkerCenterShape();

    public abstract double getMarkerEndScaleFactor();

    public abstract @Nullable ImmutableList<PathElement> getMarkerEndShape();

    public abstract double getMarkerStartScaleFactor();

    public abstract @Nullable ImmutableList<PathElement> getMarkerStartShape();

    @Override
    public @NonNull PathIterator getPathIterator(@NonNull RenderContext ctx, @Nullable AffineTransform tx) {
        BezierPath path = (BezierPath)this.get((MapAccessor)PATH);
        if (path == null || path.isEmpty()) {
            Point2D start = ((CssPoint2D)this.getNonNull(START)).getConvertedValue();
            Point2D end = ((CssPoint2D)this.getNonNull(END)).getConvertedValue();
            return new Line2D.Double(start.getX(), start.getY(), end.getX(), end.getY()).getPathIterator(tx);
        }
        return path.getPathIterator(tx);
    }

    public abstract double getStrokeCutEnd(@NonNull RenderContext var1);

    public abstract double getStrokeCutStart(@NonNull RenderContext var1);

    @Override
    public void layout(@NonNull RenderContext ctx) {
        IntersectionPointEx chp;
        PointAndDerivative pd;
        Point2D start = ((CssPoint2D)this.getNonNull(START)).getConvertedValue();
        Point2D end = ((CssPoint2D)this.getNonNull(END)).getConvertedValue();
        Connector startConnector = (Connector)this.get((MapAccessor)START_CONNECTOR);
        Connector endConnector = (Connector)this.get((MapAccessor)END_CONNECTOR);
        Figure startTarget = (Figure)this.get((MapAccessor)START_TARGET);
        Figure endTarget = (Figure)this.get((MapAccessor)END_TARGET);
        BezierPath path = (BezierPath)this.getNonNull((NonNullMapAccessor)PATH);
        if (startConnector != null && startTarget != null) {
            start = (Point2D)startConnector.getPointAndDerivativeInWorld(this, startTarget).getPoint(Point2D::new);
        }
        if (endConnector != null && endTarget != null) {
            end = (Point2D)endConnector.getPointAndDerivativeInWorld(this, endTarget).getPoint(Point2D::new);
        }
        if (startConnector != null && startTarget != null) {
            if (path.size() > 2 || path.size() == 2 && (((BezierNode)path.getFirst()).hasOut() || path.get(1).hasIn())) {
                pd = path.evalFirst();
                chp = startConnector.chopStart(ctx, this, startTarget, start.getX(), start.getY(), start.getX() + pd.dx(), start.getY() + pd.dy());
            } else {
                chp = startConnector.chopStart(ctx, this, startTarget, start, end);
            }
            start = this.worldToParent(chp.getX(), chp.getY());
            this.set((MapAccessor)START, new CssPoint2D(start));
        }
        if (endConnector != null && endTarget != null) {
            if (path.size() > 2 || path.size() == 2 && (((BezierNode)path.getLast()).hasIn() || ((BezierNode)path.getLast(1)).hasOut())) {
                pd = path.evalLastInReverse();
                chp = endConnector.chopStart(ctx, this, endTarget, end.getX(), end.getY(), end.getX() + pd.dx(), end.getY() + pd.dy());
            } else {
                chp = endConnector.chopStart(ctx, this, endTarget, end, start);
            }
            end = this.worldToParent(chp.getX(), chp.getY());
            this.set((MapAccessor)END, new CssPoint2D(end));
        }
        if (path.size() < 2) {
            path = path.add(new BezierNode(start)).add(new BezierNode(end));
        }
        BezierNode first = (BezierNode)path.getFirst();
        path = path.set(0, first.transform((Transform)Transform.translate((double)(start.getX() - first.pointX()), (double)(start.getY() - first.pointY()))));
        BezierNode last = (BezierNode)path.getLast();
        path = path.set(path.size() - 1, last.transform((Transform)Transform.translate((double)(end.getX() - last.pointX()), (double)(end.getY() - last.pointY()))));
        this.set((MapAccessor)PATH, path);
    }

    @Override
    public void transformInLocal(@NonNull Transform tx) {
        this.set((MapAccessor)START, new CssPoint2D(tx.transform(((CssPoint2D)this.getNonNull(START)).getConvertedValue())));
        this.set((MapAccessor)END, new CssPoint2D(tx.transform(((CssPoint2D)this.getNonNull(END)).getConvertedValue())));
        BezierPath path = (BezierPath)this.get((MapAccessor)PATH);
        if (path != null) {
            int n = path.size();
            for (int i = 0; i < n; ++i) {
                BezierNode node = path.get(i);
                path = path.set(i, node.transform(tx));
            }
            this.set((MapAccessor)PATH, path);
        }
    }

    @Override
    public void translateInLocal(@NonNull CssPoint2D t) {
        this.set((MapAccessor)START, ((CssPoint2D)this.getNonNull(START)).add(t));
        this.set((MapAccessor)END, ((CssPoint2D)this.getNonNull(END)).add(t));
        BezierPath path = (BezierPath)this.get((MapAccessor)PATH);
        if (path != null) {
            Point2D tc = t.getConvertedValue();
            Translate tx = new Translate(tc.getX(), tc.getY());
            int n = path.size();
            for (int i = 0; i < n; ++i) {
                BezierNode node = path.get(i);
                path = path.set(i, node.transform((Transform)tx));
            }
            this.set((MapAccessor)PATH, path);
        }
    }

    @Override
    public void reshapeInLocal(@NonNull Transform tx) {
        super.reshapeInLocal(tx);
        BezierPath path = (BezierPath)this.get((MapAccessor)PATH);
        if (path != null) {
            int n = path.size();
            for (int i = 0; i < n; ++i) {
                BezierNode node = path.get(i);
                path = path.set(i, node.transform(tx));
            }
            this.set((MapAccessor)PATH, path);
        }
    }

    protected void updateEndMarkerNode(@NonNull RenderContext ctx, @NonNull Path node) {
    }

    protected void updateLineNode(@NonNull RenderContext ctx, @NonNull Path node) {
    }

    protected void updateMarkerNode(@NonNull RenderContext ctx, Group group, @NonNull Path markerNode, @NonNull PointAndDerivative pd, @Nullable ImmutableList<PathElement> markerShape, double markerScaleFactor) {
        if (markerShape != null) {
            markerNode.getElements().setAll((Collection)markerShape.asCollection());
            double angle = Math.PI + pd.getAngle();
            double pdx = pd.x();
            double pdy = pd.y();
            markerNode.getTransforms().setAll((Object[])new Transform[]{new FXPreciseRotate(angle * 180.0 / Math.PI, pdx, pdy), new Scale(markerScaleFactor, markerScaleFactor, pdx, pdy), new Translate(pdx, pdy)});
            markerNode.setVisible(true);
        } else {
            markerNode.setVisible(false);
        }
    }

    @Override
    public void updateNode(@NonNull RenderContext ctx, @NonNull Node node) {
        PathMetrics pathMetrics = this.getPathMetrics();
        Group g = (Group)node;
        Path lineNode = (Path)g.getChildren().get(0);
        Path startMarkerNode = (Path)g.getChildren().get(1);
        Path endMarkerNode = (Path)g.getChildren().get(2);
        ImmutableList<PathElement> startMarkerShape = this.getMarkerStartShape();
        ImmutableList<PathElement> endMarkerShape = this.getMarkerEndShape();
        double strokeCutStart = this.getStrokeCutStart(ctx);
        double strokeCutEnd = this.getStrokeCutEnd(ctx);
        lineNode.setFillRule(this.getStyledNonNull(FillRulableFigure.FILL_RULE));
        List elements = FXShapes.awtPathIteratorToFXPathElements((PathIterator)pathMetrics.getSubPathIteratorAtArcLength(strokeCutStart, pathMetrics.arcLength() - strokeCutEnd, null));
        if (!lineNode.getElements().equals((Object)elements)) {
            lineNode.getElements().setAll((Collection)elements);
        }
        this.updateLineNode(ctx, lineNode);
        this.updateMarkerNode(ctx, g, startMarkerNode, pathMetrics.eval(0.0), startMarkerShape, this.getMarkerStartScaleFactor());
        this.updateMarkerNode(ctx, g, endMarkerNode, pathMetrics.eval(1.0).reverse(), endMarkerShape, this.getMarkerEndScaleFactor());
        this.updateStartMarkerNode(ctx, startMarkerNode);
        this.updateEndMarkerNode(ctx, endMarkerNode);
    }

    public @NonNull PathMetrics getPathMetrics() {
        BezierPath path = (BezierPath)this.get((MapAccessor)PATH);
        if (path == null || path.isEmpty()) {
            Point2D start = ((CssPoint2D)this.getNonNull(START)).getConvertedValue();
            Point2D end = ((CssPoint2D)this.getNonNull(END)).getConvertedValue();
            return new SimplePathMetrics((Shape)new Line2D.Double(start.getX(), start.getY(), end.getX(), end.getY()));
        }
        return path.getPathMetrics();
    }

    protected void updateStartMarkerNode(@NonNull RenderContext ctx, @NonNull Path node) {
    }
}

