/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.draw.figure;

import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.util.Collection;
import java.util.logging.Logger;
import javafx.geometry.BoundingBox;
import javafx.geometry.Rectangle2D;
import javafx.scene.Node;
import javafx.scene.shape.ClosePath;
import javafx.scene.shape.HLineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;
import javafx.scene.shape.PathElement;
import javafx.scene.shape.VLineTo;
import javafx.scene.transform.Transform;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.css.value.CssSize;
import org.jhotdraw8.draw.css.value.CssRectangle2D;
import org.jhotdraw8.draw.figure.AbstractLeafFigure;
import org.jhotdraw8.draw.figure.PathIterableFigure;
import org.jhotdraw8.draw.figure.RectangleFigure;
import org.jhotdraw8.draw.key.CssRectangle2DStyleableMapAccessor;
import org.jhotdraw8.draw.key.CssSizeStyleableKey;
import org.jhotdraw8.draw.key.NonNullBooleanStyleableKey;
import org.jhotdraw8.draw.key.NullableFXPathElementsStyleableKey;
import org.jhotdraw8.draw.render.RenderContext;
import org.jhotdraw8.fxcollection.typesafekey.MapAccessor;
import org.jhotdraw8.geom.BoundingBoxBuilder;
import org.jhotdraw8.geom.FXPathElementsBuilder;
import org.jhotdraw8.geom.FXShapes;
import org.jhotdraw8.geom.FXSvgPaths;
import org.jhotdraw8.geom.FXTransformPathBuilder;
import org.jhotdraw8.geom.FXTransforms;
import org.jhotdraw8.geom.PathBuilder;
import org.jhotdraw8.icollection.VectorList;
import org.jhotdraw8.icollection.immutable.ImmutableList;

public abstract class AbstractRegionFigure
extends AbstractLeafFigure
implements PathIterableFigure {
    public static final @NonNull CssRectangle2DStyleableMapAccessor BOUNDS = RectangleFigure.BOUNDS;
    public static final @NonNull CssSizeStyleableKey HEIGHT = RectangleFigure.HEIGHT;
    public static final @NonNull NullableFXPathElementsStyleableKey SHAPE = new NullableFXPathElementsStyleableKey("shape", (ImmutableList<PathElement>)VectorList.of((Object[])new PathElement[]{new MoveTo(0.0, 0.0), new HLineTo(1.0), new VLineTo(1.0), new HLineTo(0.0), new ClosePath()}));
    public static final @NonNull CssSizeStyleableKey WIDTH = RectangleFigure.WIDTH;
    public static final @NonNull CssSizeStyleableKey X = RectangleFigure.X;
    public static final @NonNull CssSizeStyleableKey Y = RectangleFigure.Y;
    public static final NonNullBooleanStyleableKey SHAPE_PRESERVE_RATIO_KEY = new NonNullBooleanStyleableKey("ShapePreserveRatio", false);
    private static final Logger LOGGER = Logger.getLogger(AbstractRegionFigure.class.getName());
    private transient ImmutableList<PathElement> pathElements;

    public AbstractRegionFigure() {
        this(0.0, 0.0, 1.0, 1.0);
    }

    public AbstractRegionFigure(double x, double y, double width, double height) {
        if (x != 0.0 || y != 0.0 || width != 0.0 || height != 0.0) {
            this.reshapeInLocal(x, y, width, height);
        }
    }

    public AbstractRegionFigure(@NonNull Rectangle2D rect) {
        this(rect.getMinX(), rect.getMinY(), rect.getWidth(), rect.getHeight());
    }

    @Override
    public @NonNull Node createNode(@NonNull RenderContext drawingView) {
        Path n = new Path();
        n.setManaged(false);
        return n;
    }

    @Override
    public @NonNull CssRectangle2D getCssLayoutBounds() {
        return (CssRectangle2D)this.getNonNull(BOUNDS);
    }

    @Override
    public @NonNull PathIterator getPathIterator(@NonNull RenderContext ctx, @Nullable AffineTransform tx) {
        if (this.pathElements == null) {
            this.pathElements = VectorList.of();
        }
        return FXShapes.fxPathElementsToAwtPathIterator(this.pathElements, (int)0, (AffineTransform)tx);
    }

    @Override
    public void layout(@NonNull RenderContext ctx) {
        this.layoutPath();
    }

    @Override
    public void reshapeInLocal(@NonNull CssSize x, @NonNull CssSize y, @NonNull CssSize width, @NonNull CssSize height) {
        this.set((MapAccessor)X, width.getValue() < 0.0 ? x.add(width) : x);
        this.set((MapAccessor)Y, height.getValue() < 0.0 ? y.add(height) : y);
        this.set((MapAccessor)WIDTH, width.abs());
        this.set((MapAccessor)HEIGHT, height.abs());
    }

    protected void updatePathNode(@NonNull RenderContext ctx, @NonNull Path path) {
        path.getElements().setAll((Collection)this.pathElements.asCollection());
    }

    @Override
    public void updateNode(@NonNull RenderContext ctx, @NonNull Node node) {
        Path path = (Path)node;
        this.updatePathNode(ctx, path);
    }

    protected void layoutPath() {
        double regionRatio;
        double pathRatio;
        ImmutableList shape;
        if (this.pathElements == null) {
            this.pathElements = VectorList.of();
        }
        if ((shape = (ImmutableList)this.getStyled((MapAccessor)SHAPE)) == null || shape.isEmpty()) {
            return;
        }
        double width = ((CssSize)this.getStyledNonNull(WIDTH)).getConvertedValue();
        double height = ((CssSize)this.getStyledNonNull(HEIGHT)).getConvertedValue();
        double x = ((CssSize)this.getStyledNonNull(X)).getConvertedValue();
        double y = ((CssSize)this.getStyledNonNull(Y)).getConvertedValue();
        BoundingBox shapeBounds = ((BoundingBoxBuilder)FXSvgPaths.buildPathElements((PathBuilder)new BoundingBoxBuilder(), (Iterable)shape)).build();
        BoundingBox b = ((Boolean)this.getStyledNonNull(SHAPE_PRESERVE_RATIO_KEY)).booleanValue() ? ((pathRatio = shapeBounds.getHeight() / shapeBounds.getWidth()) < (regionRatio = height / width) ? new BoundingBox(x, y, width, pathRatio * width) : new BoundingBox(x, y, height / pathRatio, height)) : new BoundingBox(x, y, width, height);
        Transform tx = FXTransforms.createReshapeTransform((double)shapeBounds.getMinX(), (double)shapeBounds.getMinY(), (double)shapeBounds.getWidth(), (double)shapeBounds.getHeight(), (double)b.getMinX(), (double)b.getMinY(), (double)b.getWidth(), (double)b.getHeight());
        if (tx.isIdentity()) {
            this.pathElements = shape;
        } else {
            FXTransformPathBuilder builder = new FXTransformPathBuilder((PathBuilder)new FXPathElementsBuilder(), tx);
            FXShapes.buildPathElements((PathBuilder)builder, (Iterable)shape);
            this.pathElements = VectorList.copyOf((Iterable)((Iterable)builder.build()));
        }
    }
}

