/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.draw.figure;

import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import javafx.geometry.BoundingBox;
import javafx.geometry.Bounds;
import javafx.geometry.Point2D;
import javafx.geometry.Rectangle2D;
import javafx.scene.Node;
import javafx.scene.shape.Ellipse;
import javafx.scene.shape.Shape;
import javafx.scene.shape.StrokeType;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.css.value.CssSize;
import org.jhotdraw8.draw.connector.Connector;
import org.jhotdraw8.draw.connector.EllipseConnector;
import org.jhotdraw8.draw.css.value.CssRectangle2D;
import org.jhotdraw8.draw.figure.AbstractLeafFigure;
import org.jhotdraw8.draw.figure.CompositableFigure;
import org.jhotdraw8.draw.figure.ConnectableFigure;
import org.jhotdraw8.draw.figure.Figure;
import org.jhotdraw8.draw.figure.FillableFigure;
import org.jhotdraw8.draw.figure.HideableFigure;
import org.jhotdraw8.draw.figure.LockableFigure;
import org.jhotdraw8.draw.figure.PathIterableFigure;
import org.jhotdraw8.draw.figure.ResizableFigure;
import org.jhotdraw8.draw.figure.StrokableFigure;
import org.jhotdraw8.draw.figure.StyleableFigure;
import org.jhotdraw8.draw.figure.TransformableFigure;
import org.jhotdraw8.draw.key.CssPoint2DStyleableMapAccessor;
import org.jhotdraw8.draw.key.CssSizeStyleableKey;
import org.jhotdraw8.draw.locator.BoundsLocator;
import org.jhotdraw8.draw.render.RenderContext;
import org.jhotdraw8.fxcollection.typesafekey.MapAccessor;
import org.jhotdraw8.fxcollection.typesafekey.NonNullMapAccessor;
import org.jhotdraw8.geom.FXShapes;

public class EllipseFigure
extends AbstractLeafFigure
implements StrokableFigure,
ResizableFigure,
FillableFigure,
TransformableFigure,
HideableFigure,
StyleableFigure,
LockableFigure,
CompositableFigure,
ConnectableFigure,
PathIterableFigure {
    public static final @NonNull CssSizeStyleableKey CENTER_X = new CssSizeStyleableKey("centerX", CssSize.ZERO);
    public static final @NonNull CssSizeStyleableKey CENTER_Y = new CssSizeStyleableKey("centerY", CssSize.ZERO);
    public static final @NonNull CssPoint2DStyleableMapAccessor CENTER = new CssPoint2DStyleableMapAccessor("center", (NonNullMapAccessor<CssSize>)CENTER_X, (NonNullMapAccessor<CssSize>)CENTER_Y);
    public static final @NonNull CssSizeStyleableKey RADIUS_X = new CssSizeStyleableKey("radiusX", CssSize.ONE);
    public static final @NonNull CssSizeStyleableKey RADIUS_Y = new CssSizeStyleableKey("radiusY", CssSize.ONE);
    public static final @NonNull CssPoint2DStyleableMapAccessor RADIUS = new CssPoint2DStyleableMapAccessor("radius", (NonNullMapAccessor<CssSize>)RADIUS_X, (NonNullMapAccessor<CssSize>)RADIUS_Y);
    public static final String TYPE_SELECTOR = "Ellipse";

    public EllipseFigure() {
        this(0.0, 0.0, 2.0, 2.0);
    }

    public EllipseFigure(double x, double y, double width, double height) {
        this.reshapeInLocal(x, y, width, height);
    }

    public EllipseFigure(@NonNull Rectangle2D rect) {
        this.reshapeInLocal(rect.getMinX(), rect.getMinY(), rect.getWidth(), rect.getHeight());
    }

    @Override
    public @NonNull Node createNode(@NonNull RenderContext drawingView) {
        Ellipse n = new Ellipse();
        n.setManaged(false);
        return n;
    }

    @Override
    public @Nullable Connector findConnector(@NonNull Point2D p, Figure prototype, double tolerance) {
        return new EllipseConnector(new BoundsLocator(this.getLayoutBounds(), p));
    }

    @Override
    public @NonNull Bounds getLayoutBounds() {
        double rx = ((CssSize)this.getNonNull((NonNullMapAccessor)RADIUS_X)).getConvertedValue();
        double ry = ((CssSize)this.getNonNull((NonNullMapAccessor)RADIUS_Y)).getConvertedValue();
        double cx = ((CssSize)this.getNonNull((NonNullMapAccessor)CENTER_X)).getConvertedValue();
        double cy = ((CssSize)this.getNonNull((NonNullMapAccessor)CENTER_Y)).getConvertedValue();
        return new BoundingBox(cx - rx, cy - ry, rx * 2.0, ry * 2.0);
    }

    @Override
    public @NonNull CssRectangle2D getCssLayoutBounds() {
        CssSize rx = (CssSize)this.getNonNull((NonNullMapAccessor)RADIUS_X);
        CssSize ry = (CssSize)this.getNonNull((NonNullMapAccessor)RADIUS_Y);
        return new CssRectangle2D(((CssSize)this.getNonNull((NonNullMapAccessor)CENTER_X)).subtract(rx), ((CssSize)this.getNonNull((NonNullMapAccessor)CENTER_Y)).subtract(ry), rx.multiply(2.0), ry.multiply(2.0));
    }

    @Override
    public @NonNull PathIterator getPathIterator(@NonNull RenderContext ctx, @Nullable AffineTransform tx) {
        Ellipse shape = new Ellipse();
        shape.setCenterX(((CssSize)this.getStyledNonNull(CENTER_X)).getConvertedValue());
        shape.setCenterY(((CssSize)this.getStyledNonNull(CENTER_Y)).getConvertedValue());
        double strokeWidth = ((CssSize)this.getStyledNonNull(STROKE_WIDTH)).getConvertedValue();
        double offset = switch ((StrokeType)this.getStyledNonNull(STROKE_TYPE)) {
            default -> 0.0;
            case StrokeType.INSIDE -> -strokeWidth * 0.5;
            case StrokeType.OUTSIDE -> strokeWidth * 0.5;
        };
        shape.setRadiusX(((CssSize)this.getStyledNonNull(RADIUS_X)).getConvertedValue() + offset);
        shape.setRadiusY(((CssSize)this.getStyledNonNull(RADIUS_Y)).getConvertedValue() + offset);
        return FXShapes.fxShapeToAwtShape((Shape)shape).getPathIterator(tx);
    }

    public @NonNull String getTypeSelector() {
        return TYPE_SELECTOR;
    }

    @Override
    public void reshapeInLocal(@NonNull CssSize x, @NonNull CssSize y, @NonNull CssSize width, @NonNull CssSize height) {
        CssSize rx = CssSize.max((CssSize)width.multiply(0.5), (CssSize)CssSize.ZERO);
        CssSize ry = CssSize.max((CssSize)height.multiply(0.5), (CssSize)CssSize.ZERO);
        this.set((MapAccessor)CENTER_X, x.add(rx));
        this.set((MapAccessor)CENTER_Y, y.add(ry));
        this.set((MapAccessor)RADIUS_X, rx);
        this.set((MapAccessor)RADIUS_Y, ry);
    }

    @Override
    public void updateNode(@NonNull RenderContext ctx, @NonNull Node node) {
        Ellipse n = (Ellipse)node;
        this.applyHideableFigureProperties(ctx, (Node)n);
        this.applyTransformableFigureProperties(ctx, (Node)n);
        this.applyStrokableFigureProperties(ctx, (Shape)n);
        this.applyFillableFigureProperties(ctx, (Shape)n);
        this.applyCompositableFigureProperties(ctx, (Node)n);
        this.applyStyleableFigureProperties(ctx, node);
        n.setCenterX(((CssSize)this.getStyledNonNull(CENTER_X)).getConvertedValue());
        n.setCenterY(((CssSize)this.getStyledNonNull(CENTER_Y)).getConvertedValue());
        n.setRadiusX(((CssSize)this.getStyledNonNull(RADIUS_X)).getConvertedValue());
        n.setRadiusY(((CssSize)this.getStyledNonNull(RADIUS_Y)).getConvertedValue());
        n.applyCss();
    }
}

