/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.draw.figure;

import java.net.URI;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.geometry.BoundingBox;
import javafx.geometry.Bounds;
import javafx.geometry.Point2D;
import javafx.geometry.Rectangle2D;
import javafx.scene.Node;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.transform.Transform;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.base.converter.SimpleUriResolver;
import org.jhotdraw8.css.value.CssSize;
import org.jhotdraw8.draw.connector.Connector;
import org.jhotdraw8.draw.connector.RectangleConnector;
import org.jhotdraw8.draw.css.value.CssRectangle2D;
import org.jhotdraw8.draw.figure.AbstractLeafFigure;
import org.jhotdraw8.draw.figure.CompositableFigure;
import org.jhotdraw8.draw.figure.ConnectableFigure;
import org.jhotdraw8.draw.figure.Drawing;
import org.jhotdraw8.draw.figure.Figure;
import org.jhotdraw8.draw.figure.HideableFigure;
import org.jhotdraw8.draw.figure.ImageableFigure;
import org.jhotdraw8.draw.figure.LockableFigure;
import org.jhotdraw8.draw.figure.RectangleFigure;
import org.jhotdraw8.draw.figure.ResizableFigure;
import org.jhotdraw8.draw.figure.StyleableFigure;
import org.jhotdraw8.draw.figure.TransformableFigure;
import org.jhotdraw8.draw.key.CssRectangle2DStyleableMapAccessor;
import org.jhotdraw8.draw.key.CssSizeStyleableKey;
import org.jhotdraw8.draw.locator.BoundsLocator;
import org.jhotdraw8.draw.render.RenderContext;
import org.jhotdraw8.fxcollection.typesafekey.MapAccessor;

public class ImageFigure
extends AbstractLeafFigure
implements ResizableFigure,
TransformableFigure,
StyleableFigure,
LockableFigure,
CompositableFigure,
ConnectableFigure,
HideableFigure,
ImageableFigure {
    public static final String TYPE_SELECTOR = "Image";
    public static final @NonNull CssSizeStyleableKey X = RectangleFigure.X;
    public static final @NonNull CssSizeStyleableKey Y = RectangleFigure.Y;
    public static final @NonNull CssSizeStyleableKey WIDTH = RectangleFigure.WIDTH;
    public static final @NonNull CssSizeStyleableKey HEIGHT = RectangleFigure.HEIGHT;
    public static final @NonNull CssRectangle2DStyleableMapAccessor BOUNDS = RectangleFigure.BOUNDS;
    private @Nullable Image cachedImage;
    private @Nullable URI cachedImageUri;

    public ImageFigure() {
        this(0.0, 0.0, 1.0, 1.0);
    }

    public ImageFigure(double x, double y, double width, double height) {
        this.set((MapAccessor)BOUNDS, new CssRectangle2D(x, y, width, height));
    }

    public ImageFigure(CssRectangle2D rect) {
        this.set((MapAccessor)BOUNDS, rect);
    }

    @Override
    public @NonNull CssRectangle2D getCssLayoutBounds() {
        return (CssRectangle2D)this.getNonNull(BOUNDS);
    }

    @Override
    public void reshapeInLocal(@NonNull Transform transform) {
        Rectangle2D r = ((CssRectangle2D)this.getNonNull(BOUNDS)).getConvertedValue();
        BoundingBox b = new BoundingBox(r.getMinX(), r.getMinY(), r.getWidth(), r.getHeight());
        b = transform.transform((Bounds)b);
        this.reshapeInLocal(b.getMinX(), b.getMinY(), b.getWidth(), b.getHeight());
    }

    @Override
    public void reshapeInLocal(@NonNull CssSize x, @NonNull CssSize y, @NonNull CssSize width, @NonNull CssSize height) {
        this.set((MapAccessor)BOUNDS, new CssRectangle2D(width.getValue() < 0.0 ? x.add(width) : x, height.getValue() < 0.0 ? y.add(height) : y, width.abs(), height.abs()));
    }

    @Override
    public @NonNull Node createNode(@NonNull RenderContext drawingView) {
        ImageView n = new ImageView();
        n.setPreserveRatio(false);
        n.setManaged(false);
        return n;
    }

    @Override
    public void updateNode(@NonNull RenderContext ctx, @NonNull Node node) {
        ImageView imageView = (ImageView)node;
        this.validateImage();
        imageView.setImage(this.cachedImage);
        this.applyTransformableFigureProperties(ctx, (Node)imageView);
        this.applyCompositableFigureProperties(ctx, node);
        this.applyStyleableFigureProperties(ctx, node);
        this.applyHideableFigureProperties(ctx, node);
        Rectangle2D r = ((CssRectangle2D)this.getNonNull(BOUNDS)).getConvertedValue();
        imageView.setX(r.getMinX());
        imageView.setY(r.getMinY());
        imageView.setFitWidth(r.getWidth());
        imageView.setFitHeight(r.getHeight());
        imageView.applyCss();
        imageView.getProperties().put((Object)IMAGE_URI, this.get((MapAccessor)IMAGE_URI));
    }

    @Override
    public @Nullable Connector findConnector(@NonNull Point2D p, Figure prototype, double tolerance) {
        return new RectangleConnector(new BoundsLocator(this.getLayoutBounds(), p));
    }

    public @NonNull String getTypeSelector() {
        return TYPE_SELECTOR;
    }

    @Override
    public double getPreferredAspectRatio() {
        return this.cachedImage == null || this.cachedImage.getWidth() == 0.0 || this.cachedImage.getHeight() == 0.0 ? super.getPreferredAspectRatio() : this.cachedImage.getHeight() / this.cachedImage.getWidth();
    }

    private void validateImage() {
        URI uri = (URI)this.getStyled((MapAccessor)IMAGE_URI);
        if (uri == null) {
            this.cachedImageUri = null;
            this.cachedImage = null;
            return;
        }
        Drawing drawing = this.getDrawing();
        URI documentHome = drawing == null ? null : (URI)drawing.get((MapAccessor)Drawing.DOCUMENT_HOME);
        URI absoluteUri = new SimpleUriResolver().absolutize(documentHome, uri);
        if (this.cachedImageUri == null || !this.cachedImageUri.equals(absoluteUri)) {
            this.cachedImageUri = absoluteUri;
            try {
                this.cachedImage = new Image(this.cachedImageUri.toString(), true);
            }
            catch (IllegalArgumentException e) {
                System.err.println("could not load image from uri: " + String.valueOf(absoluteUri));
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, "Unexpected Exception " + e.getMessage(), e);
            }
        }
    }

    @Override
    public @NonNull Bounds getBoundsInLocal() {
        return this.getLayoutBounds();
    }
}

