/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.draw.figure;

import java.util.ArrayList;
import java.util.List;
import javafx.collections.ObservableList;
import javafx.geometry.BoundingBox;
import javafx.geometry.Bounds;
import javafx.geometry.Insets;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.ClosePath;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;
import javafx.scene.shape.PathElement;
import javafx.scene.shape.Rectangle;
import javafx.scene.shape.Shape;
import javafx.scene.shape.StrokeType;
import javafx.scene.transform.Scale;
import javafx.scene.transform.Transform;
import javafx.scene.transform.Translate;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.css.value.CssSize;
import org.jhotdraw8.draw.css.value.CssDimension2D;
import org.jhotdraw8.draw.css.value.CssInsets;
import org.jhotdraw8.draw.css.value.CssPoint2D;
import org.jhotdraw8.draw.css.value.CssRectangle2D;
import org.jhotdraw8.draw.figure.AbstractCompositeFigure;
import org.jhotdraw8.draw.figure.Figure;
import org.jhotdraw8.draw.figure.FillableFigure;
import org.jhotdraw8.draw.figure.Grouping;
import org.jhotdraw8.draw.figure.HideableFigure;
import org.jhotdraw8.draw.figure.LockableFigure;
import org.jhotdraw8.draw.figure.Page;
import org.jhotdraw8.draw.figure.RectangleFigure;
import org.jhotdraw8.draw.figure.ResizableFigure;
import org.jhotdraw8.draw.figure.StrokableFigure;
import org.jhotdraw8.draw.figure.StyleableFigure;
import org.jhotdraw8.draw.figure.TransformableFigure;
import org.jhotdraw8.draw.key.CssInsetsStyleableMapAccessor;
import org.jhotdraw8.draw.key.CssPoint2DStyleableMapAccessor;
import org.jhotdraw8.draw.key.CssRectangle2DStyleableMapAccessor;
import org.jhotdraw8.draw.key.CssSizeStyleableKey;
import org.jhotdraw8.draw.key.DoubleStyleableKey;
import org.jhotdraw8.draw.key.PaperSizeStyleableMapAccessor;
import org.jhotdraw8.draw.key.Point2DStyleableMapAccessor;
import org.jhotdraw8.draw.render.RenderContext;
import org.jhotdraw8.draw.render.RenderingIntent;
import org.jhotdraw8.fxcollection.typesafekey.MapAccessor;
import org.jhotdraw8.fxcollection.typesafekey.NonNullMapAccessor;
import org.jhotdraw8.geom.FXRectangles;
import org.jhotdraw8.geom.FXTransforms;
import org.jhotdraw8.icollection.VectorList;

public class PageFigure
extends AbstractCompositeFigure
implements Page,
Grouping,
TransformableFigure,
ResizableFigure,
HideableFigure,
LockableFigure,
StyleableFigure,
FillableFigure,
StrokableFigure {
    public static final @NonNull CssSizeStyleableKey HEIGHT = RectangleFigure.HEIGHT;
    public static final @NonNull DoubleStyleableKey NUM_PAGES_X = new DoubleStyleableKey("num-pages-x", 1.0);
    public static final @NonNull DoubleStyleableKey NUM_PAGES_Y = new DoubleStyleableKey("num-pages-y", 1.0);
    public static final @NonNull Point2DStyleableMapAccessor NUM_PAGES_X_Y = new Point2DStyleableMapAccessor("num-pages", (NonNullMapAccessor<Double>)NUM_PAGES_X, (NonNullMapAccessor<Double>)NUM_PAGES_Y);
    public static final @NonNull CssSizeStyleableKey PAGE_INSETS_BOTTOM = new CssSizeStyleableKey("page-insets-bottom", CssSize.ZERO);
    public static final @NonNull CssSizeStyleableKey PAGE_INSETS_LEFT = new CssSizeStyleableKey("page-insets-left", CssSize.ZERO);
    public static final @NonNull CssSizeStyleableKey PAGE_INSETS_RIGHT = new CssSizeStyleableKey("page-insets-right", CssSize.ZERO);
    public static final @NonNull CssSizeStyleableKey PAGE_INSETS_TOP = new CssSizeStyleableKey("page-insets-top", CssSize.ZERO);
    public static final @NonNull CssInsetsStyleableMapAccessor PAGE_INSETS = new CssInsetsStyleableMapAccessor("page-insets", (NonNullMapAccessor<CssSize>)PAGE_INSETS_TOP, (NonNullMapAccessor<CssSize>)PAGE_INSETS_RIGHT, (NonNullMapAccessor<CssSize>)PAGE_INSETS_BOTTOM, (NonNullMapAccessor<CssSize>)PAGE_INSETS_LEFT);
    public static final @NonNull CssSizeStyleableKey PAGE_OVERLAP_X = new CssSizeStyleableKey("page-overlap-x", CssSize.ZERO);
    public static final @NonNull CssSizeStyleableKey PAGE_OVERLAP_Y = new CssSizeStyleableKey("page-overlap-y", CssSize.ZERO);
    public static final @NonNull CssPoint2DStyleableMapAccessor PAGE_OVERLAP = new CssPoint2DStyleableMapAccessor("page-overlap", (NonNullMapAccessor<CssSize>)PAGE_OVERLAP_X, (NonNullMapAccessor<CssSize>)PAGE_OVERLAP_Y);
    public static final @NonNull CssSizeStyleableKey PAPER_HEIGHT = new CssSizeStyleableKey("paper-size-height", CssSize.of((double)297.0, (String)"mm"));
    public static final @NonNull CssSizeStyleableKey PAPER_WIDTH = new CssSizeStyleableKey("paper-size-width", CssSize.of((double)210.0, (String)"mm"));
    public static final @NonNull PaperSizeStyleableMapAccessor PAPER_SIZE = new PaperSizeStyleableMapAccessor("paper-size", (NonNullMapAccessor<CssSize>)PAPER_WIDTH, (NonNullMapAccessor<CssSize>)PAPER_HEIGHT);
    public static final String TYPE_SELECTOR = "Page";
    public static final CssSizeStyleableKey WIDTH = RectangleFigure.WIDTH;
    public static final CssSizeStyleableKey X = RectangleFigure.X;
    public static final CssSizeStyleableKey Y = RectangleFigure.Y;
    public static final CssRectangle2DStyleableMapAccessor BOUNDS = RectangleFigure.BOUNDS;
    private static final Object CONTENT_BOUNDS_PROPERTY = new Object();
    private static final Object PAGE_INSETS_PROPERTY = new Object();
    private static final Object PAGE_BOUNDS_PROPERTY = new Object();
    private static final Object CURRENT_PAGE_PROPERTY = new Object();

    private void addBounds(@NonNull List<PathElement> pbList, @NonNull Bounds b) {
        double x = b.getMinX();
        double y = b.getMinY();
        double w = b.getWidth();
        double h = b.getHeight();
        pbList.add((PathElement)new MoveTo(x, y));
        pbList.add((PathElement)new LineTo(x + w, y));
        pbList.add((PathElement)new LineTo(x + w, y + h));
        pbList.add((PathElement)new LineTo(x, y + h));
        pbList.add((PathElement)new ClosePath());
    }

    private double computeContentAreaFactor() {
        return 1.0;
    }

    @Override
    public @NonNull Node createNode(@NonNull RenderContext ctx) {
        Group n = new Group();
        n.setManaged(false);
        n.setAutoSizeChildren(false);
        Rectangle contentBoundsNode = new Rectangle();
        contentBoundsNode.setFill(null);
        contentBoundsNode.setStroke((Paint)Color.LIGHTGRAY);
        contentBoundsNode.setStrokeType(StrokeType.INSIDE);
        Path pageBoundsNode = new Path();
        Path insetsBoundsNode = new Path();
        insetsBoundsNode.setFill(null);
        insetsBoundsNode.setStroke((Paint)Color.LIGHTGRAY);
        insetsBoundsNode.setStrokeType(StrokeType.CENTERED);
        insetsBoundsNode.getStrokeDashArray().setAll((Object[])new Double[]{5.0});
        Group currentPageNode = new Group();
        n.getChildren().addAll((Object[])new Node[]{pageBoundsNode, insetsBoundsNode, contentBoundsNode, currentPageNode});
        n.getProperties().put(PAGE_BOUNDS_PROPERTY, (Object)pageBoundsNode);
        n.getProperties().put(PAGE_INSETS_PROPERTY, (Object)insetsBoundsNode);
        n.getProperties().put(CONTENT_BOUNDS_PROPERTY, (Object)contentBoundsNode);
        n.getProperties().put(CURRENT_PAGE_PROPERTY, (Object)currentPageNode);
        return n;
    }

    @Override
    public @NonNull Node createPageNode(int internalPageNumber) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public @NonNull Bounds getLayoutBounds() {
        return this.getCssLayoutBounds().getConvertedBoundsValue();
    }

    @Override
    public @NonNull CssRectangle2D getCssLayoutBounds() {
        return new CssRectangle2D((CssSize)this.getNonNull((NonNullMapAccessor)X), (CssSize)this.getNonNull((NonNullMapAccessor)Y), (CssSize)this.getNonNull((NonNullMapAccessor)WIDTH), (CssSize)this.getNonNull((NonNullMapAccessor)HEIGHT));
    }

    @Override
    public int getNumberOfSubPages() {
        int numPagesX = Math.max(1, ((Double)this.getStyledNonNull(NUM_PAGES_X)).intValue());
        int numPagesY = Math.max(1, ((Double)this.getStyledNonNull(NUM_PAGES_Y)).intValue());
        return numPagesX * numPagesY;
    }

    @Override
    public @NonNull Bounds getPageBounds(int internalPageNumber) {
        double contentAreaFactor = this.computeContentAreaFactor();
        Insets insets = this.getStyledNonNull(PAGE_INSETS).getConvertedValue();
        CssPoint2D overlap = this.getStyledNonNull(PAGE_OVERLAP);
        double overX = overlap.getX().getConvertedValue();
        double overY = overlap.getY().getConvertedValue();
        int numPagesX = Math.max(1, ((Double)this.getStyledNonNull(NUM_PAGES_X)).intValue());
        double pageX = ((CssSize)this.getNonNull((NonNullMapAccessor)X)).getConvertedValue() - insets.getLeft() * contentAreaFactor;
        double pageY = ((CssSize)this.getNonNull((NonNullMapAccessor)Y)).getConvertedValue() - insets.getTop() * contentAreaFactor;
        double pageW = ((CssSize)this.getStyledNonNull(PAPER_WIDTH)).getConvertedValue() * contentAreaFactor;
        double pageH = ((CssSize)this.getStyledNonNull(PAPER_HEIGHT)).getConvertedValue() * contentAreaFactor;
        double pageOverX = (overX + insets.getLeft() + insets.getRight()) * contentAreaFactor;
        double pageOverY = (overY + insets.getTop() + insets.getBottom()) * contentAreaFactor;
        int px = internalPageNumber % numPagesX;
        int py = internalPageNumber / numPagesX;
        double x = pageX + (pageW - pageOverX) * (double)px;
        double y = pageY + (pageH - pageOverY) * (double)py;
        return new BoundingBox(x, y, pageW, pageH);
    }

    private @NonNull Bounds getContentBounds(int internalPageNumber) {
        double contentAreaFactor = this.computeContentAreaFactor();
        Insets insets = this.getStyledNonNull(PAGE_INSETS).getConvertedValue();
        CssPoint2D overlap = this.getStyledNonNull(PAGE_OVERLAP);
        double overX = overlap.getX().getConvertedValue();
        double overY = overlap.getY().getConvertedValue();
        int numPagesX = Math.max(1, ((Double)this.getStyledNonNull(NUM_PAGES_X)).intValue());
        double pageX = ((CssSize)this.getNonNull((NonNullMapAccessor)X)).getConvertedValue();
        double pageY = ((CssSize)this.getNonNull((NonNullMapAccessor)Y)).getConvertedValue();
        double pageW = ((CssSize)this.getNonNull((NonNullMapAccessor)PAPER_WIDTH)).getConvertedValue() * contentAreaFactor;
        double pageH = ((CssSize)this.getNonNull((NonNullMapAccessor)PAPER_HEIGHT)).getConvertedValue() * contentAreaFactor;
        double marginH = insets.getLeft() + insets.getRight();
        double marginV = insets.getTop() + insets.getBottom();
        double pageOverX = (overX + marginH) * contentAreaFactor;
        double pageOverY = (overY + marginV) * contentAreaFactor;
        int px = internalPageNumber % numPagesX;
        int py = internalPageNumber / numPagesX;
        double x = pageX + (pageW - pageOverX) * (double)px;
        double y = pageY + (pageH - pageOverY) * (double)py;
        return new BoundingBox(x, y, pageW - marginH * contentAreaFactor, pageH - marginV * contentAreaFactor);
    }

    @Override
    public @NonNull Shape getPageClip(int internalPageNumber) {
        double contentAreaFactor = this.computeContentAreaFactor();
        Insets insets = this.getStyledNonNull(PAGE_INSETS).getConvertedValue();
        CssPoint2D overlap = this.getStyledNonNull(PAGE_OVERLAP);
        double ox = overlap.getX().getConvertedValue();
        double oy = overlap.getY().getConvertedValue();
        int numPagesX = Math.max(1, ((Double)this.getStyledNonNull(NUM_PAGES_X)).intValue());
        double pageX = ((CssSize)this.getNonNull((NonNullMapAccessor)X)).getConvertedValue() - insets.getLeft() * contentAreaFactor;
        double pageY = ((CssSize)this.getNonNull((NonNullMapAccessor)Y)).getConvertedValue() - insets.getTop() * contentAreaFactor;
        double pageWidth = ((CssSize)this.getNonNull((NonNullMapAccessor)PAPER_WIDTH)).getConvertedValue() * contentAreaFactor;
        double pageHeight = ((CssSize)this.getNonNull((NonNullMapAccessor)PAPER_HEIGHT)).getConvertedValue() * contentAreaFactor;
        double pageOverlapX = (ox + insets.getLeft() + insets.getRight()) * contentAreaFactor;
        double pageOverlapY = (oy + insets.getTop() + insets.getBottom()) * contentAreaFactor;
        int px = internalPageNumber % numPagesX;
        int py = internalPageNumber / numPagesX;
        double x = pageX + (pageWidth - pageOverlapX) * (double)px;
        double y = pageY + (pageHeight - pageOverlapY) * (double)py;
        Bounds b = FXRectangles.intersection((Bounds)this.getLayoutBounds(), (Bounds)new BoundingBox(x + insets.getLeft() * contentAreaFactor, y + insets.getTop() * contentAreaFactor, pageWidth - (insets.getLeft() + insets.getRight()) * contentAreaFactor, pageHeight - (insets.getTop() + insets.getBottom()) * contentAreaFactor));
        return new Rectangle(b.getMinX(), b.getMinY(), b.getWidth(), b.getHeight());
    }

    @Override
    public CssDimension2D getPaperSize() {
        return (CssDimension2D)this.getStyled((MapAccessor)PAPER_SIZE);
    }

    @Override
    public @NonNull Transform getPageTransform(int internalPageNumber) {
        int numPagesX = Math.max(1, ((Double)this.getStyledNonNull(NUM_PAGES_X)).intValue());
        int numPagesY = Math.max(1, ((Double)this.getStyledNonNull(NUM_PAGES_Y)).intValue());
        internalPageNumber = Math.max(0, Math.min(internalPageNumber, numPagesX * numPagesY));
        int px = internalPageNumber % numPagesX;
        int py = internalPageNumber / numPagesX;
        Insets insets = this.getStyledNonNull(PAGE_INSETS).getConvertedValue();
        CssPoint2D overlap = this.getStyledNonNull(PAGE_OVERLAP);
        double overlapX = overlap.getX().getConvertedValue();
        double overlapY = overlap.getY().getConvertedValue();
        double contentAreaFactor = this.computeContentAreaFactor();
        double pageX = ((CssSize)this.getNonNull((NonNullMapAccessor)X)).getConvertedValue() - insets.getLeft() * contentAreaFactor;
        double pageY = ((CssSize)this.getNonNull((NonNullMapAccessor)Y)).getConvertedValue() - insets.getTop() * contentAreaFactor;
        double pageWidth = ((CssSize)this.getNonNull((NonNullMapAccessor)PAPER_WIDTH)).getConvertedValue() * contentAreaFactor;
        double pageHeight = ((CssSize)this.getNonNull((NonNullMapAccessor)PAPER_HEIGHT)).getConvertedValue() * contentAreaFactor;
        double pageOverlapX = (overlapX + insets.getLeft() + insets.getRight()) * contentAreaFactor;
        double pageOverlapY = (overlapY + insets.getTop() + insets.getBottom()) * contentAreaFactor;
        double x = pageX + (pageWidth - pageOverlapX) * (double)px;
        double y = pageY + (pageHeight - pageOverlapY) * (double)py;
        return FXTransforms.concat((Transform[])new Transform[]{new Translate(x, y), new Scale(contentAreaFactor, contentAreaFactor)});
    }

    private @NonNull Translate getPageTranslate(int internalPageNumber) {
        int numPagesX = Math.max(1, ((Double)this.getStyledNonNull(NUM_PAGES_X)).intValue());
        int numPagesY = Math.max(1, ((Double)this.getStyledNonNull(NUM_PAGES_Y)).intValue());
        internalPageNumber = Math.max(0, Math.min(internalPageNumber, numPagesX * numPagesY));
        int px = internalPageNumber % numPagesX;
        int py = internalPageNumber / numPagesX;
        Insets insets = this.getStyledNonNull(PAGE_INSETS).getConvertedValue();
        CssPoint2D overlap = this.getStyledNonNull(PAGE_OVERLAP);
        double overlapX = overlap.getX().getConvertedValue();
        double overlapY = overlap.getY().getConvertedValue();
        double contentAreaFactor = this.computeContentAreaFactor();
        double pageX = ((CssSize)this.getNonNull((NonNullMapAccessor)X)).getConvertedValue() - insets.getLeft() * contentAreaFactor;
        double pageY = ((CssSize)this.getNonNull((NonNullMapAccessor)Y)).getConvertedValue() - insets.getTop() * contentAreaFactor;
        double pageWidth = ((CssSize)this.getNonNull((NonNullMapAccessor)PAPER_WIDTH)).getConvertedValue() * contentAreaFactor;
        double pageHeight = ((CssSize)this.getNonNull((NonNullMapAccessor)PAPER_HEIGHT)).getConvertedValue() * contentAreaFactor;
        double pageOverlapX = (overlapX + insets.getLeft() + insets.getRight()) * contentAreaFactor;
        double pageOverlapY = (overlapY + insets.getTop() + insets.getBottom()) * contentAreaFactor;
        double x = (pageWidth - pageOverlapX) * (double)px;
        double y = (pageHeight - pageOverlapY) * (double)py;
        return new Translate(x, y);
    }

    public @NonNull String getTypeSelector() {
        return TYPE_SELECTOR;
    }

    @Override
    public boolean isLayoutable() {
        return true;
    }

    @Override
    public boolean isSuitableChild(@NonNull Figure newChild) {
        return true;
    }

    @Override
    public void layout(@NonNull RenderContext ctx) {
        CssSize width = (CssSize)this.get((MapAccessor)WIDTH);
        CssSize height = (CssSize)this.get((MapAccessor)HEIGHT);
        CssDimension2D paperSize = this.getPaperSize();
        CssInsets pageInsets = (CssInsets)this.getStyled((MapAccessor)PAGE_INSETS);
        CssPoint2D pageOverlap = (CssPoint2D)this.get((MapAccessor)PAGE_OVERLAP);
        CssDimension2D innerPageSize = paperSize.subtract(new CssDimension2D(pageInsets.getLeft().add(pageInsets.getRight()), pageInsets.getTop().add(pageInsets.getBottom())));
        int numPagesX = 1 + Math.max(0, (int)Math.ceil(width.subtract(innerPageSize.getWidth()).getConvertedValue() / innerPageSize.getWidth().subtract(pageOverlap.getX()).getConvertedValue()));
        int numPagesY = 1 + Math.max(0, (int)Math.ceil(height.subtract(innerPageSize.getHeight()).getConvertedValue() / innerPageSize.getHeight().subtract(pageOverlap.getY()).getConvertedValue()));
        this.set((MapAccessor)NUM_PAGES_X, numPagesX);
        this.set((MapAccessor)NUM_PAGES_Y, numPagesY);
        int currentPage = 0;
        Transform pageTransform = this.getPageTransform(currentPage);
        VectorList transforms = VectorList.of();
        if (!pageTransform.isIdentity()) {
            transforms = transforms.add((Object)pageTransform);
        }
        for (Figure child : this.getChildren()) {
            child.set((MapAccessor)TRANSFORMS, transforms);
        }
    }

    @Override
    public void reshapeInLocal(@NonNull CssSize x, @NonNull CssSize y, @NonNull CssSize width, @NonNull CssSize height) {
        this.set((MapAccessor)X, width.getValue() < 0.0 ? x.add(width) : x);
        this.set((MapAccessor)Y, height.getValue() < 0.0 ? y.add(height) : y);
        this.set((MapAccessor)WIDTH, width.abs());
        this.set((MapAccessor)HEIGHT, height.abs());
    }

    @Override
    public void reshapeInLocal(@NonNull Transform transform) {
        Bounds newBounds = transform.transform(this.getLayoutBounds());
        this.set((MapAccessor)X, CssSize.of((double)newBounds.getMinX()));
        this.set((MapAccessor)Y, CssSize.of((double)newBounds.getMinY()));
        this.set((MapAccessor)WIDTH, CssSize.of((double)newBounds.getWidth()));
        this.set((MapAccessor)HEIGHT, CssSize.of((double)newBounds.getHeight()));
    }

    @Override
    public void updateNode(@NonNull RenderContext ctx, @NonNull Node node) {
        Group groupNode = (Group)node;
        node.getTransforms().setAll((Object[])new Transform[]{this.getLocalToParent(true)});
        Rectangle contentBoundsNode = (Rectangle)groupNode.getProperties().get(CONTENT_BOUNDS_PROPERTY);
        Path pageBoundsNode = (Path)groupNode.getProperties().get(PAGE_BOUNDS_PROPERTY);
        Path pageInsetsNode = (Path)groupNode.getProperties().get(PAGE_INSETS_PROPERTY);
        Group currentPageNode = (Group)groupNode.getProperties().get(CURRENT_PAGE_PROPERTY);
        this.applyFillableFigureProperties(ctx, (Shape)pageBoundsNode);
        this.applyStrokableFigureProperties(ctx, (Shape)pageBoundsNode);
        if (ctx.get((MapAccessor)RenderContext.RENDERING_INTENT) == RenderingIntent.EDITOR) {
            this.applyHideableFigureProperties(ctx, node);
            contentBoundsNode.setVisible(true);
            pageBoundsNode.setVisible(true);
        } else if (ctx.get((MapAccessor)RenderContext.RENDER_PAGE) == this) {
            this.applyHideableFigureProperties(ctx, node);
            contentBoundsNode.setVisible(false);
            pageBoundsNode.setVisible(false);
            pageInsetsNode.setVisible(false);
        } else {
            node.setVisible(false);
        }
        double contentWidth = ((CssSize)this.getNonNull((NonNullMapAccessor)WIDTH)).getConvertedValue();
        double contentHeight = ((CssSize)this.getNonNull((NonNullMapAccessor)HEIGHT)).getConvertedValue();
        contentBoundsNode.setX(((CssSize)this.getNonNull((NonNullMapAccessor)X)).getConvertedValue());
        contentBoundsNode.setY(((CssSize)this.getNonNull((NonNullMapAccessor)Y)).getConvertedValue());
        contentBoundsNode.setWidth(contentWidth);
        contentBoundsNode.setHeight(contentHeight);
        int numPagesX = Math.max(1, ((Double)this.getStyledNonNull(NUM_PAGES_X)).intValue());
        int numPagesY = Math.max(1, ((Double)this.getStyledNonNull(NUM_PAGES_Y)).intValue());
        int n = numPagesX * numPagesY;
        ArrayList<PathElement> pbList = new ArrayList<PathElement>(n * 4);
        ArrayList<PathElement> pmList = new ArrayList<PathElement>(n * 4);
        for (int i = 0; i < n; ++i) {
            this.addBounds(pbList, this.getPageBounds(i));
            this.addBounds(pmList, this.getContentBounds(i));
        }
        pageBoundsNode.getElements().setAll(pbList);
        pageInsetsNode.getElements().setAll(pmList);
        Integer currentPage = (Integer)ctx.get((MapAccessor)RenderContext.RENDER_PAGE_INTERNAL_NUMBER);
        currentPageNode.getTransforms().setAll((Object[])new Transform[]{this.getPageTranslate(currentPage == null ? 0 : currentPage)});
        ArrayList<Node> currentPageChildren = new ArrayList<Node>(this.getChildren().size() + 2);
        for (Figure child : this.getChildren()) {
            currentPageChildren.add(ctx.getNode(child));
        }
        ObservableList group = currentPageNode.getChildren();
        if (!group.equals(currentPageChildren)) {
            group.setAll(currentPageChildren);
        }
    }
}

