/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.draw.figure;

import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.util.ArrayList;
import java.util.List;
import javafx.geometry.BoundingBox;
import javafx.geometry.Bounds;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.shape.Polygon;
import javafx.scene.shape.Shape;
import javafx.scene.transform.Transform;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.css.value.CssSize;
import org.jhotdraw8.draw.connector.Connector;
import org.jhotdraw8.draw.connector.PathConnector;
import org.jhotdraw8.draw.css.value.CssPoint2D;
import org.jhotdraw8.draw.css.value.CssRectangle2D;
import org.jhotdraw8.draw.figure.AbstractLeafFigure;
import org.jhotdraw8.draw.figure.CompositableFigure;
import org.jhotdraw8.draw.figure.ConnectableFigure;
import org.jhotdraw8.draw.figure.Figure;
import org.jhotdraw8.draw.figure.FillableFigure;
import org.jhotdraw8.draw.figure.HideableFigure;
import org.jhotdraw8.draw.figure.LockableFigure;
import org.jhotdraw8.draw.figure.PathIterableFigure;
import org.jhotdraw8.draw.figure.PolylineFigure;
import org.jhotdraw8.draw.figure.ResizableFigure;
import org.jhotdraw8.draw.figure.StrokableFigure;
import org.jhotdraw8.draw.figure.StyleableFigure;
import org.jhotdraw8.draw.figure.TransformableFigure;
import org.jhotdraw8.draw.handle.Handle;
import org.jhotdraw8.draw.handle.HandleType;
import org.jhotdraw8.draw.handle.PolyPointEditHandle;
import org.jhotdraw8.draw.handle.PolygonOutlineHandle;
import org.jhotdraw8.draw.key.Point2DListStyleableKey;
import org.jhotdraw8.draw.locator.BoundsLocator;
import org.jhotdraw8.draw.render.RenderContext;
import org.jhotdraw8.fxcollection.typesafekey.MapAccessor;
import org.jhotdraw8.fxcollection.typesafekey.NonNullMapAccessor;
import org.jhotdraw8.geom.FXShapes;
import org.jhotdraw8.geom.FXTransforms;
import org.jhotdraw8.icollection.VectorList;
import org.jhotdraw8.icollection.immutable.ImmutableList;

public class PolygonFigure
extends AbstractLeafFigure
implements StrokableFigure,
FillableFigure,
HideableFigure,
StyleableFigure,
LockableFigure,
CompositableFigure,
TransformableFigure,
ResizableFigure,
ConnectableFigure,
PathIterableFigure {
    public static final String TYPE_SELECTOR = "Polygon";
    public static final Point2DListStyleableKey POINTS = PolylineFigure.POINTS;

    public PolygonFigure() {
        this(0.0, 0.0, 1.0, 1.0);
    }

    public PolygonFigure(double startX, double startY, double endX, double endY) {
        this.set((MapAccessor)POINTS, VectorList.of((Object[])new Point2D[]{new Point2D(startX, startY), new Point2D(endX, endY)}));
    }

    public PolygonFigure(Point2D ... points) {
        this.set((MapAccessor)POINTS, VectorList.of((Object[])points));
    }

    @Override
    public @NonNull Bounds getLayoutBounds() {
        double minX = Double.POSITIVE_INFINITY;
        double minY = Double.POSITIVE_INFINITY;
        double maxX = Double.NEGATIVE_INFINITY;
        double maxY = Double.NEGATIVE_INFINITY;
        for (Point2D p : (ImmutableList)this.getNonNull((NonNullMapAccessor)POINTS)) {
            minX = Math.min(minX, p.getX());
            minY = Math.min(minY, p.getY());
            maxX = Math.max(maxX, p.getX());
            maxY = Math.max(maxY, p.getY());
        }
        return new BoundingBox(minX, minY, maxX - minX, maxY - minY);
    }

    @Override
    public @NonNull CssRectangle2D getCssLayoutBounds() {
        return new CssRectangle2D(this.getLayoutBounds());
    }

    @Override
    public @NonNull PathIterator getPathIterator(@NonNull RenderContext ctx, @Nullable AffineTransform tx) {
        return FXShapes.fxPointsToAwtPathIterator((List)((ImmutableList)this.getNonNull((NonNullMapAccessor)POINTS)).asList(), (boolean)true, (int)0, (AffineTransform)tx);
    }

    @Override
    public void reshapeInLocal(@NonNull Transform transform) {
        List newP = ((ImmutableList)this.getNonNull((NonNullMapAccessor)POINTS)).toMutable();
        int n = newP.size();
        for (int i = 0; i < n; ++i) {
            newP.set(i, FXTransforms.transform((Transform)transform, (Point2D)((Point2D)newP.get(i))));
        }
        this.set((MapAccessor)POINTS, VectorList.copyOf((Iterable)newP));
    }

    @Override
    public void translateInLocal(@NonNull CssPoint2D t) {
        List newP = ((ImmutableList)this.getNonNull((NonNullMapAccessor)POINTS)).toMutable();
        int n = newP.size();
        for (int i = 0; i < n; ++i) {
            newP.set(i, ((Point2D)newP.get(i)).add(t.getConvertedValue()));
        }
        this.set((MapAccessor)POINTS, VectorList.copyOf((Iterable)newP));
    }

    @Override
    public @NonNull Node createNode(@NonNull RenderContext drawingView) {
        Polygon n = new Polygon();
        n.setManaged(false);
        return n;
    }

    @Override
    public void updateNode(@NonNull RenderContext ctx, @NonNull Node node) {
        Polygon lineNode = (Polygon)node;
        this.applyHideableFigureProperties(ctx, node);
        this.applyFillableFigureProperties(ctx, (Shape)lineNode);
        this.applyStyleableFigureProperties(ctx, node);
        this.applyStrokableFigureProperties(ctx, (Shape)lineNode);
        this.applyTransformableFigureProperties(ctx, node);
        this.applyCompositableFigureProperties(ctx, (Node)lineNode);
        ImmutableList points = (ImmutableList)this.getStyled((MapAccessor)POINTS);
        ArrayList<Double> list = new ArrayList<Double>(points.size() * 2);
        for (Point2D p : points) {
            if (p == null) continue;
            list.add(p.getX());
            list.add(p.getY());
        }
        lineNode.getPoints().setAll(list);
        lineNode.applyCss();
    }

    @Override
    public @Nullable Connector findConnector(@NonNull Point2D p, Figure prototype, double tolerance) {
        return new PathConnector(new BoundsLocator(this.getLayoutBounds(), p));
    }

    @Override
    public void createHandles(@NonNull HandleType handleType, @NonNull List<Handle> list) {
        if (handleType == HandleType.SELECT) {
            list.add(new PolygonOutlineHandle(this, (NonNullMapAccessor<ImmutableList<Point2D>>)POINTS, false));
        } else if (handleType == HandleType.POINT) {
            list.add(new PolygonOutlineHandle(this, (NonNullMapAccessor<ImmutableList<Point2D>>)POINTS, true));
            int n = ((ImmutableList)this.get((MapAccessor)POINTS)).size();
            for (int i = 0; i < n; ++i) {
                list.add(new PolyPointEditHandle(this, (NonNullMapAccessor<ImmutableList<Point2D>>)POINTS, i));
            }
        } else {
            super.createHandles(handleType, list);
        }
    }

    @Override
    public void reshapeInLocal(@NonNull CssSize x, @NonNull CssSize y, @NonNull CssSize width, @NonNull CssSize height) {
        this.reshapeInLocal(FXTransforms.createReshapeTransform((Bounds)this.getLayoutBounds(), (double)x.getConvertedValue(), (double)y.getConvertedValue(), (double)width.getConvertedValue(), (double)height.getConvertedValue()));
    }

    public @NonNull String getTypeSelector() {
        return TYPE_SELECTOR;
    }
}

