/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.draw.figure;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Objects;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Shape;
import javafx.scene.shape.StrokeLineCap;
import javafx.scene.shape.StrokeLineJoin;
import javafx.scene.shape.StrokeType;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.css.converter.SizeCssConverter;
import org.jhotdraw8.css.value.CssSize;
import org.jhotdraw8.draw.css.value.Paintable;
import org.jhotdraw8.draw.figure.Figure;
import org.jhotdraw8.draw.key.CssSizeStyleableKey;
import org.jhotdraw8.draw.key.NonNullEnumStyleableKey;
import org.jhotdraw8.draw.key.NonNullListStyleableKey;
import org.jhotdraw8.draw.key.NullablePaintableStyleableKey;
import org.jhotdraw8.draw.key.StrokeStyleableMapAccessor;
import org.jhotdraw8.draw.render.RenderContext;
import org.jhotdraw8.fxcollection.typesafekey.MapAccessor;
import org.jhotdraw8.fxcollection.typesafekey.NonNullMapAccessor;
import org.jhotdraw8.icollection.VectorList;
import org.jhotdraw8.icollection.immutable.ImmutableList;

public interface SecondStrokableFigure
extends Figure {
    public static final @Nullable CssSizeStyleableKey SECOND_STROKE_DASH_OFFSET = new CssSizeStyleableKey("second-stroke-dashoffset", CssSize.ZERO);
    public static final NonNullEnumStyleableKey<StrokeLineCap> SECOND_STROKE_LINE_CAP = new NonNullEnumStyleableKey<StrokeLineCap>("second-stroke-linecap", StrokeLineCap.class, StrokeLineCap.BUTT);
    public static final NonNullEnumStyleableKey<StrokeLineJoin> SECOND_STROKE_LINE_JOIN = new NonNullEnumStyleableKey<StrokeLineJoin>("second-stroke-linejoin", StrokeLineJoin.class, StrokeLineJoin.MITER);
    public static final CssSizeStyleableKey SECOND_STROKE_MITER_LIMIT = new CssSizeStyleableKey("second-stroke-miterlimit", CssSize.of((double)4.0));
    public static final @NonNull NullablePaintableStyleableKey SECOND_STROKE = new NullablePaintableStyleableKey("second-stroke", null);
    public static final NonNullEnumStyleableKey<StrokeType> SECOND_STROKE_TYPE = new NonNullEnumStyleableKey<StrokeType>("second-stroke-type", StrokeType.class, StrokeType.CENTERED);
    public static final CssSizeStyleableKey SECOND_STROKE_WIDTH = new CssSizeStyleableKey("second-stroke-width", CssSize.ONE);
    public static final NonNullListStyleableKey<CssSize> SECOND_STROKE_DASH_ARRAY = new NonNullListStyleableKey("second-stroke-dasharray", (Type)((Object)CssSize.class), new SizeCssConverter(false), VectorList.of());
    public static final @Nullable StrokeStyleableMapAccessor STROKE_STYLE = new StrokeStyleableMapAccessor("second-stroke-style", (MapAccessor<StrokeType>)SECOND_STROKE_TYPE, (MapAccessor<StrokeLineCap>)SECOND_STROKE_LINE_CAP, (MapAccessor<StrokeLineJoin>)SECOND_STROKE_LINE_JOIN, (MapAccessor<CssSize>)SECOND_STROKE_MITER_LIMIT, (MapAccessor<CssSize>)SECOND_STROKE_DASH_OFFSET, (MapAccessor<ImmutableList<CssSize>>)SECOND_STROKE_DASH_ARRAY);

    default public void applySecondStrokeCapAndJoinProperties(@NonNull RenderContext ctx, @NonNull Shape shape) {
        StrokeLineCap slp = (StrokeLineCap)this.getStyled((MapAccessor)SECOND_STROKE_LINE_CAP);
        if (shape.getStrokeLineCap() != slp) {
            shape.setStrokeLineCap(slp);
        }
        StrokeLineJoin slj = (StrokeLineJoin)this.getStyled((MapAccessor)SECOND_STROKE_LINE_JOIN);
        if (shape.getStrokeLineJoin() != slj) {
            shape.setStrokeLineJoin(slj);
        }
        double d = ((CssSize)this.getStyledNonNull((NonNullMapAccessor)SECOND_STROKE_MITER_LIMIT)).getConvertedValue();
        if (shape.getStrokeMiterLimit() != d) {
            shape.setStrokeMiterLimit(d);
        }
    }

    default public void applySecondStrokeDashProperties(@NonNull RenderContext ctx, @NonNull Shape shape) {
        ImmutableList dashArray;
        double d = ((CssSize)this.getStyledNonNull((NonNullMapAccessor)SECOND_STROKE_DASH_OFFSET)).getConvertedValue();
        if (shape.getStrokeDashOffset() != d) {
            shape.setStrokeDashOffset(d);
        }
        if ((dashArray = (ImmutableList)this.getStyledNonNull((NonNullMapAccessor)SECOND_STROKE_DASH_ARRAY)).isEmpty()) {
            shape.getStrokeDashArray().clear();
        } else {
            ArrayList<Double> list = new ArrayList<Double>(dashArray.size());
            for (CssSize sz : dashArray) {
                list.add(sz.getConvertedValue());
            }
            shape.getStrokeDashArray().setAll(list);
        }
    }

    default public void applySecondStrokeTypeProperties(@NonNull RenderContext ctx, @NonNull Shape shape) {
        StrokeType st = (StrokeType)this.getStyled((MapAccessor)SECOND_STROKE_TYPE);
        if (shape.getStrokeType() != st) {
            shape.setStrokeType(st);
        }
    }

    default public void applySecondStrokeableFigureProperties(@NonNull RenderContext ctx, @NonNull Shape shape) {
        this.applySecondStrokeColorProperties(ctx, shape);
        this.applySecondStrokeWidthProperties(ctx, shape);
        this.applySecondStrokeCapAndJoinProperties(ctx, shape);
        this.applySecondStrokeTypeProperties(ctx, shape);
        this.applySecondStrokeDashProperties(ctx, shape);
    }

    default public void applySecondStrokeColorProperties(@NonNull RenderContext ctx, @NonNull Shape shape) {
        Paint p = Paintable.getPaint((Paintable)this.getStyled((MapAccessor)SECOND_STROKE), ctx);
        if (!Objects.equals(shape.getStroke(), p)) {
            shape.setStroke(p);
        }
    }

    default public void applySecondStrokeWidthProperties(@NonNull RenderContext ctx, @NonNull Shape shape) {
        double d = ((CssSize)this.getStyledNonNull((NonNullMapAccessor)SECOND_STROKE_WIDTH)).getConvertedValue();
        if (shape.getStrokeWidth() != d) {
            shape.setStrokeWidth(d);
        }
    }
}

