/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.draw.figure;

import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import javafx.geometry.BoundingBox;
import javafx.geometry.Bounds;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.shape.Shape;
import javafx.scene.text.Text;
import javafx.scene.text.TextBoundsType;
import javafx.scene.transform.Transform;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.css.value.CssSize;
import org.jhotdraw8.draw.connector.Connector;
import org.jhotdraw8.draw.connector.RectangleConnector;
import org.jhotdraw8.draw.css.value.CssPoint2D;
import org.jhotdraw8.draw.css.value.CssRectangle2D;
import org.jhotdraw8.draw.figure.AbstractLeafFigure;
import org.jhotdraw8.draw.figure.CompositableFigure;
import org.jhotdraw8.draw.figure.ConnectableFigure;
import org.jhotdraw8.draw.figure.Figure;
import org.jhotdraw8.draw.figure.FillableFigure;
import org.jhotdraw8.draw.figure.HideableFigure;
import org.jhotdraw8.draw.figure.LockableFigure;
import org.jhotdraw8.draw.figure.PathIterableFigure;
import org.jhotdraw8.draw.figure.StrokableFigure;
import org.jhotdraw8.draw.figure.StyleableFigure;
import org.jhotdraw8.draw.figure.TextEditableFigure;
import org.jhotdraw8.draw.figure.TextFontableFigure;
import org.jhotdraw8.draw.figure.TextLayoutableFigure;
import org.jhotdraw8.draw.figure.TextableFigure;
import org.jhotdraw8.draw.figure.TransformableFigure;
import org.jhotdraw8.draw.key.CssPoint2DStyleableKey;
import org.jhotdraw8.draw.locator.BoundsLocator;
import org.jhotdraw8.draw.render.RenderContext;
import org.jhotdraw8.draw.render.SimpleRenderContext;
import org.jhotdraw8.fxcollection.typesafekey.MapAccessor;
import org.jhotdraw8.fxcollection.typesafekey.NonNullMapAccessor;
import org.jhotdraw8.geom.FXShapes;
import org.jhotdraw8.geom.FXTransforms;

public class TextFigure
extends AbstractLeafFigure
implements StrokableFigure,
FillableFigure,
TransformableFigure,
TextFontableFigure,
TextLayoutableFigure,
TextableFigure,
HideableFigure,
StyleableFigure,
LockableFigure,
CompositableFigure,
ConnectableFigure,
PathIterableFigure,
TextEditableFigure {
    public static final String TYPE_SELECTOR = "Text";
    public static final CssPoint2DStyleableKey ORIGIN = new CssPoint2DStyleableKey("origin", new CssPoint2D(0.0, 0.0));
    private Text textNode;

    public TextFigure() {
        this(0.0, 0.0, "");
    }

    public TextFigure(@NonNull Point2D position, String text) {
        this(position.getX(), position.getY(), text);
    }

    public TextFigure(double x, double y, String text) {
        this.set((MapAccessor)TEXT, text);
        this.set((MapAccessor)ORIGIN, new CssPoint2D(x, y));
    }

    @Override
    public @NonNull Bounds getLayoutBounds() {
        if (this.textNode == null) {
            this.layout(new SimpleRenderContext());
        }
        Bounds b = this.textNode.getLayoutBounds();
        return new BoundingBox(b.getMinX(), b.getMinY(), b.getWidth(), b.getHeight());
    }

    @Override
    public @NonNull TextEditableFigure.TextEditorData getTextEditorDataFor(Point2D pointInLocal, Node node) {
        return new TextEditableFigure.TextEditorData(this, this.getLayoutBounds(), (MapAccessor<String>)TEXT);
    }

    @Override
    public void layout(@NonNull RenderContext ctx) {
        if (this.textNode == null) {
            this.textNode = new Text();
        }
        this.updateNode(ctx, (Node)this.textNode);
    }

    @Override
    public @NonNull CssRectangle2D getCssLayoutBounds() {
        return new CssRectangle2D(this.getLayoutBounds());
    }

    @Override
    public void reshapeInLocal(@NonNull Transform transform) {
        Point2D o = ((CssPoint2D)this.getNonNull((NonNullMapAccessor)ORIGIN)).getConvertedValue();
        o = FXTransforms.transform((Transform)transform, (Point2D)o);
        this.set((MapAccessor)ORIGIN, new CssPoint2D(o));
    }

    @Override
    public void reshapeInLocal(@NonNull CssSize x, @NonNull CssSize y, @NonNull CssSize width, @NonNull CssSize height) {
        Bounds b = this.getLayoutBounds();
        this.reshapeInLocal((Transform)Transform.translate((double)(x.getConvertedValue() - b.getMinX()), (double)(y.getConvertedValue() - b.getMinY())));
    }

    @Override
    public @NonNull Node createNode(@NonNull RenderContext drawingView) {
        Text n = new Text();
        n.setManaged(false);
        return n;
    }

    @Override
    public void updateNode(@NonNull RenderContext ctx, @NonNull Node node) {
        Text tn = (Text)node;
        tn.setX(((CssPoint2D)this.getStyledNonNull(ORIGIN)).getX().getConvertedValue());
        tn.setY(((CssPoint2D)this.getStyledNonNull(ORIGIN)).getY().getConvertedValue());
        tn.setBoundsType(TextBoundsType.VISUAL);
        this.applyHideableFigureProperties(ctx, node);
        this.applyTransformableFigureProperties(ctx, (Node)tn);
        this.applyTextableFigureProperties(ctx, tn);
        this.applyStrokableFigureProperties(ctx, (Shape)tn);
        this.applyFillableFigureProperties(ctx, (Shape)tn);
        this.applyCompositableFigureProperties(ctx, (Node)tn);
        this.applyTextFontableFigureProperties(ctx, tn);
        this.applyTextLayoutableFigureProperties(ctx, tn);
        this.applyStyleableFigureProperties(ctx, node);
        tn.setText((String)this.get((MapAccessor)TEXT));
    }

    @Override
    public @Nullable Connector findConnector(@NonNull Point2D p, Figure prototype, double tolerance) {
        return new RectangleConnector(new BoundsLocator(this.getLayoutBounds(), p));
    }

    public @NonNull String getTypeSelector() {
        return TYPE_SELECTOR;
    }

    @Override
    public @NonNull PathIterator getPathIterator(@NonNull RenderContext ctx, @Nullable AffineTransform tx) {
        if (this.textNode == null) {
            this.layout(new SimpleRenderContext());
        }
        return FXShapes.fxShapeToAwtShape((Shape)this.textNode).getPathIterator(tx);
    }
}

