/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.draw.figure;

import javafx.geometry.HPos;
import javafx.geometry.VPos;
import javafx.scene.control.Labeled;
import javafx.scene.text.FontSmoothingType;
import javafx.scene.text.Text;
import javafx.scene.text.TextAlignment;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.css.value.CssSize;
import org.jhotdraw8.css.value.DefaultUnitConverter;
import org.jhotdraw8.css.value.UnitConverter;
import org.jhotdraw8.draw.figure.Figure;
import org.jhotdraw8.draw.figure.TextFontableFigure;
import org.jhotdraw8.draw.key.CssSizeStyleableKey;
import org.jhotdraw8.draw.key.DoubleStyleableKey;
import org.jhotdraw8.draw.key.NonNullEnumStyleableKey;
import org.jhotdraw8.draw.render.RenderContext;
import org.jhotdraw8.draw.render.RenderingIntent;
import org.jhotdraw8.fxcollection.typesafekey.MapAccessor;
import org.jhotdraw8.fxcollection.typesafekey.NonNullMapAccessor;

public interface TextLayoutableFigure
extends Figure {
    public static final @Nullable CssSizeStyleableKey LINE_SPACING = new CssSizeStyleableKey("lineSpacing", CssSize.ZERO);
    public static final NonNullEnumStyleableKey<TextAlignment> TEXT_ALIGNMENT = new NonNullEnumStyleableKey<TextAlignment>("textAlignment", TextAlignment.class, TextAlignment.LEFT);
    public static final NonNullEnumStyleableKey<VPos> TEXT_VPOS = new NonNullEnumStyleableKey<VPos>("textVPos", VPos.class, VPos.BASELINE);
    public static final NonNullEnumStyleableKey<HPos> TEXT_HPOS = new NonNullEnumStyleableKey<HPos>("textHPos", HPos.class, HPos.LEFT);
    public static final DoubleStyleableKey WRAPPING_WIDTH = new DoubleStyleableKey("wrappingWidth", 0.0);

    default public void applyTextLayoutableFigureProperties(@Nullable RenderContext ctx, @NonNull Text text) {
        FontSmoothingType fst;
        CssSize fontSize;
        DefaultUnitConverter units = ctx == null ? DefaultUnitConverter.getInstance() : (UnitConverter)ctx.getNonNull((NonNullMapAccessor)RenderContext.UNIT_CONVERTER_KEY);
        CssSize lineSpacing = (CssSize)this.getStyledNonNull((NonNullMapAccessor)LINE_SPACING);
        double d = "%".equals(lineSpacing.getUnits()) ? ((fontSize = (CssSize)this.getStyled((MapAccessor)TextFontableFigure.FONT_SIZE)) != null ? lineSpacing.getValue() * units.convert(fontSize, "") / 100.0 : units.convert(lineSpacing, "")) : units.convert(lineSpacing, "");
        if (text.getLineSpacing() != d) {
            text.setLineSpacing(d);
        }
        d = (Double)this.getStyledNonNull((NonNullMapAccessor)WRAPPING_WIDTH);
        if (text.getWrappingWidth() != d) {
            text.setWrappingWidth(d);
        }
        TextAlignment ta = (TextAlignment)this.getStyledNonNull((NonNullMapAccessor)TEXT_ALIGNMENT);
        if (text.getTextAlignment() != ta) {
            text.setTextAlignment(ta);
        }
        VPos vp = (VPos)this.getStyledNonNull((NonNullMapAccessor)TEXT_VPOS);
        if (text.getTextOrigin() != vp) {
            text.setTextOrigin(vp);
        }
        FontSmoothingType fontSmoothingType = fst = ctx == null || ctx.getNonNull((NonNullMapAccessor)RenderContext.RENDERING_INTENT) == RenderingIntent.EDITOR ? FontSmoothingType.LCD : FontSmoothingType.GRAY;
        if (text.getFontSmoothingType() != fst) {
            text.setFontSmoothingType(fst);
        }
    }

    default public void applyTextLayoutableFigureProperties(@Nullable RenderContext ctx, @NonNull Labeled text) {
        DefaultUnitConverter units = ctx == null ? DefaultUnitConverter.getInstance() : (UnitConverter)ctx.getNonNull((NonNullMapAccessor)RenderContext.UNIT_CONVERTER_KEY);
        double d = units.convert((CssSize)this.getStyledNonNull((NonNullMapAccessor)LINE_SPACING), "");
        if (text.getLineSpacing() == d) {
            text.setLineSpacing(d);
        }
        TextAlignment ta = (TextAlignment)this.getStyledNonNull((NonNullMapAccessor)TEXT_ALIGNMENT);
        if (text.getTextAlignment() == ta) {
            text.setTextAlignment(ta);
        }
    }
}

