/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.draw.figure;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javafx.collections.ObservableList;
import javafx.geometry.Bounds;
import javafx.geometry.Point2D;
import javafx.geometry.Point3D;
import javafx.scene.Node;
import javafx.scene.transform.Affine;
import javafx.scene.transform.NonInvertibleTransformException;
import javafx.scene.transform.Rotate;
import javafx.scene.transform.Scale;
import javafx.scene.transform.Transform;
import javafx.scene.transform.Translate;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.base.converter.Converter;
import org.jhotdraw8.draw.css.converter.Translate3DCssConverter;
import org.jhotdraw8.draw.css.value.CssPoint2D;
import org.jhotdraw8.draw.figure.Figure;
import org.jhotdraw8.draw.figure.TransformCachingFigure;
import org.jhotdraw8.draw.key.CssPoint2DStyleableKey;
import org.jhotdraw8.draw.key.DoubleStyleableKey;
import org.jhotdraw8.draw.key.Point3DStyleableMapAccessor;
import org.jhotdraw8.draw.key.Scale3DStyleableMapAccessor;
import org.jhotdraw8.draw.key.TransformListStyleableKey;
import org.jhotdraw8.draw.render.RenderContext;
import org.jhotdraw8.fxcollection.typesafekey.Key;
import org.jhotdraw8.fxcollection.typesafekey.MapAccessor;
import org.jhotdraw8.fxcollection.typesafekey.NonNullMapAccessor;
import org.jhotdraw8.fxcollection.typesafekey.NonNullObjectKey;
import org.jhotdraw8.geom.FXPreciseRotate;
import org.jhotdraw8.geom.FXRectangles;
import org.jhotdraw8.geom.FXTransforms;
import org.jhotdraw8.icollection.VectorList;
import org.jhotdraw8.icollection.immutable.ImmutableList;

public interface TransformableFigure
extends TransformCachingFigure,
Figure {
    public static final boolean CACHE = true;
    public static final @NonNull DoubleStyleableKey ROTATE = new DoubleStyleableKey("rotate", 0.0);
    public static final @NonNull CssPoint2DStyleableKey ROTATION_PIVOT = new CssPoint2DStyleableKey("rotation-pivot", new CssPoint2D(0.5, 0.5));
    public static final @NonNull NonNullObjectKey<Point3D> ROTATION_AXIS = new NonNullObjectKey("rotationAxis", Point3D.class, (Object)Rotate.Z_AXIS);
    public static final @NonNull DoubleStyleableKey SCALE_X = new DoubleStyleableKey("scaleX", 1.0);
    public static final @NonNull DoubleStyleableKey SCALE_Y = new DoubleStyleableKey("scaleY", 1.0);
    public static final @NonNull DoubleStyleableKey SCALE_Z = new DoubleStyleableKey("scaleZ", 1.0);
    public static final @NonNull Scale3DStyleableMapAccessor SCALE = new Scale3DStyleableMapAccessor("scale", (MapAccessor<Double>)SCALE_X, (MapAccessor<Double>)SCALE_Y, (MapAccessor<Double>)SCALE_Z);
    public static final @NonNull TransformListStyleableKey TRANSFORMS = new TransformListStyleableKey("transform", (ImmutableList<Transform>)VectorList.of());
    public static final @NonNull DoubleStyleableKey TRANSLATE_X = new DoubleStyleableKey("translateX", 0.0);
    public static final @NonNull DoubleStyleableKey TRANSLATE_Y = new DoubleStyleableKey("translateY", 0.0);
    public static final @NonNull DoubleStyleableKey TRANSLATE_Z = new DoubleStyleableKey("translateZ", 0.0);
    public static final @NonNull Point3DStyleableMapAccessor TRANSLATE = new Point3DStyleableMapAccessor("translate", (MapAccessor<Double>)TRANSLATE_X, (MapAccessor<Double>)TRANSLATE_Y, (MapAccessor<Double>)TRANSLATE_Z, (Converter<Point3D>)new Translate3DCssConverter(false));

    public static @NonNull Set<Key<?>> getDeclaredKeys() {
        LinkedHashSet keys = new LinkedHashSet();
        Figure.getDeclaredKeys(TransformableFigure.class, keys);
        return keys;
    }

    default public void applyTransformableFigureProperties(@NonNull RenderContext ctx, @NonNull Node node) {
        Transform t = this.getLocalToParent();
        ObservableList transforms = node.getTransforms();
        if (t.isIdentity()) {
            if (!transforms.isEmpty()) {
                transforms.clear();
            }
        } else if (transforms.size() == 1) {
            if (!Objects.equals(transforms.getFirst(), t)) {
                transforms.set(0, t);
            }
        } else {
            transforms.clear();
            transforms.add(t);
        }
    }

    default public void clearTransforms() {
        this.remove((Key)SCALE_X);
        this.remove((Key)SCALE_Y);
        this.remove((Key)ROTATE);
        this.remove((Key)TRANSLATE_X);
        this.remove((Key)TRANSLATE_Y);
        this.remove((Key)TRANSFORMS);
    }

    default public void flattenTransforms() {
        Transform p2l = this.getLocalToParent(false);
        this.remove((Key)SCALE_X);
        this.remove((Key)SCALE_Y);
        this.remove((Key)ROTATE);
        this.remove((Key)TRANSLATE_X);
        this.remove((Key)TRANSLATE_Y);
        if (p2l.isIdentity()) {
            this.remove((Key)TRANSFORMS);
        } else {
            this.set((MapAccessor)TRANSFORMS, VectorList.of((Object[])new Transform[]{p2l}));
        }
    }

    default public @NonNull Transform getInverseTransform() {
        Transform t;
        ImmutableList list = (ImmutableList)this.getStyledNonNull((NonNullMapAccessor)TRANSFORMS);
        if (list.isEmpty()) {
            t = FXTransforms.IDENTITY;
        } else {
            try {
                t = ((Transform)list.get(list.size() - 1)).createInverse();
                for (int i = list.size() - 2; i >= 0; --i) {
                    t = FXTransforms.concat((Transform[])new Transform[]{t, ((Transform)list.get(i)).createInverse()});
                }
            }
            catch (NonInvertibleTransformException e) {
                throw new InternalError(e);
            }
        }
        return t;
    }

    @Override
    default public @NonNull Transform getLocalToParent() {
        return this.getLocalToParent(true);
    }

    default public @NonNull Transform getLocalToParent(boolean styled) {
        Transform l2p;
        Transform transform = l2p = styled ? this.getCachedLocalToParent() : null;
        if (l2p == null) {
            double ty;
            Bounds layoutBounds = this.getLayoutBounds();
            Point2D center = FXRectangles.center((Bounds)layoutBounds);
            ImmutableList transforms = styled ? (ImmutableList)this.getStyled((MapAccessor)TRANSFORMS) : (ImmutableList)this.get((MapAccessor)TRANSFORMS);
            double sx = styled ? ((Double)this.getStyledNonNull((NonNullMapAccessor)SCALE_X)).doubleValue() : ((Double)this.getNonNull((NonNullMapAccessor)SCALE_X)).doubleValue();
            double sy = styled ? ((Double)this.getStyledNonNull((NonNullMapAccessor)SCALE_Y)).doubleValue() : ((Double)this.getNonNull((NonNullMapAccessor)SCALE_Y)).doubleValue();
            double r = styled ? ((Double)this.getStyledNonNull((NonNullMapAccessor)ROTATE)).doubleValue() : ((Double)this.getNonNull((NonNullMapAccessor)ROTATE)).doubleValue();
            double tx = styled ? ((Double)this.getStyledNonNull((NonNullMapAccessor)TRANSLATE_X)).doubleValue() : ((Double)this.getNonNull((NonNullMapAccessor)TRANSLATE_X)).doubleValue();
            double d = ty = styled ? ((Double)this.getStyledNonNull((NonNullMapAccessor)TRANSLATE_Y)).doubleValue() : ((Double)this.getNonNull((NonNullMapAccessor)TRANSLATE_Y)).doubleValue();
            if (tx != 0.0 || ty != 0.0) {
                Translate tt = new Translate(tx, ty);
                l2p = FXTransforms.concat((Transform[])new Transform[]{null, tt});
            }
            if (r != 0.0) {
                CssPoint2D cssPivot = (CssPoint2D)this.getStyledNonNull((NonNullMapAccessor)ROTATION_PIVOT);
                Point2D pivot = CssPoint2D.getPointInBounds(cssPivot, layoutBounds);
                FXPreciseRotate tr = new FXPreciseRotate(r, pivot.getX(), pivot.getY());
                l2p = FXTransforms.concat((Transform[])new Transform[]{l2p, tr});
            }
            if ((sx != 1.0 || sy != 1.0) && sx != 0.0 && sy != 0.0) {
                Scale ts = new Scale(sx, sy, center.getX(), center.getY());
                l2p = FXTransforms.concat((Transform[])new Transform[]{l2p, ts});
            }
            if (transforms != null && !transforms.isEmpty()) {
                l2p = FXTransforms.concat((Transform[])new Transform[]{l2p, this.getTransform()});
            }
            if (l2p == null) {
                l2p = FXTransforms.IDENTITY;
            }
            if (styled) {
                this.setCachedLocalToParent(l2p);
            }
        }
        return l2p;
    }

    default public @NonNull List<Transform> getLocalToParentAsList(boolean styled) {
        double ty;
        ArrayList<Transform> list = new ArrayList<Transform>();
        Point2D center = this.getCenterInLocal();
        ImmutableList t = styled ? (ImmutableList)this.getStyledNonNull((NonNullMapAccessor)TRANSFORMS) : (ImmutableList)this.getNonNull((NonNullMapAccessor)TRANSFORMS);
        double sx = styled ? ((Double)this.getStyledNonNull((NonNullMapAccessor)SCALE_X)).doubleValue() : ((Double)this.getNonNull((NonNullMapAccessor)SCALE_X)).doubleValue();
        double sy = styled ? ((Double)this.getStyledNonNull((NonNullMapAccessor)SCALE_Y)).doubleValue() : ((Double)this.getNonNull((NonNullMapAccessor)SCALE_Y)).doubleValue();
        double r = styled ? ((Double)this.getStyledNonNull((NonNullMapAccessor)ROTATE)).doubleValue() : ((Double)this.getNonNull((NonNullMapAccessor)ROTATE)).doubleValue();
        double tx = styled ? ((Double)this.getStyledNonNull((NonNullMapAccessor)TRANSLATE_X)).doubleValue() : ((Double)this.getNonNull((NonNullMapAccessor)TRANSLATE_X)).doubleValue();
        double d = ty = styled ? ((Double)this.getStyledNonNull((NonNullMapAccessor)TRANSLATE_Y)).doubleValue() : ((Double)this.getNonNull((NonNullMapAccessor)TRANSLATE_Y)).doubleValue();
        if (tx != 0.0 || ty != 0.0) {
            Translate tt = new Translate(tx, ty);
            list.add((Transform)tt);
        }
        if (r != 0.0) {
            FXPreciseRotate tr = new FXPreciseRotate(r, center.getX(), center.getY());
            list.add((Transform)tr);
        }
        if ((sx != 1.0 || sy != 1.0) && sx != 0.0 && sy != 0.0) {
            Scale ts = new Scale(sx, sy, center.getX(), center.getY());
            list.add((Transform)ts);
        }
        if (!t.isEmpty()) {
            list.addAll(t.asList());
        }
        return list;
    }

    @Override
    default public @NonNull Transform getParentToLocal() {
        return this.getParentToLocal(true);
    }

    default public @NonNull Transform getParentToLocal(boolean styled) {
        Transform p2l = this.getCachedParentToLocal();
        if (p2l == null) {
            double ty;
            Point2D center = this.getCenterInLocal();
            ImmutableList transforms = styled ? (ImmutableList)this.getStyledNonNull((NonNullMapAccessor)TRANSFORMS) : (ImmutableList)this.getNonNull((NonNullMapAccessor)TRANSFORMS);
            double sx = styled ? ((Double)this.getStyledNonNull((NonNullMapAccessor)SCALE_X)).doubleValue() : ((Double)this.getNonNull((NonNullMapAccessor)SCALE_X)).doubleValue();
            double sy = styled ? ((Double)this.getStyledNonNull((NonNullMapAccessor)SCALE_Y)).doubleValue() : ((Double)this.getNonNull((NonNullMapAccessor)SCALE_Y)).doubleValue();
            double r = styled ? ((Double)this.getStyledNonNull((NonNullMapAccessor)ROTATE)).doubleValue() : ((Double)this.getNonNull((NonNullMapAccessor)ROTATE)).doubleValue();
            double tx = styled ? ((Double)this.getStyledNonNull((NonNullMapAccessor)TRANSLATE_X)).doubleValue() : ((Double)this.getNonNull((NonNullMapAccessor)TRANSLATE_X)).doubleValue();
            double d = ty = styled ? ((Double)this.getStyledNonNull((NonNullMapAccessor)TRANSLATE_Y)).doubleValue() : ((Double)this.getNonNull((NonNullMapAccessor)TRANSLATE_Y)).doubleValue();
            if (!transforms.isEmpty()) {
                p2l = this.getInverseTransform();
            }
            if ((sx != 1.0 || sy != 1.0) && sx != 0.0 && sy != 0.0) {
                Scale ts = new Scale(1.0 / sx, 1.0 / sy, center.getX(), center.getY());
                p2l = FXTransforms.concat((Transform[])new Transform[]{p2l, ts});
            }
            if (r != 0.0) {
                FXPreciseRotate tr = new FXPreciseRotate(-r, center.getX(), center.getY());
                p2l = FXTransforms.concat((Transform[])new Transform[]{p2l, tr});
            }
            if (tx != 0.0 || ty != 0.0) {
                Translate tt = new Translate(-tx, -ty);
                p2l = FXTransforms.concat((Transform[])new Transform[]{p2l, tt});
            }
            if (p2l == null) {
                p2l = FXTransforms.IDENTITY;
            }
            this.setCachedParentToLocal(p2l);
        }
        return p2l;
    }

    default public @NonNull Transform getTransform() {
        Transform t;
        ImmutableList list = (ImmutableList)this.getStyledNonNull((NonNullMapAccessor)TRANSFORMS);
        if (list.isEmpty()) {
            t = FXTransforms.IDENTITY;
        } else {
            t = (Transform)list.get(0);
            int n = list.size();
            for (int i = 1; i < n; ++i) {
                t = FXTransforms.concat((Transform[])new Transform[]{t, (Transform)list.get(i)});
            }
        }
        return t;
    }

    default public boolean hasCenterTransforms() {
        double sx = (Double)this.getStyledNonNull((NonNullMapAccessor)SCALE_X);
        double sy = (Double)this.getStyledNonNull((NonNullMapAccessor)SCALE_Y);
        double r = (Double)this.getStyledNonNull((NonNullMapAccessor)ROTATE);
        double tx = (Double)this.getStyledNonNull((NonNullMapAccessor)TRANSLATE_X);
        double ty = (Double)this.getStyledNonNull((NonNullMapAccessor)TRANSLATE_Y);
        return sx != 1.0 || sy != 1.0 || r != 0.0 || tx != 0.0 || ty != 0.0;
    }

    @Override
    default public void reshapeInLocal(Transform transform) {
        if (this.hasCenterTransforms() && !(transform instanceof Translate)) {
            ImmutableList ts = (ImmutableList)this.getNonNull((NonNullMapAccessor)TRANSFORMS);
            if (ts.isEmpty()) {
                this.set((MapAccessor)TRANSFORMS, VectorList.of((Object[])new Transform[]{transform}));
            } else {
                int last = ts.size() - 1;
                Transform concatenatedWithLast = FXTransforms.concat((Transform[])new Transform[]{(Transform)ts.get(last), transform});
                if (concatenatedWithLast instanceof Affine) {
                    this.set((MapAccessor)TRANSFORMS, ts.add((Object)transform));
                } else {
                    this.set((MapAccessor)TRANSFORMS, ts.set(last, (Object)concatenatedWithLast));
                }
            }
            return;
        }
        Bounds b = this.getLayoutBounds();
        b = transform.transform(b);
        this.reshapeInLocal(b.getMinX(), b.getMinY(), b.getWidth(), b.getHeight());
    }

    @Override
    default public void reshapeInParent(@NonNull Transform transform) {
        if (transform instanceof Translate) {
            Point2D p = FXTransforms.deltaTransform((Transform)this.getInverseTransform(), (double)transform.getTx(), (double)transform.getTy());
            this.reshapeInLocal((Transform)new Translate(p.getX(), p.getY()));
        } else {
            Transform combined = FXTransforms.concat((Transform[])new Transform[]{transform, this.getTransform()});
            this.set((MapAccessor)TRANSFORMS, VectorList.of((Object[])new Transform[]{combined}));
        }
    }

    default public void setTransforms(Transform ... transforms) {
        if (transforms.length == 1 && transforms[0].isIdentity()) {
            this.set((MapAccessor)TRANSFORMS, VectorList.of());
        } else {
            this.set((MapAccessor)TRANSFORMS, VectorList.of((Object[])transforms));
        }
    }

    @Override
    default public void transformInLocal(@NonNull Transform t) {
        this.flattenTransforms();
        ImmutableList transforms = (ImmutableList)this.getNonNull((NonNullMapAccessor)TRANSFORMS);
        if (transforms.isEmpty()) {
            this.set((MapAccessor)TRANSFORMS, VectorList.of((Object[])new Transform[]{t}));
        } else {
            this.set((MapAccessor)TRANSFORMS, transforms.add((Object)t));
        }
    }

    @Override
    default public void transformInParent(@NonNull Transform t) {
        if (t.isIdentity()) {
            return;
        }
        if (t instanceof Translate) {
            Translate tr = (Translate)t;
            this.flattenTransforms();
            ImmutableList transforms = (ImmutableList)this.getNonNull((NonNullMapAccessor)TRANSFORMS);
            if (transforms.isEmpty()) {
                this.translateInLocal(new CssPoint2D(tr.getTx(), tr.getTy()));
            } else {
                this.set((MapAccessor)TRANSLATE_X, (Double)this.getNonNull((NonNullMapAccessor)TRANSLATE_X) + tr.getTx());
                this.set((MapAccessor)TRANSLATE_Y, (Double)this.getNonNull((NonNullMapAccessor)TRANSLATE_Y) + tr.getTy());
            }
        } else {
            this.flattenTransforms();
            ImmutableList transforms = (ImmutableList)this.getNonNull((NonNullMapAccessor)TRANSFORMS);
            if (transforms.isEmpty()) {
                this.set((MapAccessor)TRANSFORMS, VectorList.of((Object[])new Transform[]{t}));
            } else {
                this.set((MapAccessor)TRANSFORMS, transforms.set(0, (Object)t));
            }
        }
    }
}

