/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.draw.handle;

import javafx.collections.ObservableList;
import javafx.geometry.Bounds;
import javafx.geometry.Point2D;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.shape.Polygon;
import javafx.scene.transform.Transform;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.draw.DrawingEditor;
import org.jhotdraw8.draw.DrawingView;
import org.jhotdraw8.draw.css.value.CssColor;
import org.jhotdraw8.draw.css.value.Paintable;
import org.jhotdraw8.draw.figure.Figure;
import org.jhotdraw8.draw.handle.AbstractHandle;
import org.jhotdraw8.geom.FXRectangles;
import org.jhotdraw8.geom.FXTransforms;

public class AnchorOutlineHandle
extends AbstractHandle {
    private static final double invsqrt2 = 1.0 / Math.sqrt(2.0);
    private final double growInView = 8.0;
    private final Polygon node;
    private final double[] points = new double[8];

    public AnchorOutlineHandle(Figure figure) {
        super(figure);
        this.node = new Polygon(this.points);
        this.initNode(this.node);
    }

    @Override
    public boolean contains(DrawingView dv, double x, double y, double tolerance) {
        return false;
    }

    @Override
    public @Nullable Cursor getCursor() {
        return null;
    }

    @Override
    public Node getNode(@NonNull DrawingView view) {
        DrawingEditor editor = view.getEditor();
        if (editor == null) {
            return this.node;
        }
        CssColor color = editor.getHandleColor();
        this.node.setStroke(Paintable.getPaint(color));
        this.node.setStrokeWidth(editor.getHandleStrokeWidth());
        return this.node;
    }

    protected void initNode(@NonNull Polygon r) {
        r.setFill(null);
    }

    @Override
    public boolean isSelectable() {
        return false;
    }

    @Override
    public void updateNode(@NonNull DrawingView view) {
        Figure f = this.getOwner();
        Transform t = FXTransforms.concat((Transform[])new Transform[]{view.getWorldToView(), f.getLocalToWorld()});
        Transform tinv = FXTransforms.concat((Transform[])new Transform[]{f.getWorldToLocal(), view.getViewToWorld()});
        t = FXTransforms.concat((Transform[])new Transform[]{Transform.translate((double)0.5, (double)0.5), t});
        Bounds b = f.getLayoutBounds();
        double growInLocal = tinv.deltaTransform(new Point2D(8.0 * invsqrt2, 8.0 * invsqrt2)).magnitude();
        b = FXRectangles.grow((Bounds)b, (double)growInLocal, (double)growInLocal);
        this.points[0] = b.getMinX();
        this.points[1] = b.getMinY();
        this.points[2] = b.getMaxX();
        this.points[3] = b.getMinY();
        this.points[4] = b.getMaxX();
        this.points[5] = b.getMaxY();
        this.points[6] = b.getMinX();
        this.points[7] = b.getMaxY();
        if (t.isType2D()) {
            FXTransforms.transform2DPoints((Transform)t, (double[])this.points, (int)0, (double[])this.points, (int)0, (int)4);
        }
        ObservableList pp = this.node.getPoints();
        for (int i = 0; i < this.points.length; ++i) {
            pp.set(i, (Object)this.points[i]);
        }
    }
}

