/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.draw.handle;

import javafx.event.ActionEvent;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.draw.DrawingView;
import org.jhotdraw8.draw.figure.Figure;
import org.jhotdraw8.draw.handle.AbstractBezierNodeHandleAction;
import org.jhotdraw8.fxcollection.typesafekey.MapAccessor;
import org.jhotdraw8.geom.shape.BezierNode;
import org.jhotdraw8.geom.shape.BezierPath;

public class BezierNodeHandleIncomingAndOutgoingTangentAction
extends AbstractBezierNodeHandleAction {
    public static final String ID = "handle.bezierNode.incomingAndOutgoingTangent";

    public BezierNodeHandleIncomingAndOutgoingTangentAction(@NonNull Figure owner, @NonNull MapAccessor<BezierPath> pathKey, int nodeIndex, @NonNull DrawingView view) {
        super(ID, owner, pathKey, nodeIndex, view);
        BezierNode bnode = this.getBezierNode();
        if (bnode != null) {
            this.setSelected((bnode.getMask() & 6) == 6);
        }
    }

    protected void onActionPerformed(@NonNull ActionEvent event) {
        BezierNode bnode = this.getBezierNode();
        BezierPath path = (BezierPath)this.owner.get(this.pathKey);
        if (bnode == null || path == null) {
            return;
        }
        BezierNode changedNode = bnode.withMaskBitsSet(6);
        path = path.set(this.nodeIndex, changedNode);
        this.view.getModel().set(this.owner, this.pathKey, path);
        this.view.recreateHandles();
    }
}

