/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.draw.handle;

import javafx.event.ActionEvent;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.draw.DrawingView;
import org.jhotdraw8.draw.figure.Figure;
import org.jhotdraw8.draw.handle.AbstractBezierNodeHandleAction;
import org.jhotdraw8.fxcollection.typesafekey.MapAccessor;
import org.jhotdraw8.geom.shape.BezierNode;
import org.jhotdraw8.geom.shape.BezierPath;

public class BezierNodeHandleIncomingTangentAction
extends AbstractBezierNodeHandleAction {
    public static final String ID = "handle.bezierNode.incomingTangent";

    public BezierNodeHandleIncomingTangentAction(@NonNull Figure figure, @NonNull MapAccessor<BezierPath> nodeListKey, int nodeIndex, @NonNull DrawingView model) {
        super(ID, figure, nodeListKey, nodeIndex, model);
        BezierNode bnode = this.getBezierNode();
        if (bnode != null) {
            this.setSelected((bnode.getMask() & 6) == 2);
        }
    }

    protected void onActionPerformed(@NonNull ActionEvent event) {
        BezierPath path = (BezierPath)this.owner.get(this.pathKey);
        BezierNode bnode = this.getBezierNode();
        if (path == null || bnode == null) {
            return;
        }
        BezierNode changedNode = bnode.withMaskBitsClears(6).withMaskBitsSet(2);
        path = path.set(this.nodeIndex, changedNode);
        this.view.getModel().set(this.owner, this.pathKey, path);
        this.view.recreateHandles();
    }
}

