/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.draw.handle;

import java.util.HashSet;
import java.util.Set;
import javafx.collections.ObservableList;
import javafx.collections.ObservableSet;
import javafx.geometry.Bounds;
import javafx.geometry.Point2D;
import javafx.geometry.Point3D;
import javafx.scene.Cursor;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.Border;
import javafx.scene.layout.BorderStroke;
import javafx.scene.layout.BorderStrokeStyle;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Circle;
import javafx.scene.shape.ClosePath;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;
import javafx.scene.shape.Rectangle;
import javafx.scene.shape.Shape;
import javafx.scene.transform.Transform;
import javafx.scene.transform.Translate;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.draw.DrawingView;
import org.jhotdraw8.draw.css.value.CssPoint2D;
import org.jhotdraw8.draw.figure.Figure;
import org.jhotdraw8.draw.figure.TransformableFigure;
import org.jhotdraw8.draw.handle.AbstractHandle;
import org.jhotdraw8.draw.model.DrawingModel;
import org.jhotdraw8.fxcollection.typesafekey.MapAccessor;
import org.jhotdraw8.geom.FXTransforms;
import org.jhotdraw8.geom.Points;
import org.jhotdraw8.geom.shape.BezierNode;
import org.jhotdraw8.geom.shape.BezierPath;

public class BezierNodeMoveHandle
extends AbstractHandle {
    private static final @Nullable Background REGION_BACKGROUND = new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.BLUE, null, null)});
    private static final @Nullable Border REGION_BORDER = new Border(new BorderStroke[]{new BorderStroke((Paint)Color.BLUE, BorderStrokeStyle.SOLID, null, null)});
    private static final Circle REGION_SHAPE_CUBIC = new Circle(0.0, 0.0, 4.0);
    private static final Rectangle REGION_SHAPE_LINEAR = new Rectangle(7.0, 7.0);
    private static final Path REGION_SHAPE_QUADRATIC = new Path();
    private Set<Figure> groupReshapeableFigures;
    private final @NonNull Region node;
    private Point2D oldPoint;
    private Point2D pickLocation;
    private final int pointIndex;
    private final @NonNull MapAccessor<BezierPath> pathKey;

    public BezierNodeMoveHandle(@NonNull Figure figure, @NonNull MapAccessor<BezierPath> pathKey, int pointIndex) {
        super(figure);
        this.pathKey = pathKey;
        this.pointIndex = pointIndex;
        this.node = new Region();
        this.node.setShape((Shape)REGION_SHAPE_LINEAR);
        this.node.setManaged(false);
        this.node.setScaleShape(false);
        this.node.setCenterShape(true);
        this.node.resize(11.0, 11.0);
        this.node.setBorder(REGION_BORDER);
        this.node.setBackground(REGION_BACKGROUND);
    }

    @Override
    public boolean contains(DrawingView drawingView, double x, double y, double tolerance) {
        Point2D p = this.getLocationInView();
        return Points.squaredDistance((double)x, (double)y, (double)p.getX(), (double)p.getY()) <= tolerance * tolerance;
    }

    private @Nullable BezierNode getBezierNode() {
        BezierPath path = (BezierPath)this.owner.get(this.pathKey);
        return path == null || path.size() <= this.pointIndex ? null : path.get(this.pointIndex);
    }

    @Override
    public Cursor getCursor() {
        return Cursor.OPEN_HAND;
    }

    private @NonNull Point2D getLocation() {
        BezierNode bezierNode = this.getBezierNode();
        return bezierNode == null ? Point2D.ZERO : (Point2D)bezierNode.getPoint(Point2D::new);
    }

    public Point2D getLocationInView() {
        return this.pickLocation;
    }

    public @NonNull Region getNode(@NonNull DrawingView view) {
        return this.node;
    }

    @Override
    public void onMouseDragged(@NonNull MouseEvent event, @NonNull DrawingView view) {
        Point2D newPoint = view.viewToWorld(new Point2D(event.getX(), event.getY()));
        if (!event.isAltDown() && !event.isControlDown()) {
            newPoint = view.getConstrainer().constrainPoint(this.owner, new CssPoint2D(newPoint)).getConvertedValue();
        }
        if (event.isMetaDown()) {
            Point2D loc = this.getLocation();
            this.oldPoint = this.owner.localToWorld(loc);
        }
        if (this.oldPoint.equals((Object)newPoint)) {
            return;
        }
        DrawingModel model = view.getModel();
        if (event.isShiftDown()) {
            for (Figure f : this.groupReshapeableFigures) {
                BezierNodeMoveHandle.translateFigure(f, this.oldPoint, newPoint, model);
            }
        } else {
            Figure f = this.owner;
            BezierNodeMoveHandle.translateFigure(f, this.oldPoint, newPoint, model);
        }
        this.oldPoint = newPoint;
    }

    @Override
    public void onMousePressed(@NonNull MouseEvent event, @NonNull DrawingView view) {
        this.oldPoint = view.getConstrainer().constrainPoint(this.owner, new CssPoint2D(view.viewToWorld(new Point2D(event.getX(), event.getY())))).getConvertedValue();
        ObservableSet<Figure> selectedFigures = view.getSelectedFigures();
        this.groupReshapeableFigures = new HashSet<Figure>();
        for (Figure f : view.getSelectedFigures()) {
            if (!f.isGroupReshapeableWith((Set<Figure>)selectedFigures)) continue;
            this.groupReshapeableFigures.add(f);
        }
        this.groupReshapeableFigures = view.getFiguresWithCompatibleHandle(this.groupReshapeableFigures, this);
    }

    @Override
    public void onMouseReleased(@NonNull MouseEvent event, @NonNull DrawingView dv) {
    }

    @Override
    public boolean isSelectable() {
        return true;
    }

    @Override
    public void updateNode(@NonNull DrawingView view) {
        Figure f = this.owner;
        Transform t = FXTransforms.concat((Transform[])new Transform[]{view.getWorldToView(), f.getLocalToWorld()});
        Bounds b = f.getLayoutBounds();
        Point2D p = this.getLocation();
        this.pickLocation = p = FXTransforms.transform((Transform)t, (Point2D)p);
        this.node.relocate(p.getX() - 5.0, p.getY() - 5.0);
        this.node.setRotate(((Double)f.getStyled((MapAccessor)TransformableFigure.ROTATE)).doubleValue());
        this.node.setRotationAxis((Point3D)f.getStyled((MapAccessor)TransformableFigure.ROTATION_AXIS));
        BezierNode bn = this.getBezierNode();
        if (bn.hasIn() && bn.hasOut()) {
            this.node.setShape((Shape)REGION_SHAPE_CUBIC);
        } else if (bn.hasIn() || bn.hasOut()) {
            this.node.setShape((Shape)REGION_SHAPE_QUADRATIC);
        } else {
            this.node.setShape((Shape)REGION_SHAPE_LINEAR);
        }
    }

    public static void translateFigure(@NonNull Figure f, @NonNull Point2D oldPoint, @NonNull Point2D newPoint, @Nullable DrawingModel model) {
        Point2D npl = f.worldToParent(newPoint);
        Point2D opl = f.worldToParent(oldPoint);
        Translate tx = Transform.translate((double)(npl.getX() - opl.getX()), (double)(npl.getY() - opl.getY()));
        if (model != null) {
            model.reshapeInParent(f, (Transform)tx);
        } else {
            f.reshapeInParent((Transform)tx);
        }
    }

    static {
        ObservableList elements = REGION_SHAPE_QUADRATIC.getElements();
        elements.add((Object)new MoveTo(0.0, 0.0));
        elements.add((Object)new LineTo(4.0, -4.0));
        elements.add((Object)new LineTo(8.0, 0.0));
        elements.add((Object)new LineTo(4.0, 4.0));
        elements.add((Object)new ClosePath());
    }
}

