/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.draw.handle;

import javafx.collections.ObservableList;
import javafx.geometry.Bounds;
import javafx.scene.Cursor;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Polyline;
import javafx.scene.transform.Transform;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.draw.DrawingView;
import org.jhotdraw8.draw.css.value.CssColor;
import org.jhotdraw8.draw.css.value.CssPoint2D;
import org.jhotdraw8.draw.css.value.Paintable;
import org.jhotdraw8.draw.figure.Figure;
import org.jhotdraw8.draw.figure.LineConnectionFigure;
import org.jhotdraw8.draw.handle.AbstractHandle;
import org.jhotdraw8.geom.FXTransforms;

public class LineOutlineHandle
extends AbstractHandle {
    private final Group node = new Group();
    private final Polyline polyline2;
    private final Polyline polyline1;
    private final double[] points = new double[4];

    public LineOutlineHandle(Figure figure) {
        super(figure);
        this.polyline1 = new Polyline(this.points);
        this.polyline2 = new Polyline(this.points);
        this.node.getChildren().addAll((Object[])new Node[]{this.polyline1, this.polyline2});
    }

    @Override
    public boolean contains(DrawingView dv, double x, double y, double tolerance) {
        return false;
    }

    @Override
    public @Nullable Cursor getCursor() {
        return null;
    }

    @Override
    public Node getNode(@NonNull DrawingView view) {
        CssColor color = view.getEditor().getHandleColor();
        this.polyline1.setStroke((Paint)Color.WHITE);
        this.polyline2.setStroke(Paintable.getPaint(color));
        double strokeWidth = view.getEditor().getHandleStrokeWidth();
        this.polyline1.setStrokeWidth(strokeWidth + 2.0);
        this.polyline2.setStrokeWidth(strokeWidth);
        return this.node;
    }

    @Override
    public boolean isSelectable() {
        return false;
    }

    @Override
    public void updateNode(@NonNull DrawingView view) {
        Figure f = this.getOwner();
        Transform t = FXTransforms.concat((Transform[])new Transform[]{view.getWorldToView(), f.getLocalToWorld()});
        Bounds b = this.getOwner().getLayoutBounds();
        this.points[0] = ((CssPoint2D)f.getNonNull(LineConnectionFigure.START)).getX().getConvertedValue();
        this.points[1] = ((CssPoint2D)f.getNonNull(LineConnectionFigure.START)).getY().getConvertedValue();
        this.points[2] = ((CssPoint2D)f.getNonNull(LineConnectionFigure.END)).getX().getConvertedValue();
        this.points[3] = ((CssPoint2D)f.getNonNull(LineConnectionFigure.END)).getY().getConvertedValue();
        FXTransforms.transform2DPoints((Transform)t, (double[])this.points, (int)0, (double[])this.points, (int)0, (int)2);
        ObservableList pp1 = this.polyline1.getPoints();
        ObservableList pp2 = this.polyline2.getPoints();
        for (int i = 0; i < this.points.length; ++i) {
            pp1.set(i, (Object)this.points[i]);
            pp2.set(i, (Object)this.points[i]);
        }
    }
}

