/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.draw.handle;

import javafx.collections.ObservableList;
import javafx.geometry.Bounds;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Polygon;
import javafx.scene.transform.Transform;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.draw.DrawingView;
import org.jhotdraw8.draw.css.value.CssColor;
import org.jhotdraw8.draw.figure.Figure;
import org.jhotdraw8.draw.handle.AbstractHandle;
import org.jhotdraw8.geom.FXRectangles;

public class MultipleSelectionOutlineHandle
extends AbstractHandle {
    private final Polygon node;
    private final double[] points = new double[8];

    public MultipleSelectionOutlineHandle() {
        super(null);
        this.node = new Polygon(this.points);
        this.initNode(this.node);
    }

    @Override
    public boolean contains(DrawingView dv, double x, double y, double tolerance) {
        return false;
    }

    private @Nullable Bounds getBounds(@NonNull DrawingView dv) {
        Bounds b = null;
        for (Figure f : dv.getSelectedFigures()) {
            Transform l2w = f.getLocalToWorld();
            Bounds fb = l2w.transform(f.getLayoutBounds());
            if (b == null) {
                b = fb;
                continue;
            }
            b = FXRectangles.add((Bounds)b, (Bounds)fb);
        }
        return b == null ? null : dv.getWorldToView().transform(b);
    }

    @Override
    public @Nullable Cursor getCursor() {
        return null;
    }

    @Override
    public Node getNode(@NonNull DrawingView view) {
        CssColor color = view.getEditor().getHandleColor();
        this.node.setStroke((Paint)color.getColor());
        return this.node;
    }

    protected void initNode(@NonNull Polygon r) {
        r.setFill(null);
    }

    @Override
    public boolean isSelectable() {
        return false;
    }

    @Override
    public void updateNode(@NonNull DrawingView view) {
        Bounds b = this.getBounds(view);
        if (b == null) {
            return;
        }
        this.points[0] = b.getMinX();
        this.points[1] = b.getMinY();
        this.points[2] = b.getMaxX();
        this.points[3] = b.getMinY();
        this.points[4] = b.getMaxX();
        this.points[5] = b.getMaxY();
        this.points[6] = b.getMinX();
        this.points[7] = b.getMaxY();
        ObservableList pp = this.node.getPoints();
        for (int i = 0; i < this.points.length; ++i) {
            pp.set(i, (Object)((double)Math.round(this.points[i] + 0.5) - 0.5));
        }
    }
}

