/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.draw.handle;

import java.awt.geom.PathIterator;
import java.util.ArrayList;
import javafx.scene.Cursor;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Path;
import javafx.scene.transform.Transform;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.draw.DrawingView;
import org.jhotdraw8.draw.css.value.CssColor;
import org.jhotdraw8.draw.css.value.Paintable;
import org.jhotdraw8.draw.figure.PathIterableFigure;
import org.jhotdraw8.draw.handle.AbstractHandle;
import org.jhotdraw8.geom.AwtShapes;
import org.jhotdraw8.geom.FXPathElementsBuilder;
import org.jhotdraw8.geom.FXShapes;
import org.jhotdraw8.geom.FXTransforms;
import org.jhotdraw8.geom.PathBuilder;

public class PathIterableOutlineHandle
extends AbstractHandle {
    private final @NonNull Group node = new Group();
    private final @NonNull Path path2 = new Path();
    private final @NonNull Path path1 = new Path();
    private final boolean selectable;

    public PathIterableOutlineHandle(PathIterableFigure figure, boolean selectable) {
        super(figure);
        this.node.getChildren().addAll((Object[])new Node[]{this.path1, this.path2});
        this.selectable = selectable;
    }

    @Override
    public boolean contains(DrawingView dv, double x, double y, double tolerance) {
        return false;
    }

    @Override
    public @Nullable Cursor getCursor() {
        return null;
    }

    @Override
    public @NonNull Node getNode(@NonNull DrawingView view) {
        CssColor color = view.getEditor().getHandleColor();
        this.path1.setStroke((Paint)Color.WHITE);
        this.path2.setStroke(Paintable.getPaint(color));
        double strokeWidth = view.getEditor().getHandleStrokeWidth();
        this.path1.setStrokeWidth(strokeWidth + 2.0);
        this.path2.setStrokeWidth(strokeWidth);
        return this.node;
    }

    @Override
    public boolean isEditable() {
        return false;
    }

    @Override
    public boolean isSelectable() {
        return this.selectable;
    }

    @Override
    public @NonNull PathIterableFigure getOwner() {
        return (PathIterableFigure)super.getOwner();
    }

    @Override
    public void updateNode(@NonNull DrawingView view) {
        PathIterableFigure f = this.getOwner();
        Transform t = FXTransforms.concat((Transform[])new Transform[]{view.getWorldToView(), f.getLocalToWorld()});
        ArrayList elements = new ArrayList();
        FXPathElementsBuilder builder = new FXPathElementsBuilder(elements);
        AwtShapes.buildPathIterator((PathBuilder)builder, (PathIterator)f.getPathIterator(view, FXShapes.fxTransformToAwtTransform((Transform)t)));
        this.path1.getElements().setAll(elements);
        this.path2.getElements().setAll(elements);
    }
}

