/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.draw.handle;

import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import javafx.collections.ObservableSet;
import javafx.geometry.Bounds;
import javafx.geometry.Point2D;
import javafx.geometry.Point3D;
import javafx.scene.Cursor;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.Border;
import javafx.scene.layout.BorderStroke;
import javafx.scene.layout.BorderStrokeStyle;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;
import javafx.scene.shape.Shape;
import javafx.scene.transform.Transform;
import javafx.scene.transform.Translate;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.draw.DrawingView;
import org.jhotdraw8.draw.css.value.CssColor;
import org.jhotdraw8.draw.css.value.CssPoint2D;
import org.jhotdraw8.draw.figure.Figure;
import org.jhotdraw8.draw.figure.TransformableFigure;
import org.jhotdraw8.draw.handle.AbstractHandle;
import org.jhotdraw8.draw.model.DrawingModel;
import org.jhotdraw8.fxcollection.typesafekey.MapAccessor;
import org.jhotdraw8.geom.FXTransforms;
import org.jhotdraw8.geom.Points;
import org.jhotdraw8.icollection.immutable.ImmutableList;

public class PolyPointMoveHandle
extends AbstractHandle {
    private static final @Nullable Function<Color, Background> REGION_BACKGROUND = color -> new Background(new BackgroundFill[]{new BackgroundFill((Paint)color, null, null)});
    private static final @Nullable Function<Color, Border> REGION_BORDER = color -> new Border(new BorderStroke[]{new BorderStroke((Paint)color, BorderStrokeStyle.SOLID, null, null)});
    private static final Rectangle REGION_SHAPE = new Rectangle(5.0, 5.0);
    private Set<Figure> groupReshapeableFigures;
    private final @NonNull Region node;
    private Point2D oldPoint;
    private Point2D pickLocation;
    private final int pointIndex;
    private final MapAccessor<ImmutableList<Point2D>> pointKey;

    public PolyPointMoveHandle(Figure figure, MapAccessor<ImmutableList<Point2D>> pointKey, int pointIndex) {
        super(figure);
        this.pointKey = pointKey;
        this.pointIndex = pointIndex;
        this.node = new Region();
        this.node.setShape((Shape)REGION_SHAPE);
        this.node.setManaged(false);
        this.node.setScaleShape(true);
        this.node.setCenterShape(true);
        this.node.resize(11.0, 11.0);
    }

    @Override
    public boolean contains(DrawingView dv, double x, double y, double tolerance) {
        Point2D p = this.getLocationInView();
        return Points.squaredDistance((double)x, (double)y, (double)p.getX(), (double)p.getY()) <= tolerance * tolerance;
    }

    @Override
    public Cursor getCursor() {
        return Cursor.OPEN_HAND;
    }

    private Point2D getLocation() {
        ImmutableList list = (ImmutableList)this.owner.get(this.pointKey);
        return (Point2D)list.get(this.pointIndex);
    }

    public Point2D getLocationInView() {
        return this.pickLocation;
    }

    public @NonNull Region getNode(@NonNull DrawingView view) {
        double size = view.getEditor().getHandleSize();
        this.node.resize(size, size);
        CssColor color = view.getEditor().getHandleColor();
        this.node.setBorder(REGION_BORDER.apply(Color.WHITE));
        this.node.setBackground(REGION_BACKGROUND.apply(color.getColor()));
        return this.node;
    }

    @Override
    public void onMouseDragged(@NonNull MouseEvent event, @NonNull DrawingView view) {
        Point2D newPoint = view.viewToWorld(new Point2D(event.getX(), event.getY()));
        if (!event.isAltDown() && !event.isControlDown()) {
            newPoint = view.getConstrainer().constrainPoint(this.owner, new CssPoint2D(newPoint)).getConvertedValue();
        }
        if (event.isMetaDown()) {
            Point2D loc = this.getLocation();
            this.oldPoint = FXTransforms.transform((Transform)this.owner.getLocalToWorld(), (Point2D)loc);
        }
        if (this.oldPoint.equals((Object)newPoint)) {
            return;
        }
        DrawingModel model = view.getModel();
        if (event.isShiftDown()) {
            for (Figure f : this.groupReshapeableFigures) {
                PolyPointMoveHandle.translateFigure(f, this.oldPoint, newPoint, model);
            }
        } else {
            Figure f = this.owner;
            PolyPointMoveHandle.translateFigure(f, this.oldPoint, newPoint, model);
        }
        this.oldPoint = newPoint;
    }

    @Override
    public void onMousePressed(@NonNull MouseEvent event, @NonNull DrawingView view) {
        this.oldPoint = view.getConstrainer().constrainPoint(this.owner, new CssPoint2D(view.viewToWorld(new Point2D(event.getX(), event.getY())))).getConvertedValue();
        ObservableSet<Figure> selectedFigures = view.getSelectedFigures();
        this.groupReshapeableFigures = new HashSet<Figure>();
        for (Figure f : view.getSelectedFigures()) {
            if (!f.isGroupReshapeableWith((Set<Figure>)selectedFigures)) continue;
            this.groupReshapeableFigures.add(f);
        }
        this.groupReshapeableFigures = view.getFiguresWithCompatibleHandle(this.groupReshapeableFigures, this);
    }

    @Override
    public void onMouseReleased(@NonNull MouseEvent event, @NonNull DrawingView dv) {
    }

    @Override
    public boolean isSelectable() {
        return true;
    }

    @Override
    public void updateNode(@NonNull DrawingView view) {
        Figure f = this.owner;
        Transform t = FXTransforms.concat((Transform[])new Transform[]{view.getWorldToView(), f.getLocalToWorld()});
        Bounds b = f.getLayoutBounds();
        Point2D p = this.getLocation();
        this.pickLocation = p = FXTransforms.transform((Transform)t, (Point2D)p);
        double size = this.node.getWidth();
        this.node.relocate(p.getX() - size * 0.5, p.getY() - size * 0.5);
        this.node.setRotate(((Double)f.getStyled((MapAccessor)TransformableFigure.ROTATE)).doubleValue());
        this.node.setRotationAxis((Point3D)f.getStyled((MapAccessor)TransformableFigure.ROTATION_AXIS));
    }

    public static void translateFigure(@NonNull Figure f, @NonNull Point2D oldPoint, @NonNull Point2D newPoint, @Nullable DrawingModel model) {
        Point2D npl = f.worldToParent(newPoint);
        Point2D opl = f.worldToParent(oldPoint);
        Translate tx = Transform.translate((double)(npl.getX() - opl.getX()), (double)(npl.getY() - opl.getY()));
        if (model != null) {
            model.reshapeInParent(f, (Transform)tx);
        } else {
            f.reshapeInParent((Transform)tx);
        }
    }
}

