/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.draw.input;

import java.io.IOException;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import javafx.scene.input.Clipboard;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.draw.figure.Drawing;
import org.jhotdraw8.draw.figure.Figure;
import org.jhotdraw8.draw.input.ClipboardInputFormat;
import org.jhotdraw8.draw.model.DrawingModel;

public class MultiClipboardInputFormat
implements ClipboardInputFormat {
    private @Nullable List<Supplier<ClipboardInputFormat>> formatSuppliers;
    private ClipboardInputFormat[] formats;

    public MultiClipboardInputFormat(@NonNull List<Supplier<ClipboardInputFormat>> formatSuppliers) {
        this.formatSuppliers = formatSuppliers;
    }

    public MultiClipboardInputFormat(ClipboardInputFormat ... formats) {
        this.formats = formats;
    }

    private void createFormats() {
        if (this.formatSuppliers != null) {
            int n = this.formatSuppliers.size();
            this.formats = new ClipboardInputFormat[n];
            for (int i = 0; i < n; ++i) {
                this.formats[i] = this.formatSuppliers.get(i).get();
            }
            this.formatSuppliers = null;
        }
    }

    @Override
    public Set<Figure> read(Clipboard clipboard, DrawingModel model, Drawing drawing, Figure layer) throws IOException {
        this.createFormats();
        IOException firstCause = null;
        for (ClipboardInputFormat f : this.formats) {
            try {
                return f.read(clipboard, model, drawing, layer);
            }
            catch (IOException e) {
                if (firstCause != null) continue;
                firstCause = e;
            }
        }
        if (firstCause != null) {
            throw firstCause;
        }
        throw new IOException("Unsupported clipboard content");
    }
}

