/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.draw.inspector;

import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javax.swing.event.UndoableEditEvent;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.draw.DrawingView;
import org.jhotdraw8.draw.figure.Drawing;
import org.jhotdraw8.draw.inspector.AbstractInspector;
import org.jhotdraw8.draw.model.DrawingModel;
import org.jhotdraw8.fxbase.undo.UndoableEditHelper;

public abstract class AbstractDrawingInspector
extends AbstractInspector<DrawingView> {
    protected @Nullable DrawingModel drawingModel;
    protected @Nullable Drawing drawing;
    private final ChangeListener<Drawing> drawingListener = this::onDrawingChanged;
    private final ChangeListener<DrawingModel> modelListener = this::onDrawingModelChanged;
    protected final @NonNull UndoableEditHelper undoHelper;

    public AbstractDrawingInspector() {
        this.subject.addListener(this::onDrawingViewChanged);
        this.undoHelper = new UndoableEditHelper((Object)this, this::forwardUndoableEditEvent);
    }

    protected void onDrawingViewChanged(ObservableValue<? extends DrawingView> observable, @Nullable DrawingView oldValue, @Nullable DrawingView newValue) {
        Drawing oldDrawing = this.drawing;
        DrawingModel oldModel = this.drawingModel;
        if (oldValue != null) {
            oldValue.modelProperty().removeListener(this.modelListener);
            oldValue.drawingProperty().removeListener(this.drawingListener);
            oldDrawing = oldValue.getDrawing();
        }
        Drawing newDrawing = null;
        if (newValue != null) {
            newValue.drawingProperty().addListener(this.drawingListener);
            newValue.modelProperty().addListener(this.modelListener);
            newDrawing = newValue.getDrawing();
            this.drawingModel = newValue.getModel();
        }
        this.onDrawingModelChanged(null, oldModel, this.drawingModel);
        this.onDrawingChanged(null, oldDrawing, newDrawing);
    }

    protected DrawingModel getDrawingModel() {
        return ((DrawingView)this.getSubject()).getModel();
    }

    protected Drawing getDrawing() {
        return ((DrawingView)this.getSubject()).getDrawing();
    }

    protected DrawingModel getModel() {
        return ((DrawingView)this.getSubject()).getModel();
    }

    protected abstract void onDrawingChanged(@Nullable ObservableValue<? extends Drawing> var1, @Nullable Drawing var2, @Nullable Drawing var3);

    protected void onDrawingModelChanged(@Nullable ObservableValue<? extends DrawingModel> observable, @Nullable DrawingModel oldValue, @Nullable DrawingModel newValue) {
    }

    protected void forwardUndoableEditEvent(@NonNull UndoableEditEvent undoableEditEvent) {
    }

    public @NonNull UndoableEditHelper getUndoHelper() {
        return this.undoHelper;
    }
}

