/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.draw.inspector;

import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javafx.application.Platform;
import javafx.beans.Observable;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.ReadOnlyMapProperty;
import javafx.beans.property.SetProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleMapProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleSetProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableMap;
import javafx.collections.ObservableSet;
import javafx.collections.SetChangeListener;
import javafx.css.StyleOrigin;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.RadioButton;
import javafx.scene.control.TextArea;
import javafx.scene.control.ToggleGroup;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javax.swing.event.UndoableEditEvent;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.base.converter.Converter;
import org.jhotdraw8.css.ast.AndCombinator;
import org.jhotdraw8.css.ast.ClassSelector;
import org.jhotdraw8.css.ast.Declaration;
import org.jhotdraw8.css.ast.IdSelector;
import org.jhotdraw8.css.ast.Selector;
import org.jhotdraw8.css.ast.SelectorGroup;
import org.jhotdraw8.css.ast.SimplePseudoClassSelector;
import org.jhotdraw8.css.ast.SimpleSelector;
import org.jhotdraw8.css.ast.SourceLocator;
import org.jhotdraw8.css.ast.StyleRule;
import org.jhotdraw8.css.ast.Stylesheet;
import org.jhotdraw8.css.ast.TypeSelector;
import org.jhotdraw8.css.converter.CssConverter;
import org.jhotdraw8.css.io.CssPrettyPrinter;
import org.jhotdraw8.css.manager.StylesheetsManager;
import org.jhotdraw8.css.model.SelectorModel;
import org.jhotdraw8.css.parser.CssParser;
import org.jhotdraw8.css.parser.CssToken;
import org.jhotdraw8.css.value.QualifiedName;
import org.jhotdraw8.draw.css.value.CssColor;
import org.jhotdraw8.draw.css.value.CssFont;
import org.jhotdraw8.draw.css.value.Paintable;
import org.jhotdraw8.draw.figure.TextFontableFigure;
import org.jhotdraw8.draw.inspector.InspectorLabels;
import org.jhotdraw8.draw.inspector.StyleAttributesInspector;
import org.jhotdraw8.draw.popup.AbstractPicker;
import org.jhotdraw8.draw.popup.BooleanPicker;
import org.jhotdraw8.draw.popup.CssColorPicker;
import org.jhotdraw8.draw.popup.CssFontPicker;
import org.jhotdraw8.draw.popup.EnumPicker;
import org.jhotdraw8.draw.popup.ExamplesPicker;
import org.jhotdraw8.draw.popup.FontFamilyPicker;
import org.jhotdraw8.draw.popup.PaintablePicker;
import org.jhotdraw8.draw.popup.Picker;
import org.jhotdraw8.fxbase.concurrent.PlatformUtil;
import org.jhotdraw8.fxbase.styleable.WritableStyleableMapAccessor;
import org.jhotdraw8.fxbase.undo.UndoableEditHelper;
import org.jhotdraw8.icollection.immutable.ImmutableList;

public abstract class AbstractStyleAttributesInspector<E> {
    public static final String SHOWING_PROPERTY = "showing";
    public static final @NonNull String UNSPECIFIED_VALUE_PLACEHOLDER = "  ";
    public static final @NonNull String MULTIPLE_VALUES_PLACEHOLDER = "/* multiple values */";
    protected final @NonNull BooleanProperty showing = new SimpleBooleanProperty((Object)this, "showing", true);
    protected final @NonNull UndoableEditHelper undoHelper = new UndoableEditHelper((Object)this, this::forwardUndoableEdit);
    private final @NonNull ObjectProperty<Predicate<QualifiedName>> attributeFilter = new SimpleObjectProperty(k -> true);
    private final @NonNull ObjectProperty<Supplier<CssParser>> cssParserFactory = new SimpleObjectProperty(CssParser::new);
    private final @NonNull ReadOnlyMapProperty<WritableStyleableMapAccessor<?>, Picker<?>> accessorPickerMap = new SimpleMapProperty(FXCollections.observableMap(new LinkedHashMap()));
    private final @NonNull SetProperty<E> selection = new SimpleSetProperty();
    private final @NonNull Map<QualifiedName, String> helpTexts = new HashMap<QualifiedName, String>();
    private final @NonNull List<LookupEntry> lookupTable = new ArrayList<LookupEntry>();
    private Node node;
    @FXML
    private Button applyButton;
    @FXML
    private Button selectButton;
    @FXML
    private CheckBox showUnspecifiedAttributesCheckBox;
    @FXML
    private CheckBox updateContentsCheckBox;
    @FXML
    private CheckBox updateSelectorCheckBox;
    @FXML
    private CheckBox composeAttributesCheckBox;
    @FXML
    private TextArea textArea;
    @FXML
    private RadioButton showAttributeValues;
    @FXML
    private ToggleGroup shownValues;
    @FXML
    private RadioButton showStylesheetValues;
    @FXML
    private RadioButton showUserAgentValues;
    @FXML
    private RadioButton showAppliedValues;
    private boolean textAreaValid = true;
    private boolean isApplying;

    public AbstractStyleAttributesInspector() {
        this(StyleAttributesInspector.class.getResource("StyleAttributesInspector.fxml"));
    }

    public AbstractStyleAttributesInspector(@NonNull URL fxmlUrl) {
        this.showing.addListener((o, oldv, newv) -> {
            if (newv.booleanValue()) {
                Platform.runLater(this::validateTextArea);
            }
        });
        SetChangeListener listener = change -> this.invalidateTextArea((Observable)this.selection);
        this.selection.addListener((o, oldv, newv) -> {
            if (oldv != null) {
                oldv.removeListener(listener);
            }
            if (newv != null) {
                newv.addListener(listener);
                this.invalidateTextArea((Observable)this.selection);
            }
        });
        this.init(fxmlUrl);
    }

    protected abstract void forwardUndoableEdit(@NonNull UndoableEditEvent var1);

    public @NonNull ReadOnlyMapProperty<WritableStyleableMapAccessor<?>, Picker<?>> accessorPickerMapProperty() {
        return this.accessorPickerMap;
    }

    private void apply(ActionEvent event) {
        this.undoHelper.startCompositeEdit(null);
        this.isApplying = true;
        CssParser parser = this.getCssParserFactoryOrDefault().get();
        TextArea textArea = this.getTextArea();
        try {
            Stylesheet stylesheet = parser.parseStylesheet(textArea.getText(), null, null);
            if (!parser.getParseExceptions().isEmpty()) {
                System.out.println("StyleAttributesInspector:\n" + parser.getParseExceptions().toString().replace(',', '\n'));
                ParseException e = (ParseException)parser.getParseExceptions().getFirst();
                new Alert(Alert.AlertType.ERROR, e.getMessage(), new ButtonType[0]).showAndWait();
                textArea.positionCaret(e.getErrorOffset());
                textArea.requestFocus();
                return;
            }
            ObservableMap<String, Set<E>> pseudoStyles = this.createPseudoStyles();
            StylesheetsManager<E> sm = this.getStyleManager();
            if (sm == null) {
                return;
            }
            SelectorModel fsm = sm.getSelectorModel();
            fsm.additionalPseudoClassStatesProperty().setValue(pseudoStyles);
            for (E entity : this.getEntities()) {
                if (!sm.applyStylesheetTo(StyleOrigin.USER, stylesheet, entity, false)) continue;
                this.fireInvalidated(entity);
            }
            this.recreateHandles();
        }
        catch (IOException ex) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, "Unexpected Exception " + ex.getMessage(), ex);
            return;
        }
        catch (ParseException e) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, "Unexpected Exception " + e.getMessage(), e);
            new Alert(Alert.AlertType.ERROR, e.getMessage(), new ButtonType[0]).showAndWait();
            textArea.positionCaret(e.getErrorOffset());
            textArea.requestFocus();
        }
        this.isApplying = false;
        this.undoHelper.stopCompositeEdit();
    }

    public @NonNull Property<Predicate<QualifiedName>> attributeFilter() {
        return this.attributeFilter;
    }

    private @Nullable String buildString(@Nullable List<CssToken> attribute) {
        if (attribute == null) {
            return null;
        }
        StringBuilder buf = new StringBuilder();
        for (CssToken t : attribute) {
            buf.append(t.fromToken());
        }
        return buf.toString();
    }

    private @NonNull Map<QualifiedName, String> collectAttributeValues(boolean decompose, @NonNull List<E> matchedFigures, @NonNull SelectorModel<E> selectorModel) {
        Object origin = this.showAttributeValues.isSelected() ? StyleOrigin.USER : (this.showStylesheetValues.isSelected() ? StyleOrigin.AUTHOR : (this.showUserAgentValues.isSelected() ? StyleOrigin.USER_AGENT : null));
        TreeMap<QualifiedName, String> attr = new TreeMap<QualifiedName, String>();
        Predicate<QualifiedName> filter = this.getAttributeFilter();
        boolean first = true;
        for (E f : matchedFigures) {
            if (first) {
                first = false;
                for (QualifiedName qname : decompose ? selectorModel.getDecomposedAttributeNames(f) : selectorModel.getComposedAttributeNames(f)) {
                    if (!filter.test(qname)) continue;
                    String attribute = this.buildString(selectorModel.getAttribute(f, origin, qname.namespace(), qname.name()));
                    attr.put(qname, attribute == null ? UNSPECIFIED_VALUE_PLACEHOLDER : attribute);
                }
                continue;
            }
            Iterator i = attr.keySet().iterator();
            while (i.hasNext()) {
                QualifiedName qname;
                qname = (QualifiedName)i.next();
                if (!selectorModel.hasAttribute(f, qname.namespace(), qname.name())) {
                    i.remove();
                    continue;
                }
                String oldAttrValue = (String)attr.get(qname);
                String newAttrValue = this.buildString(selectorModel.getAttribute(f, origin, qname.namespace(), qname.name()));
                if (newAttrValue == null) {
                    newAttrValue = UNSPECIFIED_VALUE_PLACEHOLDER;
                }
                if (Objects.equals(oldAttrValue, newAttrValue)) continue;
                attr.put(qname, MULTIPLE_VALUES_PLACEHOLDER);
            }
        }
        if (!this.showUnspecifiedAttributesCheckBox.isSelected()) {
            attr.entrySet().removeIf(entry -> UNSPECIFIED_VALUE_PLACEHOLDER.equals(entry.getValue()));
        }
        return attr;
    }

    protected void collectHelpTexts(@NonNull Collection<E> figures) {
        StylesheetsManager<E> styleManager = this.getStyleManager();
        if (styleManager == null) {
            return;
        }
        SelectorModel selectorModel = styleManager.getSelectorModel();
        for (E f : figures) {
            for (QualifiedName qname : selectorModel.getAttributeNames(f)) {
                Converter<?> c = this.getConverter(selectorModel, f, qname.namespace(), qname.name());
                String helpText = c == null ? null : c.getHelpText();
                if (helpText == null) continue;
                this.helpTexts.put(qname, helpText);
            }
        }
    }

    private <T> @NonNull Picker<T> createAndCachePicker(@NonNull WritableStyleableMapAccessor<T> acc) {
        ObservableMap<WritableStyleableMapAccessor<?>, Picker<?>> amap = this.getAccessorPickerMap();
        Picker<T> picker = (Picker<T>)amap.get(acc);
        if (picker == null) {
            picker = this.createPicker(acc);
            amap.put(acc, picker);
        }
        return picker;
    }

    protected <T> @NonNull Picker<T> createPicker(@NonNull WritableStyleableMapAccessor<T> acc) {
        Class type = acc.getRawValueType();
        boolean nullable = true;
        Converter converter = acc.getCssConverter();
        if (converter instanceof CssConverter) {
            CssConverter converter2 = (CssConverter)converter;
            nullable = converter2.isNullable();
        }
        AbstractPicker p = null;
        if (type == Boolean.class) {
            p = new BooleanPicker(nullable);
        } else if (type == CssColor.class) {
            p = new CssColorPicker();
        } else if (type == Paintable.class) {
            p = new PaintablePicker();
        } else if (type == CssFont.class) {
            p = new CssFontPicker();
        } else if (acc == TextFontableFigure.FONT_FAMILY) {
            p = new FontFamilyPicker();
        } else if (type.isEnum()) {
            Class enumClazz = type;
            EnumPicker suppress = new EnumPicker(enumClazz, acc.getCssConverter());
            p = suppress;
        } else {
            ExamplesPicker suppress = new ExamplesPicker((ImmutableList<String>)acc.getExamples(), acc.getCssConverter());
            p = suppress;
        }
        return p;
    }

    private @NonNull ObservableMap<String, Set<E>> createPseudoStyles() {
        ObservableMap pseudoStyles = FXCollections.observableHashMap();
        LinkedHashSet<E> fs = new LinkedHashSet<E>((Collection)this.selection.get());
        if (fs.isEmpty()) {
            fs.add(this.getRoot());
        }
        pseudoStyles.put((Object)"selected", fs);
        return pseudoStyles;
    }

    private @NonNull SelectorGroup createSelector(@NonNull Set<E> selection, @NonNull SelectorModel<E> selectorModel) {
        String id = null;
        QualifiedName type = null;
        TreeSet styleClasses = new TreeSet();
        boolean first = true;
        for (Object f : selection) {
            if (first) {
                id = selectorModel.getId(f);
                type = selectorModel.getType(f);
                first = false;
                styleClasses.addAll(selectorModel.getStyleClasses(f).asCollection());
                continue;
            }
            id = null;
            type = Objects.equals(selectorModel.getType(f), type) ? type : null;
            styleClasses.retainAll(selectorModel.getStyleClasses(f).asCollection());
        }
        ArrayList<Object> selectors = new ArrayList<Object>();
        if (type != null && !type.name().isEmpty()) {
            selectors.add(new TypeSelector(null, "*", type.name()));
        }
        if (id != null && !id.isEmpty()) {
            selectors.add(new IdSelector(null, id));
        }
        for (String clazz : styleClasses) {
            selectors.add(new ClassSelector(null, clazz));
        }
        selectors.add(new SimplePseudoClassSelector(null, "selected"));
        SimpleSelector prev = null;
        Collections.reverse(selectors);
        for (SimpleSelector simpleSelector : selectors) {
            if (prev != null) {
                prev = new AndCombinator(null, simpleSelector, (Selector)prev);
                continue;
            }
            prev = simpleSelector;
        }
        return new SelectorGroup(null, Collections.singletonList(prev));
    }

    protected abstract void fireInvalidated(E var1);

    protected abstract @Nullable Object get(E var1, WritableStyleableMapAccessor<Object> var2);

    protected abstract @Nullable WritableStyleableMapAccessor<?> getAccessor(SelectorModel<E> var1, E var2, String var3, String var4);

    public ObservableMap<WritableStyleableMapAccessor<?>, Picker<?>> getAccessorPickerMap() {
        return (ObservableMap)this.accessorPickerMap.get();
    }

    public Predicate<QualifiedName> getAttributeFilter() {
        return (Predicate)this.attributeFilter.get();
    }

    public void setAttributeFilter(Predicate<QualifiedName> attributeFilter) {
        this.attributeFilter.set(attributeFilter);
    }

    protected abstract @Nullable Converter<?> getConverter(SelectorModel<E> var1, E var2, String var3, String var4);

    protected abstract @NonNull Iterable<E> getEntities();

    private @Nullable LookupEntry getLookupEntryAt(int caretPosition) {
        int insertionPoint = Collections.binarySearch(this.lookupTable, new LookupEntry(caretPosition, null, null));
        if (insertionPoint < 0) {
            insertionPoint = ~insertionPoint - 1;
        }
        LookupEntry d = null;
        if (0 <= insertionPoint && insertionPoint < this.lookupTable.size()) {
            LookupEntry entry = this.lookupTable.get(insertionPoint);
            if (caretPosition <= entry.declaration.getEndPos()) {
                d = entry;
            }
        }
        return d;
    }

    public Node getNode() {
        return this.node;
    }

    protected abstract @Nullable E getRoot();

    public ObservableSet<E> getSelection() {
        ObservableSet es = (ObservableSet)this.selection.get();
        return es == null ? FXCollections.emptyObservableSet() : es;
    }

    protected abstract @Nullable StylesheetsManager<E> getStyleManager();

    protected TextArea getTextArea() {
        return this.textArea;
    }

    protected void init(@NonNull URL fxmlUrl) {
        PlatformUtil.invokeAndWait(() -> {
            FXMLLoader loader = new FXMLLoader();
            loader.setResources(InspectorLabels.getResources().asResourceBundle());
            loader.setController((Object)this);
            try (InputStream in = fxmlUrl.openStream();){
                this.node = (Node)loader.load(in);
            }
            catch (IOException ex) {
                throw new InternalError(ex);
            }
        });
        Preferences prefs = Preferences.userNodeForPackage(StyleAttributesInspector.class);
        this.updateContentsCheckBox.setSelected(prefs.getBoolean("updateContents", true));
        this.updateContentsCheckBox.selectedProperty().addListener((o, oldValue, newValue) -> prefs.putBoolean("updateContents", (boolean)newValue));
        this.updateSelectorCheckBox.setSelected(prefs.getBoolean("updateSelector", true));
        this.updateSelectorCheckBox.selectedProperty().addListener((o, oldValue, newValue) -> prefs.putBoolean("updateSelector", (boolean)newValue));
        this.composeAttributesCheckBox.setSelected(prefs.getBoolean("composeAttributes", true));
        this.composeAttributesCheckBox.selectedProperty().addListener((o, oldValue, newValue) -> prefs.putBoolean("composeAttributes", (boolean)newValue));
        this.showUnspecifiedAttributesCheckBox.selectedProperty().addListener((o, oldValue, newValue) -> prefs.putBoolean("showUnspecifiedAttributes", (boolean)newValue));
        this.showUnspecifiedAttributesCheckBox.setSelected(prefs.getBoolean("showUnspecifiedAttributes", true));
        WeakReference<AbstractStyleAttributesInspector> r = new WeakReference<AbstractStyleAttributesInspector>(this);
        this.applyButton.setOnAction(event1 -> {
            AbstractStyleAttributesInspector inspector = (AbstractStyleAttributesInspector)r.get();
            if (inspector != null) {
                inspector.apply((ActionEvent)event1);
            }
        });
        this.selectButton.setOnAction(event1 -> {
            AbstractStyleAttributesInspector inspector = (AbstractStyleAttributesInspector)r.get();
            if (inspector != null) {
                inspector.select((ActionEvent)event1);
            }
        });
        EventHandler invalidateTextAreaAction = event -> {
            AbstractStyleAttributesInspector inspector = (AbstractStyleAttributesInspector)r.get();
            if (inspector != null) {
                inspector.invalidateTextArea(null);
            }
        };
        this.showUnspecifiedAttributesCheckBox.setOnAction(invalidateTextAreaAction);
        this.composeAttributesCheckBox.setOnAction(invalidateTextAreaAction);
        this.textArea.textProperty().addListener(this::updateLookupTable);
        this.textArea.caretPositionProperty().addListener(this::onCaretPositionChanged);
        EventHandler eventHandler = event -> {
            if (event.getCode() == KeyCode.ENTER && (event.isAltDown() || event.isControlDown())) {
                event.consume();
                this.apply(null);
            }
        };
        this.textArea.addEventHandler(KeyEvent.KEY_PRESSED, eventHandler);
        switch (prefs.get("shownValues", "user")) {
            case "author": {
                this.showStylesheetValues.setSelected(true);
                break;
            }
            case "user": {
                this.showAttributeValues.setSelected(true);
                break;
            }
            case "userAgent": {
                this.showUserAgentValues.setSelected(true);
                break;
            }
            default: {
                this.showAppliedValues.setSelected(true);
            }
        }
        this.shownValues.selectedToggleProperty().addListener(o -> {
            AbstractStyleAttributesInspector inspector = (AbstractStyleAttributesInspector)r.get();
            if (inspector != null) {
                inspector.updateShownValues(o);
            }
        });
        TextArea textArea = this.getTextArea();
        textArea.textProperty().addListener(this::updateLookupTable);
        textArea.caretPositionProperty().addListener(this::onCaretPositionChanged);
        textArea.addEventHandler(MouseEvent.MOUSE_CLICKED, this::onTextAreaClicked);
    }

    protected void invalidateTextArea(Observable observable) {
        if (!this.isApplying && this.textAreaValid && this.updateContentsCheckBox.isSelected()) {
            this.textAreaValid = false;
            if (this.isShowing()) {
                Platform.runLater(this::validateTextArea);
            }
        }
    }

    public boolean isShowing() {
        return this.showingProperty().get();
    }

    public void setShowing(boolean newValue) {
        this.showingProperty().set(newValue);
    }

    protected void onCaretPositionChanged(Observable o, Number oldv, @NonNull Number newv) {
        LookupEntry entry = this.getLookupEntryAt(newv.intValue());
        Declaration d = entry == null ? null : entry.declaration;
        Object helpText = null;
        if (d != null) {
            helpText = this.helpTexts.get(new QualifiedName(d.getNamespace(), d.getPropertyName()));
        }
        StylesheetsManager<E> sm = this.getStyleManager();
        String smHelpText = sm.getHelpText();
        if (helpText == null) {
            helpText = smHelpText;
        } else if (smHelpText == null || !smHelpText.isEmpty()) {
            helpText = (String)helpText + "\n\n" + smHelpText;
        }
        this.setHelpText((String)helpText);
    }

    private void onTextAreaClicked(@NonNull MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() == 2 && mouseEvent.getEventType() == MouseEvent.MOUSE_CLICKED) {
            mouseEvent.consume();
            int caretPosition = this.getTextArea().getCaretPosition();
            this.showPicker(caretPosition, mouseEvent.getScreenX(), mouseEvent.getScreenY());
        }
    }

    private SelectorGroup parseSelector() {
        CssParser parser = this.getCssParserFactoryOrDefault().get();
        try {
            Stylesheet s = parser.parseStylesheet(this.textArea.getText(), null, null);
            if (!parser.getParseExceptions().isEmpty()) {
                System.err.println("StyleAttributesInspector:\n" + parser.getParseExceptions().toString().replace(',', '\n'));
                return new SelectorGroup(null, Collections.emptyList());
            }
            Iterator iterator = s.getStyleRules().iterator();
            if (iterator.hasNext()) {
                StyleRule styleRule = (StyleRule)iterator.next();
                return styleRule.getSelectorGroup();
            }
            return new SelectorGroup(null, Collections.emptyList());
        }
        catch (IOException e) {
            return new SelectorGroup(null, Collections.emptyList());
        }
    }

    protected abstract void recreateHandles();

    protected abstract void remove(E var1, WritableStyleableMapAccessor<Object> var2);

    private void select(ActionEvent event) {
        CssParser parser = this.getCssParserFactory().get();
        try {
            Stylesheet s = parser.parseStylesheet(this.textArea.getText(), null, null);
            if (!parser.getParseExceptions().isEmpty()) {
                System.err.println("StyleAttributesInspector:\n" + parser.getParseExceptions().toString().replace(',', '\n'));
            }
            ObservableMap pseudoStyles = FXCollections.observableHashMap();
            LinkedHashSet<E> fs = new LinkedHashSet<E>(this.getSelection());
            pseudoStyles.put((Object)"selected", fs);
            ArrayList<E> matchedFigures = new ArrayList<E>();
            StylesheetsManager<E> sm = this.getStyleManager();
            SelectorModel fsm = sm.getSelectorModel();
            fsm.additionalPseudoClassStatesProperty().setValue(pseudoStyles);
            for (E f : this.getEntities()) {
                if (!sm.matchesElement(s, f)) continue;
                matchedFigures.add(f);
            }
            this.getSelection().clear();
            this.getSelection().addAll(matchedFigures);
            this.showSelection();
        }
        catch (IOException ex) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, "Unexpected Exception " + ex.getMessage(), ex);
        }
    }

    @NonNull SetProperty<E> selectionProperty() {
        return this.selection;
    }

    protected abstract void set(E var1, WritableStyleableMapAccessor<Object> var2, Object var3);

    protected abstract void setHelpText(String var1);

    private void showPicker(int caretPosition, double screenX, double screenY) {
        StyleRule styleRule;
        LookupEntry entry = this.getLookupEntryAt(caretPosition);
        Declaration declaration = entry == null ? null : entry.declaration;
        StyleRule styleRule2 = styleRule = entry == null ? null : entry.styleRule;
        if (styleRule != null && declaration != null) {
            ObservableMap<String, Set<E>> pseudoStyles = this.createPseudoStyles();
            StylesheetsManager<E> sm = this.getStyleManager();
            if (sm == null) {
                return;
            }
            SelectorModel fsm = sm.getSelectorModel();
            fsm.additionalPseudoClassStatesProperty().setValue(pseudoStyles);
            LinkedHashSet<E> selectedF = new LinkedHashSet<E>();
            WritableStyleableMapAccessor<?> selectedAccessor = null;
            boolean multipleAccessorTypes = false;
            for (E f : this.getEntities()) {
                if (null == styleRule.getSelectorGroup().matchSelector(fsm, f)) continue;
                WritableStyleableMapAccessor<?> accessor = this.getAccessor(fsm, f, declaration.getNamespace(), declaration.getPropertyName());
                if (selectedAccessor == null || selectedAccessor == accessor) {
                    selectedAccessor = accessor;
                    selectedF.add(f);
                    continue;
                }
                multipleAccessorTypes = true;
            }
            if (!multipleAccessorTypes && selectedAccessor != null && !selectedF.isEmpty()) {
                Picker<Object> picker = this.createAndCachePicker(selectedAccessor);
                Object initialValue = null;
                WritableStyleableMapAccessor<?> finalSelectedAccessor = selectedAccessor;
                Iterator iterator = selectedF.iterator();
                if (iterator.hasNext()) {
                    Object f = iterator.next();
                    initialValue = this.get(f, finalSelectedAccessor);
                }
                BiConsumer<Boolean, Object> lambda = (b, o) -> {
                    this.undoHelper.startCompositeEdit(null);
                    if (b.booleanValue()) {
                        for (Object f : selectedF) {
                            this.set(f, (WritableStyleableMapAccessor<Object>)finalSelectedAccessor, o);
                        }
                    } else {
                        for (Object f : selectedF) {
                            this.remove(f, (WritableStyleableMapAccessor<Object>)finalSelectedAccessor);
                        }
                    }
                    this.invalidateTextArea(null);
                    this.undoHelper.stopCompositeEdit();
                };
                picker.show((Node)this.getTextArea(), screenX, screenY, initialValue, lambda);
            }
        }
    }

    protected abstract void showSelection();

    public @NonNull BooleanProperty showingProperty() {
        return this.showing;
    }

    protected void updateLookupTable(Observable o) {
        this.lookupTable.clear();
        CssParser parser = this.getCssParserFactory().get();
        try {
            Stylesheet s = parser.parseStylesheet(this.getTextArea().getText(), null, null);
            for (StyleRule r : s.getStyleRules()) {
                for (Declaration d : r.getDeclarations()) {
                    this.lookupTable.add(new LookupEntry(d.getStartPos(), r, d));
                }
            }
        }
        catch (IOException ex) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, "Unexpected Exception " + ex.getMessage(), ex);
        }
    }

    private SelectorGroup updateSelector(@NonNull Set<E> selection, @NonNull SelectorModel<E> selectorModel) {
        if (this.updateSelectorCheckBox.isSelected()) {
            return this.createSelector(selection, selectorModel);
        }
        return this.parseSelector();
    }

    protected void updateShownValues(Observable o) {
        Preferences prefs = Preferences.userNodeForPackage(StyleAttributesInspector.class);
        String origin = this.showAttributeValues.isSelected() ? "user" : (this.showStylesheetValues.isSelected() ? "author" : (this.showUserAgentValues.isSelected() ? "userAgent" : "styled"));
        prefs.put("shownValues", origin);
        this.invalidateTextArea(null);
    }

    private void updateStylesheetInfo(CssPrettyPrinter pp, List<E> matchedFigures, StylesheetsManager<E> styleManager) {
        List stylesheets = styleManager.getStylesheets();
        LinkedHashMap<StylesheetsManager.StylesheetInfo, Set> matchedInfos = new LinkedHashMap<StylesheetsManager.StylesheetInfo, Set>();
        ArrayList<StylesheetsManager.StylesheetInfo> stylesheetInfos = new ArrayList<StylesheetsManager.StylesheetInfo>();
        for (StylesheetsManager.StylesheetInfo stylesheet : stylesheets) {
            StyleOrigin origin = stylesheet.getOrigin();
            switch (origin) {
                case USER_AGENT: {
                    if (!this.showUserAgentValues.isSelected()) break;
                    stylesheetInfos.add(stylesheet);
                    break;
                }
                case USER: 
                case INLINE: {
                    break;
                }
                case AUTHOR: {
                    if (!this.showStylesheetValues.isSelected()) break;
                    stylesheetInfos.add(stylesheet);
                }
            }
        }
        if (!stylesheetInfos.isEmpty()) {
            for (Object f : matchedFigures) {
                for (StylesheetsManager.StylesheetInfo info : stylesheetInfos) {
                    List matchingRules = styleManager.getMatchingRulesForElement(info.getStylesheet(), f);
                    if (matchingRules.isEmpty()) continue;
                    matchedInfos.computeIfAbsent(info, k -> new LinkedHashSet()).addAll(matchingRules);
                }
            }
        }
        if (!matchedInfos.isEmpty()) {
            StringBuilder buf = new StringBuilder();
            buf.append("\n/*");
            buf.append("\nThe following stylesheets match:");
            for (Map.Entry matchedInfo : matchedInfos.entrySet()) {
                buf.append("\n  ");
                buf.append(((StylesheetsManager.StylesheetInfo)matchedInfo.getKey()).getOrigin());
                buf.append(": ");
                buf.append(((StylesheetsManager.StylesheetInfo)matchedInfo.getKey()).getUri().toString());
                buf.append("\n  Rules:");
                for (StyleRule rule : (Set)matchedInfo.getValue()) {
                    buf.append("\n    ");
                    rule.getSelectorGroup().produceTokens(token -> buf.append(token.fromToken()));
                    SourceLocator sourceLocator = rule.getSourceLocator();
                    if (sourceLocator == null || sourceLocator.lineNumber() < 0) continue;
                    buf.append(" line: ").append(sourceLocator.lineNumber());
                }
            }
            buf.append("\n*/");
            pp.append((CharSequence)buf.toString());
        }
    }

    protected void updateTextArea() {
        boolean decompose = !this.composeAttributesCheckBox.isSelected();
        LinkedHashSet<E> selectedOrRoot = new LinkedHashSet<E>(this.getSelection());
        if (selectedOrRoot.isEmpty()) {
            selectedOrRoot.add(this.getRoot());
        }
        StylesheetsManager<E> styleManager = this.getStyleManager();
        ObservableMap pseudoStyles = FXCollections.observableHashMap();
        LinkedHashSet<E> fs = new LinkedHashSet<E>(selectedOrRoot);
        pseudoStyles.put((Object)"selected", fs);
        StylesheetsManager<E> sm = this.getStyleManager();
        if (sm == null) {
            return;
        }
        SelectorModel selectorModel = sm.getSelectorModel();
        selectorModel.additionalPseudoClassStatesProperty().setValue(pseudoStyles);
        SelectorGroup selector = this.updateSelector(selectedOrRoot, selectorModel);
        List<Object> matchedFigures = this.updateSelectorCheckBox.isSelected() ? new ArrayList<E>(this.getSelection()) : StreamSupport.stream(this.getEntities().spliterator(), true).filter(entity -> selector.matches(selectorModel, entity)).collect(Collectors.toList());
        this.collectHelpTexts(selectedOrRoot);
        Map<QualifiedName, String> attr = this.collectAttributeValues(decompose, matchedFigures, selectorModel);
        StringBuilder buf = new StringBuilder();
        CssPrettyPrinter pp = new CssPrettyPrinter((Appendable)buf);
        selector.produceTokens(t -> pp.append((CharSequence)t.fromToken()));
        pp.append((CharSequence)" {");
        for (Map.Entry<QualifiedName, String> a : attr.entrySet()) {
            pp.append((CharSequence)"\n  ").append((CharSequence)a.getKey().name()).append((CharSequence)": ");
            pp.append((CharSequence)a.getValue());
            pp.append((CharSequence)";");
        }
        pp.append((CharSequence)"\n}");
        this.updateStylesheetInfo(pp, matchedFigures, styleManager);
        this.textArea.setText(buf.toString());
        int rows = 1;
        for (int i = 0; i < buf.length(); ++i) {
            if (buf.charAt(i) != '\n') continue;
            ++rows;
        }
        this.textArea.setPrefRowCount(Math.min(Math.max(5, rows), 25));
    }

    private void validateTextArea() {
        if (!this.textAreaValid) {
            if (this.updateContentsCheckBox.isSelected()) {
                this.updateTextArea();
            }
            this.textAreaValid = true;
        }
    }

    public @Nullable Supplier<CssParser> getCssParserFactory() {
        return (Supplier)this.cssParserFactory.get();
    }

    public @NonNull Supplier<CssParser> getCssParserFactoryOrDefault() {
        Supplier s = (Supplier)this.cssParserFactory.get();
        return s == null ? CssParser::new : s;
    }

    public void setCssParserFactory(@Nullable Supplier<CssParser> cssParserFactory) {
        this.cssParserFactory.set(cssParserFactory);
    }

    public @NonNull ObjectProperty<Supplier<CssParser>> cssParserFactoryProperty() {
        return this.cssParserFactory;
    }

    private record LookupEntry(int position, @NonNull StyleRule styleRule, @NonNull Declaration declaration) implements Comparable<LookupEntry>
    {
        @Override
        public int compareTo(@NonNull LookupEntry o) {
            return this.position - o.position;
        }
    }
}

