/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.draw.inspector;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.beans.binding.Bindings;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WritableValue;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.Node;
import javafx.scene.control.ColorPicker;
import javafx.scene.control.Slider;
import javafx.scene.control.TextField;
import javafx.util.StringConverter;
import javafx.util.converter.NumberStringConverter;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.base.converter.Converter;
import org.jhotdraw8.draw.DrawingView;
import org.jhotdraw8.draw.css.converter.ColorCssConverter;
import org.jhotdraw8.draw.css.value.CssColor;
import org.jhotdraw8.draw.css.value.NamedCssColor;
import org.jhotdraw8.draw.inspector.AbstractDrawingViewInspector;
import org.jhotdraw8.draw.inspector.GridInspector;
import org.jhotdraw8.draw.inspector.InspectorLabels;
import org.jhotdraw8.fxbase.beans.NonNullObjectProperty;
import org.jhotdraw8.fxbase.binding.CustomBinding;
import org.jhotdraw8.fxbase.concurrent.PlatformUtil;
import org.jhotdraw8.fxbase.converter.StringConverterAdapter;

public class HandlesInspector
extends AbstractDrawingViewInspector {
    private final @NonNull NonNullObjectProperty<CssColor> handleColorProperty = new NonNullObjectProperty((Object)this, "handleColor", (Object)NamedCssColor.BLUE);
    private final @NonNull IntegerProperty handleSizeProperty = new SimpleIntegerProperty((Object)this, "handleSize", 11);
    private final @NonNull IntegerProperty handleStrokeWidthProperty = new SimpleIntegerProperty((Object)this, "handleStrokeWidth", 1);
    @FXML
    private ResourceBundle resources;
    @FXML
    private URL location;
    @FXML
    private TextField handleColorField;
    @FXML
    private ColorPicker handleColorPicker;
    @FXML
    private TextField handleSizeField;
    @FXML
    private Slider handleSizeSlider;
    @FXML
    private TextField handleStrokeWidthField;
    @FXML
    private Slider handleStrokeWidthSlider;
    private Node node;

    public HandlesInspector() {
        this(GridInspector.class.getResource("HandlesInspector.fxml"));
    }

    public HandlesInspector(@NonNull URL fxmlUrl) {
        this.init(fxmlUrl);
    }

    @Override
    public Node getNode() {
        return this.node;
    }

    private void init(@NonNull URL fxmlUrl) {
        PlatformUtil.invokeAndWait(() -> {
            FXMLLoader loader = new FXMLLoader();
            loader.setResources(InspectorLabels.getResources().asResourceBundle());
            loader.setController((Object)this);
            try (InputStream in = fxmlUrl.openStream();){
                this.node = (Node)loader.load(in);
            }
            catch (IOException ex) {
                throw new InternalError(ex);
            }
        });
    }

    @FXML
    void initialize() {
        assert (this.handleColorField != null) : "fx:id=\"handleColorField\" was not injected.";
        assert (this.handleColorPicker != null) : "fx:id=\"handleColorPicker\" was not injected.";
        assert (this.handleSizeField != null) : "fx:id=\"handleSizeField\" was not injected.";
        assert (this.handleSizeSlider != null) : "fx:id=\"handleSizeSlider\" was not injected.";
        assert (this.handleStrokeWidthField != null) : "fx:id=\"handleStrokeWidthField\" was not injected: check your FXML file 'HandlesInspector.fxml'.";
        assert (this.handleStrokeWidthSlider != null) : "fx:id=\"handleStrokeWidthSlider\" was not injected: check your FXML file 'HandlesInspector.fxml'.";
        this.handleColorPicker.setValue((Object)((CssColor)this.handleColorProperty.getValue()).getColor());
        CustomBinding.bindBidirectionalAndConvert((WritableValue)this.handleColorPicker.valueProperty(), this.handleColorProperty, CssColor::new, c -> c == null ? null : c.getColor());
        this.handleColorField.textProperty().bindBidirectional(this.handleColorProperty, (StringConverter)new StringConverterAdapter((Converter)new ColorCssConverter(false)));
        this.handleSizeSlider.valueProperty().bindBidirectional((Property)this.handleSizeProperty);
        Bindings.bindBidirectional((Property)this.handleSizeField.textProperty(), (Property)this.handleSizeProperty, (StringConverter)new NumberStringConverter());
        this.handleStrokeWidthSlider.valueProperty().bindBidirectional((Property)this.handleStrokeWidthProperty);
        Bindings.bindBidirectional((Property)this.handleStrokeWidthField.textProperty(), (Property)this.handleStrokeWidthProperty, (StringConverter)new NumberStringConverter());
    }

    @Override
    protected void onDrawingViewChanged(ObservableValue<? extends DrawingView> observable, @Nullable DrawingView oldValue, @Nullable DrawingView newValue) {
        if (oldValue != null) {
            this.handleColorProperty.unbindBidirectional(oldValue.getEditor().handleColorProperty());
            this.handleSizeProperty.unbindBidirectional((Property)oldValue.getEditor().handleSizeProperty());
            oldValue.getEditor().toleranceProperty().unbind();
            this.handleStrokeWidthProperty.unbindBidirectional((Property)oldValue.getEditor().handleStrokeWidthProperty());
        }
        try {
            if (newValue != null) {
                this.handleColorProperty.bindBidirectional(newValue.getEditor().handleColorProperty());
                this.handleSizeProperty.bindBidirectional((Property)newValue.getEditor().handleSizeProperty());
                newValue.getEditor().toleranceProperty().bind((ObservableValue)this.handleSizeProperty.divide(2));
                this.handleStrokeWidthProperty.bindBidirectional((Property)newValue.getEditor().handleStrokeWidthProperty());
            }
        }
        catch (Throwable t) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, "Unexpected Exception " + t.getMessage(), t);
        }
    }
}

