/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.draw.io;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javafx.css.StyleOrigin;
import javafx.scene.input.DataFormat;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.dom.DOMResult;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.base.converter.IdFactory;
import org.jhotdraw8.draw.figure.ClippingFigure;
import org.jhotdraw8.draw.figure.Drawing;
import org.jhotdraw8.draw.figure.Figure;
import org.jhotdraw8.draw.input.ClipboardOutputFormat;
import org.jhotdraw8.draw.io.FigureFactory;
import org.jhotdraw8.draw.io.OutputFormat;
import org.jhotdraw8.fxbase.concurrent.WorkState;
import org.jhotdraw8.fxcollection.typesafekey.CompositeMapAccessor;
import org.jhotdraw8.fxcollection.typesafekey.Key;
import org.jhotdraw8.fxcollection.typesafekey.MapAccessor;
import org.jhotdraw8.fxcollection.typesafekey.NonNullObjectKey;
import org.jhotdraw8.icollection.ChampMap;
import org.jhotdraw8.icollection.immutable.ImmutableList;
import org.jhotdraw8.icollection.immutable.ImmutableMap;
import org.jhotdraw8.xml.IndentingXMLStreamWriter;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class SimpleXmlWriter
implements OutputFormat,
ClipboardOutputFormat {
    protected FigureFactory figureFactory;
    protected final IdFactory idFactory;
    protected final String namespaceQualifier;
    protected String namespaceURI;
    private @NonNull ImmutableMap<Key<?>, Object> options = ChampMap.of();
    public static final NonNullObjectKey<Integer> INDENT_AMOUNT = new NonNullObjectKey("indent-amount", Integer.class, (Object)2);

    public SimpleXmlWriter(FigureFactory factory, IdFactory idFactory) {
        this(factory, idFactory, null, null);
    }

    public SimpleXmlWriter(FigureFactory factory, IdFactory idFactory, String namespaceURI, String namespaceQualifier) {
        this.figureFactory = factory;
        this.idFactory = idFactory;
        this.namespaceURI = namespaceURI;
        this.namespaceQualifier = namespaceQualifier;
    }

    private @NonNull DataFormat getDataFormat() {
        String mimeType = "application/xml";
        DataFormat df = DataFormat.lookupMimeType((String)mimeType);
        if (df == null) {
            df = new DataFormat(new String[]{mimeType});
        }
        return df;
    }

    public boolean isNamespaceAware() {
        return this.namespaceURI != null;
    }

    public void setFigureFactory(FigureFactory figureFactory) {
        this.figureFactory = figureFactory;
    }

    public void setNamespaceURI(String namespaceURI) {
        this.namespaceURI = namespaceURI;
    }

    public Document toDocument(@Nullable URI documentHome, @NonNull Drawing internal, @NonNull Collection<Figure> selection) throws IOException {
        if (selection.isEmpty() || selection.contains(internal)) {
            return this.toDocument(documentHome, internal);
        }
        try {
            DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
            builderFactory.setNamespaceAware(true);
            DocumentBuilder builder = null;
            builder = builderFactory.newDocumentBuilder();
            builder.setEntityResolver((publicId, systemId) -> new InputSource(new StringReader("")));
            Document doc = builder.newDocument();
            DOMResult result = new DOMResult(doc);
            XMLOutputFactory xmlOutputFactory = XMLOutputFactory.newInstance();
            XMLStreamWriter w = xmlOutputFactory.createXMLStreamWriter(result);
            this.writeClipping(w, internal, selection, documentHome);
            w.close();
            return doc;
        }
        catch (ParserConfigurationException | XMLStreamException e) {
            throw new IOException("Could not create document builder.", e);
        }
    }

    public Document toDocument(@Nullable URI documentHome, @NonNull Drawing internal) throws IOException {
        try {
            DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
            builderFactory.setNamespaceAware(true);
            DocumentBuilder builder = builderFactory.newDocumentBuilder();
            builder.setEntityResolver((publicId, systemId) -> new InputSource(new StringReader("")));
            Document doc = builder.newDocument();
            DOMResult result = new DOMResult(doc);
            XMLStreamWriter w = XMLOutputFactory.newInstance().createXMLStreamWriter(result);
            this.writeDocument(w, documentHome, internal);
            w.close();
            return doc;
        }
        catch (ParserConfigurationException | XMLStreamException e) {
            throw new IOException("Error writing to DOM.", e);
        }
    }

    @Override
    public void setOptions(@NonNull ImmutableMap<Key<?>, Object> newValue) {
        this.options = newValue;
    }

    @Override
    public @NonNull ImmutableMap<Key<?>, Object> getOptions() {
        return this.options;
    }

    @Override
    public void write(@NonNull OutputStream out, @Nullable URI documentHome, @NonNull Drawing drawing, @NonNull WorkState<Void> workState) throws IOException {
        this.write(documentHome, new BufferedWriter(new OutputStreamWriter(out, StandardCharsets.UTF_8)), drawing, workState);
    }

    protected void write(@Nullable URI documentHome, @NonNull Writer out, @NonNull Drawing drawing, @NonNull WorkState<Void> workState) throws IOException {
        XMLStreamWriter w = this.createXmlStreamWriter(out);
        workState.updateProgress(0.0);
        try {
            this.writeDocument(w, documentHome, drawing);
            w.flush();
        }
        catch (XMLStreamException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void write(@NonNull Map<DataFormat, Object> out, Drawing drawing, Collection<Figure> selection) throws IOException {
        StringWriter sw = new StringWriter();
        XMLStreamWriter w = this.createXmlStreamWriter(sw);
        Object documentHome = null;
        try {
            if (selection == null || selection.isEmpty()) {
                this.writeDocument(w, null, drawing);
            } else {
                this.writeClipping(w, drawing, selection, null);
            }
        }
        catch (XMLStreamException e) {
            throw new IOException(e);
        }
        out.put(this.getDataFormat(), sw.toString());
    }

    private @NonNull XMLStreamWriter createXmlStreamWriter(@NonNull Writer sw) {
        IndentingXMLStreamWriter w = new IndentingXMLStreamWriter(sw);
        w.setIndentation(" ".repeat((Integer)INDENT_AMOUNT.get(this.options)));
        return w;
    }

    protected void writeClipping(@NonNull XMLStreamWriter w, @NonNull Drawing internal, @NonNull Collection<Figure> selection, @Nullable URI documentHome) throws IOException, XMLStreamException {
        HashSet<Figure> s = new HashSet<Figure>(selection);
        ArrayList<Figure> ordered = new ArrayList<Figure>(selection.size());
        for (Figure f : internal.preorderIterable()) {
            if (!s.contains(f)) continue;
            ordered.add(f);
        }
        ClippingFigure external = new ClippingFigure();
        this.idFactory.reset();
        this.idFactory.setDocumentHome(documentHome);
        String docElemName = this.figureFactory.getElementNameByFigure(external);
        w.writeStartDocument();
        w.setDefaultNamespace(this.namespaceURI);
        w.writeStartElement(docElemName);
        w.writeDefaultNamespace(this.namespaceURI);
        for (Figure child : ordered) {
            this.writeNodeRecursively(w, child, 1);
        }
        w.writeEndElement();
        w.writeEndDocument();
    }

    protected void writeDocument(@NonNull XMLStreamWriter w, @Nullable URI documentHome, @NonNull Drawing internal) throws XMLStreamException {
        try {
            Drawing external = this.figureFactory.toExternalDrawing(internal);
            this.idFactory.reset();
            this.idFactory.setDocumentHome(documentHome);
            String docElemName = this.figureFactory.getElementNameByFigure(external);
            w.writeStartDocument();
            w.setDefaultNamespace(this.namespaceURI);
            this.writeProcessingInstructions(w, external);
            w.writeStartElement(docElemName);
            w.writeDefaultNamespace(this.namespaceURI);
            this.writeElementAttributes(w, external);
            for (Figure child : external.getChildren()) {
                this.writeNodeRecursively(w, child, 1);
            }
            w.writeEndElement();
            w.writeEndDocument();
        }
        catch (IOException e) {
            throw new XMLStreamException(e);
        }
    }

    private void writeElementAttribute(@NonNull XMLStreamWriter w, @NonNull Figure figure, MapAccessor<Object> k) throws IOException, XMLStreamException {
        Object value = figure.get(k);
        if (!k.isTransient() && !this.figureFactory.isDefaultValue(figure, k, value)) {
            String name = this.figureFactory.getAttributeNameByKey(figure, k);
            if (this.figureFactory.getObjectIdAttribute().equals(name)) {
                return;
            }
            if (Figure.class.isAssignableFrom(k.getRawValueType())) {
                w.writeAttribute(name, this.idFactory.createId(value));
            } else {
                String stringValue = this.figureFactory.valueToString(k, value);
                if (stringValue != null && !stringValue.isEmpty()) {
                    w.writeAttribute(name, stringValue);
                }
            }
        }
    }

    protected void writeElementAttributes(@NonNull XMLStreamWriter w, @NonNull Figure figure) throws IOException, XMLStreamException {
        MapAccessor<?> cmap;
        String id = this.idFactory.createId((Object)figure);
        String objectIdAttribute = this.figureFactory.getObjectIdAttribute();
        w.writeAttribute(objectIdAttribute, id);
        Set<MapAccessor<?>> keys = this.figureFactory.figureAttributeKeys(figure);
        HashSet done = new HashSet(keys.size());
        for (MapAccessor<?> k : keys) {
            if (!(k instanceof CompositeMapAccessor)) continue;
            done.add(k);
            if (k.isTransient()) continue;
            cmap = k;
            done.addAll(cmap.getSubAccessors().asSet());
            this.writeElementAttribute(w, figure, cmap);
        }
        for (MapAccessor<?> k : keys) {
            if (k.isTransient() || done.contains(k)) continue;
            cmap = k;
            this.writeElementAttribute(w, figure, cmap);
        }
    }

    private void writeElementNodeList(@NonNull XMLStreamWriter w, @NonNull Figure figure) throws IOException, XMLStreamException {
        Iterator<MapAccessor<?>> iterator = this.figureFactory.figureNodeListKeys(figure).iterator();
        while (iterator.hasNext()) {
            MapAccessor<?> k;
            MapAccessor<?> key = k = iterator.next();
            Object value = figure.get(key);
            if (key.isTransient() || !figure.containsMapAccessor(StyleOrigin.USER, key) || this.figureFactory.isDefaultValue(figure, key, value)) continue;
            this.figureFactory.valueToNodeList(key, value, w);
        }
    }

    protected void writeNodeRecursively(@NonNull XMLStreamWriter w, @NonNull Figure figure, int depth) throws IOException {
        try {
            String elementName = this.figureFactory.getElementNameByFigure(figure);
            if (elementName == null) {
                return;
            }
            w.writeStartElement(elementName);
            this.writeElementAttributes(w, figure);
            this.writeElementNodeList(w, figure);
            for (Figure child : figure.getChildren()) {
                if (this.figureFactory.getElementNameByFigure(child) == null) continue;
                this.writeNodeRecursively(w, child, depth + 1);
            }
            w.writeEndElement();
        }
        catch (IOException | XMLStreamException e) {
            throw new IOException("Error writing figure " + String.valueOf(figure), e);
        }
    }

    protected void writeProcessingInstructions(@NonNull XMLStreamWriter w, @NonNull Drawing external) throws XMLStreamException {
        ImmutableList stylesheets;
        if (this.figureFactory.getStylesheetsKey() != null && (stylesheets = (ImmutableList)external.get(this.figureFactory.getStylesheetsKey())) != null) {
            for (URI stylesheet : stylesheets) {
                String stylesheetString = (stylesheet = this.idFactory.relativize(stylesheet)).toString();
                Object type = "text/" + stylesheetString.substring(stylesheetString.lastIndexOf(46) + 1);
                if ("text/".equals(type)) {
                    type = "text/css";
                }
                w.writeProcessingInstruction("xml-stylesheet", "type=\"" + (String)type + "\" href=\"" + String.valueOf(stylesheet) + "\"");
            }
        }
    }
}

