/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.draw.key;

import java.lang.reflect.Type;
import java.util.Map;
import java.util.Objects;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.fxbase.styleable.ReadOnlyStyleableMapAccessor;
import org.jhotdraw8.fxbase.styleable.WritableStyleableMapAccessor;
import org.jhotdraw8.fxcollection.typesafekey.CompositeMapAccessor;
import org.jhotdraw8.fxcollection.typesafekey.Key;
import org.jhotdraw8.fxcollection.typesafekey.MapAccessor;
import org.jhotdraw8.icollection.ChampVectorSet;
import org.jhotdraw8.icollection.immutable.ImmutableSequencedSet;

public abstract class AbstractStyleableMapAccessor<T>
implements WritableStyleableMapAccessor<T>,
CompositeMapAccessor<T> {
    private final @NonNull String cssName;
    private final @NonNull String name;
    private final @Nullable T defaultValue;
    private final @NonNull Type type;
    private final @NonNull ImmutableSequencedSet<MapAccessor<?>> subAccessors;

    public AbstractStyleableMapAccessor(@NonNull String name, @NonNull Class<T> type, @NonNull MapAccessor<?>[] subAccessors, T defaultValue) {
        this(name, type, null, subAccessors, defaultValue);
    }

    public AbstractStyleableMapAccessor(@NonNull String name, @NonNull Class<?> type, @Nullable Class<?>[] typeParameters, @NonNull MapAccessor<?>[] subAccessors, @Nullable T defaultValue) {
        Objects.requireNonNull(name, "name");
        Objects.requireNonNull(type, "clazz");
        this.name = name;
        this.type = type;
        this.defaultValue = defaultValue;
        this.subAccessors = ChampVectorSet.of((Object[])subAccessors);
        this.cssName = ReadOnlyStyleableMapAccessor.toCssName((String)name);
    }

    public boolean containsKey(@NonNull Map<Key<?>, Object> map) {
        return super.containsKey(map);
    }

    public @NonNull String getName() {
        return this.name;
    }

    public @NonNull Type getValueType() {
        return this.type;
    }

    public @Nullable T getDefaultValue() {
        return this.defaultValue;
    }

    public final @Nullable T put(@NonNull Map<? super Key<?>, Object> a, @Nullable T value) {
        Object oldValue = this.get(a);
        this.set(a, value);
        return (T)oldValue;
    }

    public @NonNull String toString() {
        String keyClass = this.getClass().getName();
        return keyClass.substring(keyClass.lastIndexOf(46) + 1) + "{name:" + this.name + " type:" + String.valueOf(this.getValueType()) + "}";
    }

    public @NonNull ImmutableSequencedSet<MapAccessor<?>> getSubAccessors() {
        return this.subAccessors;
    }

    public boolean isTransient() {
        return false;
    }

    public @NonNull String getCssName() {
        return this.cssName;
    }
}

