/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.draw.key;

import java.util.Map;
import javafx.geometry.Rectangle2D;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.draw.key.AbstractMapAccessor;
import org.jhotdraw8.fxcollection.typesafekey.Key;
import org.jhotdraw8.fxcollection.typesafekey.MapAccessor;
import org.jhotdraw8.icollection.immutable.ImmutableMap;

public class Rectangle2DMapAccessor
extends AbstractMapAccessor<Rectangle2D> {
    private final @NonNull MapAccessor<Double> xKey;
    private final @NonNull MapAccessor<Double> yKey;
    private final @NonNull MapAccessor<Double> widthKey;
    private final @NonNull MapAccessor<Double> heightKey;

    public Rectangle2DMapAccessor(String name, @NonNull MapAccessor<Double> xKey, @NonNull MapAccessor<Double> yKey, @NonNull MapAccessor<Double> widthKey, @NonNull MapAccessor<Double> heightKey) {
        super(name, Rectangle2D.class, new MapAccessor[]{xKey, yKey, widthKey, heightKey}, new Rectangle2D(((Double)xKey.getDefaultValue()).doubleValue(), ((Double)yKey.getDefaultValue()).doubleValue(), ((Double)widthKey.getDefaultValue()).doubleValue(), ((Double)heightKey.getDefaultValue()).doubleValue()));
        this.xKey = xKey;
        this.yKey = yKey;
        this.widthKey = widthKey;
        this.heightKey = heightKey;
    }

    public @NonNull Rectangle2D get(@NonNull Map<? super Key<?>, Object> a) {
        return new Rectangle2D(((Double)this.xKey.get(a)).doubleValue(), ((Double)this.yKey.get(a)).doubleValue(), Double.max(0.0, (Double)this.widthKey.get(a)), Double.max(0.0, (Double)this.heightKey.get(a)));
    }

    public @NonNull Rectangle2D put(@NonNull Map<? super Key<?>, Object> a, @Nullable Rectangle2D value) {
        Rectangle2D oldValue = this.get(a);
        if (value == null) {
            this.remove(a);
        } else {
            this.xKey.put(a, (Object)value.getMinX());
            this.yKey.put(a, (Object)value.getMinY());
            this.widthKey.put(a, (Object)value.getWidth());
            this.heightKey.put(a, (Object)value.getHeight());
        }
        return oldValue;
    }

    public @NonNull Rectangle2D remove(@NonNull Map<? super Key<?>, Object> a) {
        Rectangle2D oldValue = this.get(a);
        this.xKey.remove(a);
        this.yKey.remove(a);
        this.widthKey.remove(a);
        this.heightKey.remove(a);
        return oldValue;
    }

    public @NonNull ImmutableMap<Key<?>, Object> put(@NonNull ImmutableMap<Key<?>, Object> a, @Nullable Rectangle2D value) {
        if (value == null) {
            return this.remove(a);
        }
        a = this.xKey.put(a, (Object)value.getMinX());
        a = this.yKey.put(a, (Object)value.getMinY());
        a = this.widthKey.put(a, (Object)value.getWidth());
        return this.heightKey.put(a, (Object)value.getHeight());
    }

    public @NonNull ImmutableMap<Key<?>, Object> remove(@NonNull ImmutableMap<Key<?>, Object> a) {
        a = this.xKey.remove(a);
        a = this.yKey.remove(a);
        a = this.widthKey.remove(a);
        return this.heightKey.remove(a);
    }
}

