/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.draw.key;

import java.util.Map;
import javafx.scene.shape.StrokeLineCap;
import javafx.scene.shape.StrokeLineJoin;
import javafx.scene.shape.StrokeType;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.base.converter.Converter;
import org.jhotdraw8.css.value.CssSize;
import org.jhotdraw8.draw.css.converter.StrokeStyleCssConverter;
import org.jhotdraw8.draw.css.value.CssStrokeStyle;
import org.jhotdraw8.draw.key.AbstractStyleableMapAccessor;
import org.jhotdraw8.fxcollection.typesafekey.Key;
import org.jhotdraw8.fxcollection.typesafekey.MapAccessor;
import org.jhotdraw8.icollection.immutable.ImmutableList;
import org.jhotdraw8.icollection.immutable.ImmutableMap;

public class StrokeStyleableMapAccessor
extends AbstractStyleableMapAccessor<CssStrokeStyle> {
    private final @NonNull MapAccessor<CssSize> dashOffsetKey;
    private final @NonNull MapAccessor<ImmutableList<CssSize>> dashArrayKey;
    private final @NonNull MapAccessor<StrokeType> typeKey;
    private final @NonNull MapAccessor<StrokeLineJoin> lineJoinKey;
    private final @NonNull MapAccessor<StrokeLineCap> lineCapKey;
    private final @NonNull MapAccessor<CssSize> miterLimitKey;
    private final Converter<CssStrokeStyle> converter = new StrokeStyleCssConverter(false);

    public StrokeStyleableMapAccessor(String name, @NonNull MapAccessor<StrokeType> typeKey, @NonNull MapAccessor<StrokeLineCap> lineCapKey, @NonNull MapAccessor<StrokeLineJoin> lineJoinKey, @NonNull MapAccessor<CssSize> miterLimitKey, @NonNull MapAccessor<CssSize> dashOffsetKey, @NonNull MapAccessor<ImmutableList<CssSize>> dashArrayKey) {
        super(name, CssStrokeStyle.class, new MapAccessor[]{typeKey, lineJoinKey, lineCapKey, miterLimitKey, dashOffsetKey, dashArrayKey}, new CssStrokeStyle((StrokeType)typeKey.getDefaultValue(), (StrokeLineCap)lineCapKey.getDefaultValue(), (StrokeLineJoin)lineJoinKey.getDefaultValue(), (CssSize)miterLimitKey.getDefaultValue(), (CssSize)dashOffsetKey.getDefaultValue(), (ImmutableList<CssSize>)((ImmutableList)dashArrayKey.getDefaultValue())));
        this.dashOffsetKey = dashOffsetKey;
        this.dashArrayKey = dashArrayKey;
        this.typeKey = typeKey;
        this.lineJoinKey = lineJoinKey;
        this.lineCapKey = lineCapKey;
        this.miterLimitKey = miterLimitKey;
    }

    public CssStrokeStyle get(@NonNull Map<? super Key<?>, Object> a) {
        return new CssStrokeStyle((StrokeType)this.typeKey.get(a), (StrokeLineCap)this.lineCapKey.get(a), (StrokeLineJoin)this.lineJoinKey.get(a), (CssSize)this.miterLimitKey.get(a), (CssSize)this.dashOffsetKey.get(a), (ImmutableList<CssSize>)((ImmutableList)this.dashArrayKey.get(a)));
    }

    public @NonNull Converter<CssStrokeStyle> getCssConverter() {
        return this.converter;
    }

    @Override
    public boolean isTransient() {
        return true;
    }

    public CssStrokeStyle remove(@NonNull Map<? super Key<?>, Object> a) {
        Object oldValue = this.get((Map)a);
        this.typeKey.remove(a);
        this.lineJoinKey.remove(a);
        this.lineCapKey.remove(a);
        this.miterLimitKey.remove(a);
        this.dashOffsetKey.remove(a);
        this.dashArrayKey.remove(a);
        return oldValue;
    }

    public void set(@NonNull Map<? super Key<?>, Object> a, @Nullable CssStrokeStyle value) {
        if (value == null) {
            this.remove((Map)a);
        } else {
            this.dashOffsetKey.put(a, (Object)value.getDashOffset());
            this.dashArrayKey.put(a, value.getDashArray());
            this.typeKey.put(a, (Object)value.getType());
            this.lineJoinKey.put(a, (Object)value.getLineJoin());
            this.lineCapKey.put(a, (Object)value.getLineCap());
            this.miterLimitKey.put(a, (Object)value.getMiterLimit());
        }
    }

    @Override
    public @NonNull ImmutableMap<Key<?>, Object> put(@NonNull ImmutableMap<Key<?>, Object> a, @Nullable CssStrokeStyle value) {
        if (value == null) {
            return this.remove(a);
        }
        a = this.dashOffsetKey.put(a, (Object)value.getDashOffset());
        a = this.dashArrayKey.put(a, value.getDashArray());
        a = this.typeKey.put(a, (Object)value.getType());
        a = this.lineJoinKey.put(a, (Object)value.getLineJoin());
        a = this.lineCapKey.put(a, (Object)value.getLineCap());
        return this.miterLimitKey.put(a, (Object)value.getMiterLimit());
    }

    public @NonNull ImmutableMap<Key<?>, Object> remove(@NonNull ImmutableMap<Key<?>, Object> a) {
        a = this.typeKey.remove(a);
        a = this.lineJoinKey.remove(a);
        a = this.lineCapKey.remove(a);
        a = this.miterLimitKey.remove(a);
        a = this.dashOffsetKey.remove(a);
        return this.dashArrayKey.remove(a);
    }
}

