/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.draw.model;

import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.base.event.Event;
import org.jhotdraw8.draw.figure.Drawing;
import org.jhotdraw8.draw.figure.Figure;
import org.jhotdraw8.draw.model.DrawingModel;
import org.jhotdraw8.fxcollection.typesafekey.Key;

public class DrawingModelEvent
extends Event<DrawingModel> {
    private static final long serialVersionUID = 1L;
    private final Figure figure;
    private final Key<?> key;
    private final Object oldValue;
    private final Object newValue;
    private final Figure parent;
    private final Drawing drawing;
    private final int index;
    private final EventType eventType;
    private final boolean valueWasAdded;
    private final boolean valueWasRemoved;

    private DrawingModelEvent(@NonNull DrawingModel source, EventType eventType, Figure figure, Figure parent, Drawing drawing, int index, Key<?> key, Object oldValue, Object newValue, boolean valueWasAdded, boolean valueWasRemoved) {
        super((Object)source);
        this.figure = figure;
        this.key = key;
        this.oldValue = oldValue;
        this.newValue = newValue;
        this.parent = parent;
        this.drawing = drawing;
        this.index = index;
        this.eventType = eventType;
        this.valueWasAdded = valueWasAdded;
        this.valueWasRemoved = valueWasRemoved;
    }

    public static <T> @NonNull DrawingModelEvent propertyValueChanged(@NonNull DrawingModel source, Figure figure, Key<T> key, T oldValue, T newValue, boolean wasAdded, boolean wasRemoved) {
        return new DrawingModelEvent(source, EventType.PROPERTY_VALUE_CHANGED, figure, null, null, -1, key, oldValue, newValue, wasAdded, wasRemoved);
    }

    public static <T> @NonNull DrawingModelEvent transformChanged(@NonNull DrawingModel source, Figure figure) {
        return new DrawingModelEvent(source, EventType.TRANSFORM_CHANGED, figure, null, null, -1, null, null, null, false, false);
    }

    public static <T> @NonNull DrawingModelEvent layoutChanged(@NonNull DrawingModel source, Figure figure) {
        return new DrawingModelEvent(source, EventType.LAYOUT_CHANGED, figure, null, null, -1, null, null, null, false, false);
    }

    public static <T> @NonNull DrawingModelEvent styleInvalidated(@NonNull DrawingModel source, Figure figure) {
        return new DrawingModelEvent(source, EventType.STYLE_CHANGED, figure, null, null, -1, null, null, null, false, false);
    }

    public Figure getNode() {
        return this.figure;
    }

    public <T> @NonNull Key<T> getKey() {
        Key<?> tmp = this.key;
        return tmp;
    }

    public <T> @Nullable T getOldValue() {
        Object temp = this.oldValue;
        return (T)temp;
    }

    public <T> @Nullable T getNewValue() {
        Object temp = this.newValue;
        return (T)temp;
    }

    public Figure getParent() {
        return this.parent;
    }

    public Drawing getDrawing() {
        return this.drawing;
    }

    public Figure getChild() {
        return this.figure;
    }

    public int getIndex() {
        return this.index;
    }

    public EventType getEventType() {
        return this.eventType;
    }

    public boolean wasAdded() {
        return this.valueWasAdded;
    }

    public boolean wasRemoved() {
        return this.valueWasRemoved;
    }

    public @NonNull String toString() {
        return "DrawingModelEvent{" + (this.figure == null ? null : this.figure.getTypeSelector() + "@" + Integer.toHexString(System.identityHashCode(this.figure))) + ", key=" + String.valueOf(this.key) + ", oldValue=" + String.valueOf(this.oldValue) + ", newValue=" + String.valueOf(this.newValue) + ", parent=" + (this.parent == null ? null : this.parent.getTypeSelector() + "@" + Integer.toHexString(System.identityHashCode(this.parent))) + ", index=" + this.index + ", eventType=" + String.valueOf((Object)this.eventType) + ", source=" + String.valueOf(this.source) + "}";
    }

    public static enum EventType {
        PROPERTY_VALUE_CHANGED,
        LAYOUT_CHANGED,
        STYLE_CHANGED,
        TRANSFORM_CHANGED;

    }
}

