/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.draw.model;

import java.util.AbstractMap;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.beans.property.SimpleObjectProperty;
import javafx.scene.transform.Transform;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.base.event.Listener;
import org.jhotdraw8.css.value.CssSize;
import org.jhotdraw8.draw.css.value.CssPoint2D;
import org.jhotdraw8.draw.figure.ChildLayoutingFigure;
import org.jhotdraw8.draw.figure.Drawing;
import org.jhotdraw8.draw.figure.Figure;
import org.jhotdraw8.draw.figure.FigurePropertyChangeEvent;
import org.jhotdraw8.draw.figure.Layer;
import org.jhotdraw8.draw.model.AbstractDrawingModel;
import org.jhotdraw8.draw.model.DirtyMask;
import org.jhotdraw8.draw.model.DrawingModelEvent;
import org.jhotdraw8.draw.model.DrawingModelFigureProperty;
import org.jhotdraw8.draw.render.RenderContext;
import org.jhotdraw8.draw.render.SimpleRenderContext;
import org.jhotdraw8.fxbase.tree.TreeModel;
import org.jhotdraw8.fxbase.tree.TreeModelEvent;
import org.jhotdraw8.fxcollection.typesafekey.Key;
import org.jhotdraw8.fxcollection.typesafekey.MapAccessor;
import org.jhotdraw8.fxcollection.typesafekey.NonNullMapAccessor;
import org.jhotdraw8.graph.DirectedGraph;
import org.jhotdraw8.graph.SimpleMutableDirectedGraph;
import org.jhotdraw8.graph.algo.TopologicalSortAlgo;

public class SimpleDrawingModel
extends AbstractDrawingModel {
    private final @NonNull MapProxy mapProxy = new MapProxy();
    private boolean valid = true;
    private final @NonNull Set<Figure> dirties = Collections.newSetFromMap(new IdentityHashMap());
    private final Listener<FigurePropertyChangeEvent> propertyChangeHandler = this::onPropertyChanged;
    private final @NonNull ObjectProperty<Drawing> root = new SimpleObjectProperty<Drawing>((Object)this, "root"){

        public void set(@Nullable Drawing newValue) {
            Drawing oldValue = (Drawing)this.get();
            if (newValue == null && oldValue != null) {
                throw new IllegalArgumentException("null");
            }
            super.set((Object)newValue);
            SimpleDrawingModel.this.onRootChanged(oldValue, newValue);
        }
    };
    private final @NonNull BiFunction<? super DirtyMask, ? super DirtyMask, ? extends DirtyMask> mergeDirtyMask = DirtyMask::add;
    private final boolean listenOnDrawing;
    private final ReadOnlyBooleanWrapper validating = new ReadOnlyBooleanWrapper((Object)this, "layoutIsInProgress");

    public SimpleDrawingModel() {
        this.listenOnDrawing = true;
    }

    public SimpleDrawingModel(boolean listenOnDrawing) {
        this.listenOnDrawing = listenOnDrawing;
    }

    private void invalidate() {
        if (this.valid) {
            this.valid = false;
            this.fireDrawingModelInvalidated();
        }
    }

    private void onRootChanged(@Nullable Drawing oldValue, @Nullable Drawing newValue) {
        if (this.listenOnDrawing) {
            if (oldValue != null) {
                oldValue.getPropertyChangeListeners().remove(this.propertyChangeHandler);
            }
            if (newValue != null) {
                newValue.getPropertyChangeListeners().add(this.propertyChangeHandler);
            }
        }
        this.fireTreeModelEvent((TreeModelEvent<Figure>)TreeModelEvent.rootChanged((TreeModel)this, (Object)oldValue, (Object)newValue));
    }

    private void onPropertyChanged(@NonNull FigurePropertyChangeEvent event) {
        this.fireDrawingModelEvent(DrawingModelEvent.propertyValueChanged(this, (Figure)event.getSource(), event.getKey(), event.getOldValue(), event.getNewValue(), event.wasAdded(), event.wasRemoved()));
        this.fireTreeModelEvent((TreeModelEvent<Figure>)TreeModelEvent.nodeChanged((TreeModel)this, (Object)((Figure)event.getSource())));
    }

    private void markDirty(@NonNull Figure figure) {
        this.dirties.add(figure);
    }

    private void removeDirty(@NonNull Figure figure) {
        this.dirties.remove(figure);
    }

    @Override
    public @NonNull ObjectProperty<Drawing> drawingProperty() {
        return this.root;
    }

    public @NonNull ObjectProperty<Figure> rootProperty() {
        return this.root;
    }

    @Override
    public void removeFromParent(@NonNull Figure child) {
        int index;
        Figure oldRoot = child.getRoot();
        for (Figure f : child.preorderIterable()) {
            this.fireTreeModelEvent((TreeModelEvent<Figure>)TreeModelEvent.nodeRemovedFromTree((TreeModel)this, (Object)oldRoot, (Object)f));
        }
        Figure parent = child.getParent();
        if (parent != null && (index = parent.getChildren().indexOf((Object)child)) != -1) {
            parent.getChildren().remove(index);
            this.fireTreeModelEvent((TreeModelEvent<Figure>)TreeModelEvent.nodeRemovedFromParent((TreeModel)this, (Object)child, (Object)parent, (int)index));
            this.fireTreeModelEvent((TreeModelEvent<Figure>)TreeModelEvent.nodeChanged((TreeModel)this, (Object)parent));
        }
    }

    @Override
    public Figure removeFromParent(@NonNull Figure parent, int index) {
        Figure child = (Figure)parent.getChild(index);
        Figure oldRoot = child.getRoot();
        for (Figure f : child.preorderIterable()) {
            this.fireTreeModelEvent((TreeModelEvent<Figure>)TreeModelEvent.nodeRemovedFromTree((TreeModel)this, (Object)oldRoot, (Object)f));
        }
        parent.getChildren().remove(index);
        this.fireTreeModelEvent((TreeModelEvent<Figure>)TreeModelEvent.nodeRemovedFromParent((TreeModel)this, (Object)child, (Object)parent, (int)index));
        this.fireTreeModelEvent((TreeModelEvent<Figure>)TreeModelEvent.nodeChanged((TreeModel)this, (Object)parent));
        return child;
    }

    @Override
    public void insertChildAt(@NonNull Figure child, @NonNull Figure parent, int index) {
        if (!parent.isSuitableChild(child) || !child.isSuitableParent(parent)) {
            return;
        }
        Figure oldRoot = child.getRoot();
        Figure oldParent = child.getParent();
        if (oldParent != null) {
            int oldChildIndex = oldParent.getChildren().indexOf((Object)child);
            oldParent.removeChild(child);
            this.fireTreeModelEvent((TreeModelEvent<Figure>)TreeModelEvent.nodeRemovedFromParent((TreeModel)this, (Object)child, (Object)oldParent, (int)oldChildIndex));
            this.fireTreeModelEvent((TreeModelEvent<Figure>)TreeModelEvent.nodeChanged((TreeModel)this, (Object)oldParent));
        }
        parent.getChildren().add(index, (Object)child);
        Figure newRoot = child.getRoot();
        if (oldRoot != newRoot) {
            if (oldRoot != null) {
                for (Figure f : child.preorderIterable()) {
                    this.fireTreeModelEvent((TreeModelEvent<Figure>)TreeModelEvent.nodeRemovedFromTree((TreeModel)this, (Object)oldRoot, (Object)f));
                }
            }
            if (newRoot == this.getRoot()) {
                for (Figure f : child.preorderIterable()) {
                    this.fireTreeModelEvent((TreeModelEvent<Figure>)TreeModelEvent.nodeAddedToTree((TreeModel)this, (Object)newRoot, (Object)f));
                }
            }
        }
        this.fireTreeModelEvent((TreeModelEvent<Figure>)TreeModelEvent.nodeAddedToParent((TreeModel)this, (Object)child, (Object)parent, (int)index));
        this.fireTreeModelEvent((TreeModelEvent<Figure>)TreeModelEvent.nodeChanged((TreeModel)this, (Object)parent));
    }

    @Override
    public <T> @NonNull T setNonNull(@NonNull Figure figure, @NonNull NonNullMapAccessor<T> key, @NonNull T newValue) {
        T v = this.set(figure, (MapAccessor<T>)key, newValue);
        return Objects.requireNonNull(v, "oldValue");
    }

    @Override
    public <T> T set(@NonNull Figure figure, @NonNull MapAccessor<T> key, @Nullable T newValue) {
        if (key instanceof Key) {
            return (T)figure.put(key, newValue);
        }
        this.mapProxy.setFigure(figure);
        this.mapProxy.setTarget((Map<Key<?>, Object>)figure.getProperties());
        Object oldValue = key.put((Map)this.mapProxy, newValue);
        this.mapProxy.setFigure(null);
        this.mapProxy.setTarget(null);
        return (T)oldValue;
    }

    @Override
    public <T> T remove(@NonNull Figure figure, @NonNull MapAccessor<T> key) {
        if (key instanceof Key) {
            boolean wasRemoved = figure.getProperties().containsKey(key);
            Object oldValue = figure.remove((Key)key);
            Key keyObject = (Key)key;
            return (T)oldValue;
        }
        this.mapProxy.setFigure(figure);
        this.mapProxy.setTarget((Map<Key<?>, Object>)figure.getProperties());
        Object oldValue = key.remove((Map)this.mapProxy);
        this.mapProxy.setFigure(null);
        this.mapProxy.setTarget(null);
        return (T)oldValue;
    }

    @Override
    public <T> T remove(@NonNull Figure figure, @NonNull Key<T> key) {
        boolean wasRemoved = figure.getProperties().containsKey(key);
        Object oldValue = figure.remove(key);
        return (T)oldValue;
    }

    @Override
    public <T> @NonNull Property<T> propertyAt(Figure f, Key<T> key) {
        return new DrawingModelFigureProperty<T>(this, f, key);
    }

    @Override
    public void reshapeInLocal(@NonNull Figure f, Transform transform) {
        f.reshapeInLocal(transform);
        this.fireDrawingModelEvent(DrawingModelEvent.layoutChanged(this, f));
        this.fireTreeModelEvent((TreeModelEvent<Figure>)TreeModelEvent.nodeChanged((TreeModel)this, (Object)f));
    }

    @Override
    public void reshapeInParent(@NonNull Figure f, Transform transform) {
        f.reshapeInParent(transform);
        this.fireDrawingModelEvent(DrawingModelEvent.layoutChanged(this, f));
        this.fireTreeModelEvent((TreeModelEvent<Figure>)TreeModelEvent.nodeChanged((TreeModel)this, (Object)f));
    }

    @Override
    public void translateInParent(@NonNull Figure f, CssPoint2D delta) {
        f.translateInParent(delta);
        this.fireDrawingModelEvent(DrawingModelEvent.layoutChanged(this, f));
        this.fireTreeModelEvent((TreeModelEvent<Figure>)TreeModelEvent.nodeChanged((TreeModel)this, (Object)f));
    }

    @Override
    public void transformInParent(@NonNull Figure f, Transform transform) {
        f.transformInParent(transform);
        this.fireDrawingModelEvent(DrawingModelEvent.transformChanged(this, f));
        this.fireTreeModelEvent((TreeModelEvent<Figure>)TreeModelEvent.nodeChanged((TreeModel)this, (Object)f));
    }

    @Override
    public void transformInLocal(@NonNull Figure f, Transform transform) {
        f.transformInLocal(transform);
        this.fireDrawingModelEvent(DrawingModelEvent.transformChanged(this, f));
        this.fireTreeModelEvent((TreeModelEvent<Figure>)TreeModelEvent.nodeChanged((TreeModel)this, (Object)f));
    }

    @Override
    public void reshapeInLocal(@NonNull Figure f, double x, double y, double width, double height) {
        f.reshapeInLocal(x, y, width, height);
        this.fireDrawingModelEvent(DrawingModelEvent.layoutChanged(this, f));
        this.fireTreeModelEvent((TreeModelEvent<Figure>)TreeModelEvent.nodeChanged((TreeModel)this, (Object)f));
    }

    @Override
    public void reshapeInLocal(@NonNull Figure f, @NonNull CssSize x, @NonNull CssSize y, @NonNull CssSize width, @NonNull CssSize height) {
        f.reshapeInLocal(x, y, width, height);
        this.fireDrawingModelEvent(DrawingModelEvent.layoutChanged(this, f));
        this.fireTreeModelEvent((TreeModelEvent<Figure>)TreeModelEvent.nodeChanged((TreeModel)this, (Object)f));
    }

    @Override
    public void layout(@NonNull Figure f, @NonNull RenderContext ctx) {
        this.validating.set(true);
        f.layoutChanged(ctx);
        this.fireDrawingModelEvent(DrawingModelEvent.layoutChanged(this, f));
        this.fireTreeModelEvent((TreeModelEvent<Figure>)TreeModelEvent.nodeChanged((TreeModel)this, (Object)f));
        this.validating.set(false);
    }

    @Override
    public boolean isValidating() {
        return this.validating.get();
    }

    @Override
    public ReadOnlyBooleanProperty validatingProperty() {
        return this.validating.getReadOnlyProperty();
    }

    @Override
    public void disconnect(@NonNull Figure f) {
        f.disconnect();
    }

    @Override
    public void updateCss(@NonNull Figure figure) {
        figure.stylesheetChanged(new SimpleRenderContext());
    }

    @Override
    public void validate(@NonNull RenderContext ctx) {
        if (!this.valid) {
            this.validating.set(true);
            for (Figure figure : this.dirties) {
                figure.layoutSubjectChanged();
                figure.layoutObserverChanged();
            }
            Set subtrees = Collections.newSetFromMap(new IdentityHashMap(this.dirties.size() * 2));
            for (Figure f : this.dirties) {
                if (!subtrees.add(f) || f instanceof Layer) continue;
                f.preorderSpliterator().forEachRemaining(subtrees::add);
            }
            Set set = Collections.newSetFromMap(new IdentityHashMap(subtrees.size() * 2));
            SimpleMutableDirectedGraph graphBuilder = new SimpleMutableDirectedGraph();
            ArrayDeque queue = new ArrayDeque(subtrees);
            while (!queue.isEmpty()) {
                Figure parent;
                Figure f = (Figure)queue.removeFirst();
                if (!set.add(f)) continue;
                graphBuilder.addVertex((Object)f);
                Iterator it = f.ancestorIterable().iterator();
                Figure layoutRoot = f;
                Figure child = (Figure)it.next();
                while (it.hasNext() && (parent = (Figure)it.next()) instanceof ChildLayoutingFigure) {
                    layoutRoot = parent;
                    graphBuilder.addVertex((Object)layoutRoot);
                    graphBuilder.addArrow((Object)child, (Object)layoutRoot, null);
                    child = layoutRoot;
                }
                for (Figure obs : f.getReadOnlyLayoutObservers()) {
                    graphBuilder.addVertex((Object)obs);
                    graphBuilder.addArrow((Object)layoutRoot, (Object)obs, null);
                    if (set.contains(obs)) continue;
                    queue.add(obs);
                }
            }
            if (graphBuilder.getVertexCount() > 0) {
                for (Figure f : new TopologicalSortAlgo().sortTopologically((DirectedGraph)graphBuilder)) {
                    f.stylesheetChanged(ctx);
                    f.layoutChanged(ctx);
                    f.transformChanged();
                    this.fireNodeInvalidated(f);
                }
            }
            this.dirties.clear();
            this.validating.set(false);
            this.valid = true;
        }
    }

    @Override
    public void fireDrawingModelEvent(@NonNull DrawingModelEvent event) {
        super.fireDrawingModelEvent(event);
        this.onDrawingModelEvent(event);
    }

    public void fireTreeModelEvent(@NonNull TreeModelEvent<Figure> event) {
        super.fireTreeModelEvent(event);
        this.onTreeModelEvent(event);
    }

    protected void onDrawingModelEvent(@NonNull DrawingModelEvent event) {
        if (this.isValidating()) {
            return;
        }
        Figure figure = event.getNode();
        switch (event.getEventType()) {
            case TRANSFORM_CHANGED: 
            case STYLE_CHANGED: 
            case LAYOUT_CHANGED: {
                this.markDirty(figure);
                this.invalidate();
                break;
            }
            case PROPERTY_VALUE_CHANGED: {
                Key key = event.getKey();
                Object oldValue = event.getOldValue();
                Object newValue = event.getNewValue();
                figure.propertyChanged(key, oldValue, newValue);
                this.markDirty(figure);
                this.invalidate();
                break;
            }
            default: {
                throw new UnsupportedOperationException(String.valueOf((Object)event.getEventType()) + "not supported");
            }
        }
    }

    protected void onTreeModelEvent(@NonNull TreeModelEvent<Figure> event) {
        if (this.isValidating()) {
            return;
        }
        Figure figure = (Figure)event.getNode();
        switch (event.getEventType()) {
            case NODE_ADDED_TO_PARENT: {
                this.markDirty(figure);
                this.invalidate();
                break;
            }
            case NODE_ADDED_TO_TREE: {
                if (!(event.getRoot() instanceof Drawing)) break;
                figure.addedToDrawing((Drawing)event.getRoot());
                break;
            }
            case NODE_REMOVED_FROM_TREE: {
                if (event.getRoot() instanceof Drawing) {
                    figure.removedFromDrawing((Drawing)event.getRoot());
                }
                this.removeDirty(figure);
                break;
            }
            case NODE_REMOVED_FROM_PARENT: {
                this.markDirty((Figure)event.getParent());
                this.invalidate();
                break;
            }
            case NODE_CHANGED: {
                this.markDirty((Figure)event.getNode());
                this.invalidate();
                break;
            }
            case ROOT_CHANGED: {
                this.dirties.clear();
                this.valid = true;
                break;
            }
            case SUBTREE_NODES_CHANGED: {
                break;
            }
            default: {
                throw new UnsupportedOperationException(String.valueOf(event.getEventType()) + "not supported");
            }
        }
    }

    private static class MapProxy
    extends AbstractMap<Key<?>, Object> {
        private @Nullable Map<Key<?>, Object> target = null;
        private @Nullable Figure figure = null;

        private MapProxy() {
        }

        @Override
        public @NonNull Set<Map.Entry<Key<?>, Object>> entrySet() {
            return this.target == null ? Collections.emptySet() : this.target.entrySet();
        }

        public @Nullable Figure getFigure() {
            return this.figure;
        }

        public void setFigure(@Nullable Figure figure) {
            this.figure = figure;
        }

        public @Nullable Map<Key<?>, Object> getTarget() {
            return this.target;
        }

        public void setTarget(@Nullable Map<Key<?>, Object> target) {
            this.target = target;
        }

        @Override
        public Object put(Key<?> key, Object newValue) {
            if (this.target != null) {
                boolean wasAdded = !this.target.containsKey(key);
                Object oldValue = this.target.put(key, newValue);
                return oldValue;
            }
            return newValue;
        }
    }
}

