/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.draw.render;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import javafx.scene.Group;
import javafx.scene.Node;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.draw.figure.Drawing;
import org.jhotdraw8.draw.figure.Figure;
import org.jhotdraw8.draw.render.RenderContext;
import org.jhotdraw8.fxbase.beans.AbstractPropertyBean;
import org.jhotdraw8.fxcollection.typesafekey.Key;

public class SimpleDrawingRenderer
extends AbstractPropertyBean
implements RenderContext {
    protected final Map<Figure, Node> figureToNodeMap = new HashMap<Figure, Node>();

    @Override
    public Node getNode(@NonNull Figure f) {
        Node n = this.figureToNodeMap.get(f);
        if (n == null) {
            n = f.createNode(this);
            this.figureToNodeMap.put(f, n);
        }
        return n;
    }

    public Node render(@NonNull Figure figure) {
        this.figureToNodeMap.clear();
        this.renderRecursive(figure);
        return this.getNode(figure);
    }

    private void renderRecursive(@NonNull Figure figure) {
        figure.updateNode(this, this.getNode(figure));
        for (Figure child : figure.getChildren()) {
            this.renderRecursive(child);
        }
    }

    public static Node toNode(@NonNull Drawing external, @NonNull Collection<Figure> selection, @Nullable Map<Key<?>, Object> renderingHints) {
        SimpleDrawingRenderer r = new SimpleDrawingRenderer();
        if (renderingHints != null) {
            r.getProperties().putAll(renderingHints);
        }
        LinkedList<Node> nodes = new LinkedList<Node>();
        for (Figure f : external.preorderIterable()) {
            if (!selection.contains(f)) continue;
            nodes.add(r.render(f));
        }
        Object drawingNode = nodes.size() == 1 ? (Node)nodes.getFirst() : new Group(nodes);
        return drawingNode;
    }
}

