/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.draw.tool;

import java.util.function.Supplier;
import javafx.collections.ObservableList;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.application.resources.Resources;
import org.jhotdraw8.draw.DrawingView;
import org.jhotdraw8.draw.figure.Drawing;
import org.jhotdraw8.draw.figure.Figure;
import org.jhotdraw8.draw.figure.Layer;
import org.jhotdraw8.draw.tool.AbstractTool;

public abstract class AbstractCreationTool<F extends Figure>
extends AbstractTool {
    protected Supplier<Layer> layerFactory;
    protected Supplier<? extends F> figureFactory;
    protected @Nullable F createdFigure;

    public AbstractCreationTool(String name, Resources rsrc, Supplier<? extends F> figureFactory, Supplier<Layer> layerFactory) {
        super(name, rsrc);
        this.figureFactory = figureFactory;
        this.layerFactory = layerFactory;
    }

    public void setFigureFactory(Supplier<F> factory) {
        this.figureFactory = factory;
    }

    public void setLayerFactory(Supplier<Layer> factory) {
        this.layerFactory = factory;
    }

    protected F createFigure() {
        return (F)((Figure)this.figureFactory.get());
    }

    protected @Nullable Figure getOrCreateParent(@NonNull DrawingView dv, Figure newFigure) {
        Drawing drawing = dv.getDrawing();
        if (drawing == null) {
            return null;
        }
        Figure activeParent = dv.getActiveParent();
        if (activeParent != null && activeParent.isEditable() && activeParent.isAllowsChildren() && activeParent.isSuitableChild(newFigure) && newFigure.isSuitableParent(activeParent)) {
            return activeParent;
        }
        Figure layer = null;
        ObservableList<Figure> layers = drawing.getChildren();
        for (int i = layers.size() - 1; i >= 0; --i) {
            Figure candidate = (Figure)layers.get(i);
            if (!candidate.isEditable() || !candidate.isAllowsChildren() || !newFigure.isSuitableParent(candidate) || !candidate.isSuitableChild(newFigure)) continue;
            layer = candidate;
            break;
        }
        if (layer == null) {
            layer = this.layerFactory.get();
            dv.getModel().addChildTo(layer, drawing);
            if (layer.getParent() != drawing) {
                return drawing;
            }
        }
        return layer;
    }
}

