/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.draw.tool;

import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javafx.collections.ObservableList;
import javafx.geometry.Point2D;
import javafx.scene.input.MouseEvent;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.application.resources.Resources;
import org.jhotdraw8.draw.DrawingView;
import org.jhotdraw8.draw.connector.Connector;
import org.jhotdraw8.draw.css.value.CssPoint2D;
import org.jhotdraw8.draw.figure.ConnectableFigure;
import org.jhotdraw8.draw.figure.ConnectingFigure;
import org.jhotdraw8.draw.figure.Drawing;
import org.jhotdraw8.draw.figure.Figure;
import org.jhotdraw8.draw.figure.Layer;
import org.jhotdraw8.draw.figure.LayerFigure;
import org.jhotdraw8.draw.figure.LineConnectionFigure;
import org.jhotdraw8.draw.handle.HandleType;
import org.jhotdraw8.draw.model.DrawingModel;
import org.jhotdraw8.draw.tool.AbstractTool;
import org.jhotdraw8.fxcollection.typesafekey.MapAccessor;

public class ConnectionTool
extends AbstractTool {
    private @Nullable ConnectingFigure figure;
    private @NonNull Supplier<ConnectingFigure> figureFactory;
    private final @NonNull Supplier<Layer> layerFactory;
    private @Nullable HandleType handleType = null;

    public ConnectionTool(@NonNull String name, @Nullable Resources rsrc, @NonNull Supplier<ConnectingFigure> figureFactory) {
        this(name, rsrc, figureFactory, LayerFigure::new);
    }

    public ConnectionTool(@NonNull String name, @Nullable Resources rsrc, @NonNull Supplier<ConnectingFigure> figureFactory, @NonNull Supplier<Layer> layerFactory) {
        this(name, rsrc, null, figureFactory, layerFactory);
    }

    public ConnectionTool(@NonNull String name, @Nullable Resources rsrc, @Nullable HandleType handleType, @NonNull Supplier<ConnectingFigure> figureFactory, @NonNull Supplier<Layer> layerFactory) {
        super(name, rsrc);
        this.handleType = handleType;
        this.figureFactory = figureFactory;
        this.layerFactory = layerFactory;
    }

    public void setFactory(Supplier<ConnectingFigure> factory) {
        this.figureFactory = factory;
    }

    protected @Nullable Figure getOrCreateParent(@NonNull DrawingView dv, @NonNull Figure newFigure) {
        Drawing drawing = dv.getDrawing();
        if (drawing == null) {
            return null;
        }
        Figure activeParent = dv.getActiveParent();
        if (activeParent != null && activeParent.isEditable() && activeParent.isAllowsChildren()) {
            return activeParent;
        }
        Layer layer = null;
        ObservableList<Figure> layers = dv.getDrawing().getChildren();
        for (int i = layers.size() - 1; i >= 0; --i) {
            Figure candidate = (Figure)layers.get(i);
            if (!candidate.isEditable() || !candidate.isAllowsChildren() || !candidate.isSuitableChild(newFigure) || !newFigure.isSuitableParent(candidate)) continue;
            layer = (Layer)candidate;
            break;
        }
        if (layer == null) {
            layer = this.layerFactory.get();
            dv.getModel().addChildTo(layer, drawing);
        }
        return layer;
    }

    @Override
    protected void onMouseDragged(@NonNull MouseEvent event, @NonNull DrawingView view) {
        if (this.figure != null) {
            Point2D pointInViewCoordinates = new Point2D(event.getX(), event.getY());
            Point2D unconstrainedPoint = view.viewToWorld(pointInViewCoordinates);
            Point2D constrainedPoint = !event.isAltDown() && !event.isControlDown() ? view.getConstrainer().constrainPoint(this.figure, new CssPoint2D(unconstrainedPoint)).getConvertedValue() : unconstrainedPoint;
            double tolerance = view.getViewToWorld().transform(view.getEditor().getTolerance(), 0.0).getX();
            Connector newConnector = null;
            Figure newConnectionTarget = null;
            DrawingModel model = view.getModel();
            model.set(this.figure, LineConnectionFigure.END_TARGET, null);
            if (!event.isMetaDown()) {
                List<Figure> list = view.findFigures(pointInViewCoordinates, true).stream().map(Map.Entry::getKey).toList();
                block0: for (Figure f1 : list) {
                    for (Figure ff : f1.breadthFirstIterable()) {
                        if (this.figure == ff || !(ff instanceof ConnectableFigure)) continue;
                        ConnectableFigure cff = (ConnectableFigure)ff;
                        Point2D pointInLocal = cff.worldToLocal(unconstrainedPoint);
                        if (!ff.getLayoutBounds().contains(pointInLocal) || (newConnector = cff.findConnector(cff.worldToLocal(constrainedPoint), this.figure, tolerance)) == null || !this.figure.canConnect(ff, newConnector)) continue;
                        newConnectionTarget = ff;
                        break block0;
                    }
                }
            }
            model.set(this.figure, LineConnectionFigure.END, new CssPoint2D(this.figure.worldToLocal(constrainedPoint)));
            model.set(this.figure, LineConnectionFigure.END_CONNECTOR, newConnector);
            model.set(this.figure, LineConnectionFigure.END_TARGET, newConnectionTarget);
        }
        event.consume();
    }

    @Override
    protected void onMousePressed(@NonNull MouseEvent event, @NonNull DrawingView view) {
        this.requestFocus();
        this.figure = this.figureFactory.get();
        if (this.figure == null) {
            return;
        }
        Figure parent = this.getOrCreateParent(view, this.figure);
        if (parent == null) {
            this.figure = null;
            return;
        }
        if (this.handleType != null) {
            view.getEditor().setHandleType(this.handleType);
        }
        Point2D pointInViewCoordinates = new Point2D(event.getX(), event.getY());
        Point2D unconstrainedPoint = parent.worldToLocal(view.viewToWorld(pointInViewCoordinates));
        Point2D constrainedPoint = view.getConstrainer().constrainPoint(this.figure, new CssPoint2D(unconstrainedPoint)).getConvertedValue();
        this.figure.reshapeInLocal(constrainedPoint.getX(), constrainedPoint.getY(), 1.0, 1.0);
        DrawingModel dm = view.getModel();
        double tolerance = view.getViewToWorld().transform(view.getEditor().getTolerance(), 0.0).getX();
        view.setActiveParent(parent);
        Connector newConnector = null;
        Figure newConnectedFigure = null;
        if (!event.isMetaDown()) {
            List<Figure> list = view.findFigures(pointInViewCoordinates, true).stream().map(Map.Entry::getKey).toList();
            block0: for (Figure f1 : list) {
                for (Figure ff : f1.breadthFirstIterable()) {
                    if (this.figure == ff || !(ff instanceof ConnectableFigure)) continue;
                    ConnectableFigure cff = (ConnectableFigure)ff;
                    Point2D pointInLocal = cff.worldToLocal(unconstrainedPoint);
                    if (!ff.getLayoutBounds().contains(pointInLocal) || (newConnector = cff.findConnector(cff.worldToLocal(constrainedPoint), this.figure, tolerance)) == null || !this.figure.canConnect(ff, newConnector)) continue;
                    newConnectedFigure = ff;
                    break block0;
                }
            }
        }
        this.figure.set((MapAccessor)LineConnectionFigure.START_CONNECTOR, newConnector);
        this.figure.set((MapAccessor)LineConnectionFigure.START_TARGET, newConnectedFigure);
        dm.addChildTo(this.figure, parent);
        event.consume();
    }

    @Override
    protected void onMouseReleased(@NonNull MouseEvent event, @NonNull DrawingView view) {
        if (this.figure != null) {
            this.onMouseDragged(event, view);
            view.getSelectedFigures().clear();
            view.getSelectedFigures().add((Object)this.figure);
            this.figure = null;
        }
        this.fireToolDone();
    }

    @Override
    protected void stopEditing() {
        this.figure = null;
    }

    @Override
    public @NonNull String getHelpText() {
        return "ConnectionTool\n  Press the mouse on a figure in the drawing view, and drag the mouse to another figure. The tool will create a new figure which connects the two figures.";
    }
}

