/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.draw.tool;

import java.util.Collection;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import org.jhotdraw8.draw.DrawingView;
import org.jhotdraw8.draw.figure.Figure;
import org.jhotdraw8.draw.handle.Handle;
import org.jhotdraw8.draw.tool.AbstractTracker;
import org.jhotdraw8.draw.tool.HandleTracker;

public class SimpleHandleTracker
extends AbstractTracker
implements HandleTracker {
    private Handle handle;
    private Collection<Figure> compatibleFigures;

    @Override
    public void setHandles(Handle handle, Collection<Figure> compatibleFigures) {
        this.handle = handle;
        this.compatibleFigures = compatibleFigures;
    }

    @Override
    public void trackMousePressed(MouseEvent event, DrawingView dv) {
        this.stopCompositeEdit(dv);
        this.handle.onMousePressed(event, dv);
        this.node.setCursor(this.handle.getCursor());
        this.node.setAccessibleHelp(this.handle.getNode(dv).getAccessibleHelp());
        this.node.setAccessibleText(this.handle.getNode(dv).getAccessibleText());
    }

    @Override
    public void trackMouseClicked(MouseEvent event, DrawingView dv) {
        this.stopCompositeEdit(dv);
        this.handle.onMouseClicked(event, dv);
    }

    @Override
    public void trackMouseReleased(MouseEvent event, DrawingView dv) {
        this.handle.onMouseReleased(event, dv);
        this.node.setCursor(this.handle.getCursor());
        this.stopCompositeEdit(dv);
    }

    @Override
    public void trackMouseDragged(MouseEvent event, DrawingView dv) {
        this.startCompositeEdit(dv);
        this.handle.onMouseDragged(event, dv);
        this.node.setCursor(this.handle.getCursor());
    }

    @Override
    public void trackKeyPressed(KeyEvent event, DrawingView view) {
    }

    @Override
    public void trackKeyReleased(KeyEvent event, DrawingView view) {
    }

    @Override
    public void trackKeyTyped(KeyEvent event, DrawingView view) {
    }
}

