/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.draw.tool;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javafx.geometry.Bounds;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.application.ApplicationLabels;
import org.jhotdraw8.application.resources.Resources;
import org.jhotdraw8.draw.DrawingView;
import org.jhotdraw8.draw.figure.Figure;
import org.jhotdraw8.draw.figure.Layer;
import org.jhotdraw8.draw.tool.AbstractTracker;
import org.jhotdraw8.draw.tool.SelectAreaTracker;

public class SimpleSelectAreaTracker
extends AbstractTracker
implements SelectAreaTracker {
    public static final String STYLECLASS_TOOL_RUBBERBAND = "tool-rubberband";
    private final @NonNull Rectangle rubberband = new Rectangle();
    double x;
    double y;

    public SimpleSelectAreaTracker() {
        this("tool.selectArea", ApplicationLabels.getResources());
    }

    public SimpleSelectAreaTracker(String name, Resources rsrc) {
        this.node.getChildren().add((Object)this.rubberband);
        this.rubberband.setVisible(false);
        this.initNode(this.rubberband);
    }

    protected void initNode(@NonNull Rectangle r) {
        r.setFill(null);
        r.setStroke((Paint)Color.BLACK);
        this.rubberband.getStyleClass().add((Object)STYLECLASS_TOOL_RUBBERBAND);
    }

    @Override
    public void trackMousePressed(@NonNull MouseEvent event, DrawingView dv) {
        Bounds b = this.getNode().getBoundsInParent();
        this.x = event.getX();
        this.y = event.getY();
        this.rubberband.setVisible(true);
        this.rubberband.setX((double)Math.round(this.x) - 0.5);
        this.rubberband.setY((double)Math.round(this.y) - 0.5);
        this.rubberband.setWidth(0.0);
        this.rubberband.setHeight(0.0);
    }

    @Override
    public void trackMouseReleased(@NonNull MouseEvent event, @NonNull DrawingView dv) {
        this.rubberband.setVisible(false);
        double w = this.x - event.getX();
        double h = this.y - event.getY();
        List<Map.Entry<Figure, Double>> result = event.isAltDown() ? dv.findFiguresIntersecting(Math.min(this.x, event.getX()), Math.min(this.y, event.getY()), Math.abs(w), Math.abs(h), false, f -> !(f instanceof Layer) && f.isSelectable()) : dv.findFiguresInside(Math.min(this.x, event.getX()), Math.min(this.y, event.getY()), Math.abs(w), Math.abs(h), false);
        List<Figure> f2 = result.stream().map(Map.Entry::getKey).collect(Collectors.toList());
        if (event.isShiftDown()) {
            if (dv.getSelectedFigures().containsAll(f2)) {
                if (event.isMetaDown()) {
                    dv.getSelectedFigures().retainAll(f2);
                } else {
                    f2.forEach(arg_0 -> dv.getSelectedFigures().remove(arg_0));
                }
            } else {
                dv.selectedFiguresProperty().addAll(f2);
            }
        } else {
            dv.selectedFiguresProperty().clear();
            dv.selectedFiguresProperty().addAll(f2);
        }
    }

    @Override
    public void trackMouseDragged(@NonNull MouseEvent event, DrawingView dv) {
        double w = this.x - event.getX();
        double h = this.y - event.getY();
        this.rubberband.setX((double)Math.round(Math.min(this.x, event.getX())) - 0.5);
        this.rubberband.setY((double)Math.round(Math.min(this.y, event.getY())) - 0.5);
        this.rubberband.setWidth((double)Math.round(Math.abs(w)));
        this.rubberband.setHeight((double)Math.round(Math.abs(h)));
    }

    @Override
    public void trackMouseClicked(MouseEvent event, DrawingView view) {
    }

    @Override
    public void trackKeyPressed(KeyEvent event, DrawingView view) {
    }

    @Override
    public void trackKeyReleased(KeyEvent event, DrawingView view) {
    }

    @Override
    public void trackKeyTyped(KeyEvent event, DrawingView view) {
    }
}

