/*
 * @(#)AbstractViewBoxDrawing.java
 * Copyright © 2023 The authors and contributors of JHotDraw. MIT License.
 */

package org.jhotdraw8.draw.figure;

import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.layout.Pane;
import javafx.scene.transform.Transform;
import org.jhotdraw8.css.value.CssSize;
import org.jhotdraw8.css.value.UnitConverter;
import org.jhotdraw8.draw.render.RenderContext;

/**
 * Abstract drawing that supports {@link ViewBoxableDrawing}.
 */
public abstract class AbstractViewBoxDrawing extends AbstractDrawing implements ViewBoxableDrawing, Figure {
    public AbstractViewBoxDrawing() {
    }

    public AbstractViewBoxDrawing(double width, double height) {
        super(width, height);
    }

    public AbstractViewBoxDrawing(CssSize width, CssSize height) {
        super(width, height);
    }

    @Override
    public Transform getLocalToParent() {
        return Transform.translate(-getStyledNonNull(VIEW_BOX_X).getConvertedValue(),
                -getStyledNonNull(VIEW_BOX_Y).getConvertedValue());
    }

    @Override
    public Transform getParentToLocal() {
        return Transform.translate(getStyledNonNull(VIEW_BOX_X).getConvertedValue(),
                getStyledNonNull(VIEW_BOX_Y).getConvertedValue());
    }

    @Override
    public void updateNode(RenderContext ctx, Node n) {
        super.updateNode(ctx, n);
        final UnitConverter unitConverter = ctx.getNonNull(RenderContext.UNIT_CONVERTER_KEY);
        final double x = getStyledNonNull(VIEW_BOX_X).getConvertedValue(unitConverter);
        final double y = getStyledNonNull(VIEW_BOX_Y).getConvertedValue(unitConverter);

        Group gg = (Group) ((Pane) n).getChildrenUnmodifiable().getFirst();
        gg.setTranslateX(-x);
        gg.setTranslateY(-y);
    }

}
