/*
 * @(#)ImageableFigure.java
 * Copyright © 2023 The authors and contributors of JHotDraw. MIT License.
 */

package org.jhotdraw8.draw.figure;

import javafx.scene.image.ImageView;
import org.jhotdraw8.draw.key.NullableUriStyleableKey;

/**
 * Mixin interface for figures that have an image source.
 */
public interface ImageableFigure extends Figure {
    /**
     * The URI of the image.
     * <p>
     * This property should also be set on an {@link ImageView} node that
     * is generated by the figure.
     */
    NullableUriStyleableKey IMAGE_URI = new NullableUriStyleableKey("src", null);
}
