/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.draw;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlySetProperty;
import javafx.beans.property.ReadOnlySetWrapper;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableSet;
import javafx.scene.input.Clipboard;
import javafx.scene.input.DataFormat;
import org.jhotdraw8.draw.DrawingEditor;
import org.jhotdraw8.draw.DrawingView;
import org.jhotdraw8.draw.figure.Drawing;
import org.jhotdraw8.draw.figure.Figure;
import org.jhotdraw8.draw.figure.Layer;
import org.jhotdraw8.draw.handle.Handle;
import org.jhotdraw8.draw.input.ClipboardInputFormat;
import org.jhotdraw8.draw.input.ClipboardOutputFormat;
import org.jhotdraw8.draw.io.BitmapExportOutputFormat;
import org.jhotdraw8.draw.model.DrawingModel;
import org.jhotdraw8.draw.tool.Tool;
import org.jhotdraw8.fxbase.beans.AbstractPropertyBean;
import org.jhotdraw8.fxcollection.typesafekey.MapAccessor;
import org.jspecify.annotations.Nullable;

public abstract class AbstractDrawingView
extends AbstractPropertyBean
implements DrawingView {
    private final ObjectProperty<ClipboardOutputFormat> clipboardOutputFormat = new SimpleObjectProperty((Object)this, "clibpoardOutputFormat", (Object)new BitmapExportOutputFormat());
    private final ObjectProperty<DrawingEditor> editor = new SimpleObjectProperty((Object)this, "editor", null);
    private final ObjectProperty<ClipboardInputFormat> clipboardInputFormat = new SimpleObjectProperty((Object)this, "clipboardInputFormat");
    private final ReadOnlySetProperty<Figure> selectedFigures = new ReadOnlySetWrapper((Object)this, "selectedFigures", FXCollections.observableSet(new LinkedHashSet())).getReadOnlyProperty();
    private final ObjectProperty<Tool> tool = new SimpleObjectProperty((Object)this, "tool");
    private final ObjectProperty<Handle> activeHandle;

    public AbstractDrawingView() {
        this.tool.addListener(this::onToolChanged);
        InvalidationListener listener = observable -> {
            this.recreateHandles();
            this.invalidateHandles();
            this.repaint();
        };
        this.selectedFigures.addListener(listener);
        this.activeHandle = new SimpleObjectProperty((Object)this, "activeHandle");
    }

    @Override
    public ObjectProperty<DrawingEditor> editorProperty() {
        return this.editor;
    }

    @Override
    public ObjectProperty<ClipboardInputFormat> clipboardInputFormatProperty() {
        return this.clipboardInputFormat;
    }

    @Override
    public ObjectProperty<ClipboardOutputFormat> clipboardOutputFormatProperty() {
        return this.clipboardOutputFormat;
    }

    public void cut() {
        this.copy();
        ArrayList selectedFigures = new ArrayList(this.getSelectedFigures());
        DrawingModel m = this.getModel();
        for (Figure f : selectedFigures) {
            if (!f.isDeletable()) continue;
            for (Figure d : f.preorderIterable()) {
                m.disconnect(d);
            }
            m.removeFromParent(f);
        }
    }

    public void copy() {
        ClipboardOutputFormat out = this.getClipboardOutputFormat();
        Drawing drawing = this.getDrawing();
        if (out == null || drawing == null) {
            return;
        }
        LinkedHashMap<DataFormat, Object> content = new LinkedHashMap<DataFormat, Object>(){
            private static final long serialVersionUID = 0L;

            @Override
            public Object put(@Nullable DataFormat key, Object value) {
                Objects.requireNonNull(key, "key");
                return super.put(key, value);
            }
        };
        try {
            ObservableSet selectedFigures = this.getSelectedFigures();
            out.write((Map<DataFormat, Object>)content, drawing, (Collection<Figure>)(selectedFigures.isEmpty() ? FXCollections.singletonObservableList((Object)drawing) : selectedFigures));
            Clipboard.getSystemClipboard().setContent((Map)content);
        }
        catch (IOException ex) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, "Could not copy to clipboard.", ex);
        }
    }

    public void paste() {
        Figure parent = this.getActiveParent();
        if (parent == null || !parent.isEditable() || parent.getDrawing() != this.getDrawing()) {
            parent = null;
            for (Figure f : this.getDrawing().getChildren()) {
                if (!f.isEditable() || !(f instanceof Layer)) continue;
                parent = f;
            }
            if (parent == null) {
                return;
            }
        }
        Clipboard cb = Clipboard.getSystemClipboard();
        ClipboardInputFormat in = this.getClipboardInputFormat();
        if (in != null) {
            try {
                Set<Figure> pastedFigures = in.read(cb, this.getModel(), this.getDrawing(), parent);
                this.getSelectedFigures().clear();
                if (pastedFigures != null) {
                    this.getSelectedFigures().addAll(pastedFigures);
                }
            }
            catch (IOException ex) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, "Unexpected Exception " + ex.getMessage(), ex);
            }
        }
    }

    @Override
    public ObjectProperty<Tool> toolProperty() {
        return this.tool;
    }

    @Override
    public ObjectProperty<Handle> activeHandleProperty() {
        return this.activeHandle;
    }

    @Override
    public ReadOnlySetProperty<Figure> selectedFiguresProperty() {
        return this.selectedFigures;
    }

    protected abstract void invalidateHandles();

    protected abstract void repaint();

    protected abstract void onToolChanged(Observable var1, @Nullable Tool var2, @Nullable Tool var3);

    @Override
    public <T> void set(MapAccessor<T> key, @Nullable T value) {
        key.set((Map)this.properties, value);
    }
}

