/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.draw;

import java.util.prefs.Preferences;
import javafx.beans.property.Property;
import javafx.beans.value.ChangeListener;
import org.jhotdraw8.draw.DrawingEditor;
import org.jhotdraw8.draw.css.value.CssColor;

public class DrawingEditorPreferencesHandler {
    private static final String DRAWING_EDITOR = "DrawingEditor.";
    private final DrawingEditor editor;
    private final Preferences prefs;
    private final String prefix;

    public DrawingEditorPreferencesHandler(DrawingEditor editor, Preferences prefs) {
        this(editor, prefs, DRAWING_EDITOR);
    }

    public DrawingEditorPreferencesHandler(DrawingEditor editor, Preferences prefs, String prefix) {
        this.editor = editor;
        this.prefs = prefs;
        this.prefix = prefix;
        this.readPreferences();
        ChangeListener doublePropertyListener = (o, oldv, newv) -> prefs.putDouble(prefix + ((Property)o).getName(), newv.doubleValue());
        ChangeListener colorPropertyListener = (o, oldv, newv) -> prefs.put(prefix + ((Property)o).getName(), newv.getName());
        editor.handleSizeProperty().addListener(doublePropertyListener);
        editor.handleStrokeWidthProperty().addListener(doublePropertyListener);
        editor.toleranceProperty().addListener(doublePropertyListener);
        editor.handleColorProperty().addListener(colorPropertyListener);
    }

    private void readPreferences() {
        this.editor.setHandleSize(this.prefs.getDouble(this.prefix + "handleSize", this.editor.getHandleSize()));
        this.editor.setTolerance(this.prefs.getDouble(this.prefix + "tolerance", this.editor.getTolerance()));
        this.editor.setHandleStrokeWidth(this.prefs.getDouble(this.prefix + "handleStrokeWidth", this.editor.getHandleStrokeWidth()));
        this.editor.setHandleColor(CssColor.valueOf(this.prefs.get(this.prefix + "handleColor", this.editor.getHandleColor().getName())));
    }
}

