/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.draw;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.StreamSupport;
import javafx.application.Platform;
import javafx.beans.Observable;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.ReadOnlySetProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.ObservableSet;
import javafx.geometry.BoundingBox;
import javafx.geometry.Bounds;
import javafx.scene.Node;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.transform.Transform;
import org.jhotdraw8.application.EditableComponent;
import org.jhotdraw8.base.event.Listener;
import org.jhotdraw8.draw.AbstractDrawingView;
import org.jhotdraw8.draw.constrain.Constrainer;
import org.jhotdraw8.draw.constrain.NullConstrainer;
import org.jhotdraw8.draw.figure.Drawing;
import org.jhotdraw8.draw.figure.Figure;
import org.jhotdraw8.draw.figure.SimpleDrawing;
import org.jhotdraw8.draw.gui.ZoomableScrollPane;
import org.jhotdraw8.draw.handle.Handle;
import org.jhotdraw8.draw.model.DrawingModel;
import org.jhotdraw8.draw.model.SimpleDrawingModel;
import org.jhotdraw8.draw.render.InteractiveDrawingRenderer;
import org.jhotdraw8.draw.render.InteractiveHandleRenderer;
import org.jhotdraw8.draw.tool.Tool;
import org.jhotdraw8.fxbase.beans.NonNullObjectProperty;
import org.jhotdraw8.fxbase.binding.CustomBinding;
import org.jhotdraw8.fxbase.tree.TreeBreadthFirstSpliterator;
import org.jhotdraw8.fxbase.tree.TreeModelEvent;
import org.jspecify.annotations.Nullable;

public class SimpleDrawingView
extends AbstractDrawingView {
    public static final String CANVAS_REGION_STYLE_CLASS = "jhotdraw8-drawing-view-canvas-region";
    public static final String DRAWING_VIEW_STYLE_CLASS = "jhotdraw8-drawing-view";
    private final ZoomableScrollPane zoomableScrollPane = ZoomableScrollPane.create();
    private final SimpleDrawingViewNode node = new SimpleDrawingViewNode();
    private final NonNullObjectProperty<DrawingModel> model = new NonNullObjectProperty((Object)this, "model", (Object)new SimpleDrawingModel());
    private final ReadOnlyObjectWrapper<Drawing> drawing = new ReadOnlyObjectWrapper((Object)this, "drawing");
    private final ObjectProperty<Figure> activeParent = new SimpleObjectProperty((Object)this, "activeLayer");
    private final NonNullObjectProperty<Constrainer> constrainer = new NonNullObjectProperty((Object)this, "constrainer", (Object)new NullConstrainer());
    private final ReadOnlyBooleanWrapper focused = new ReadOnlyBooleanWrapper((Object)this, "focused");
    private final Region background = new Region();
    private final StackPane foreground = new StackPane();
    private final InteractiveDrawingRenderer drawingRenderer = new InteractiveDrawingRenderer();
    private final InteractiveHandleRenderer handleRenderer = new InteractiveHandleRenderer();
    private boolean constrainerNodeValid;
    private boolean isLayoutValid = true;
    private @Nullable Runnable repainter = null;
    private final Listener<TreeModelEvent<Figure>> treeModelListener = this::onTreeModelEvent;

    public SimpleDrawingView() {
        this.initStyle();
        this.initLayout();
        this.initBindings();
        this.initBehavior();
    }

    @Override
    public ObjectProperty<Figure> activeParentProperty() {
        return this.activeParent;
    }

    public void clearSelection() {
        this.getSelectedFigures().clear();
    }

    @Override
    public NonNullObjectProperty<Constrainer> constrainerProperty() {
        return this.constrainer;
    }

    public void deleteSelection() {
        ArrayList figures = new ArrayList(this.getSelectedFigures());
        DrawingModel model = this.getModel();
        ArrayDeque cascade = new ArrayDeque(figures);
        for (Figure f : figures) {
            for (Figure ff : f.preorderIterable()) {
                StreamSupport.stream(new TreeBreadthFirstSpliterator(figure -> () -> figure.getReadOnlyLayoutObservers().stream().filter(x -> x.getLayoutSubjects().size() == 1).iterator(), (Object)ff), false).forEach(cascade::addFirst);
            }
        }
        for (Figure f : cascade) {
            if (!f.isDeletable()) continue;
            for (Figure d : f.preorderIterable()) {
                model.disconnect(d);
            }
            model.removeFromParent(f);
        }
    }

    @Override
    public ReadOnlyObjectProperty<Drawing> drawingProperty() {
        return this.drawing.getReadOnlyProperty();
    }

    public void duplicateSelection() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public @Nullable Node findFigureNode(Figure figure, double vx, double vy) {
        return this.drawingRenderer.findFigureNode(figure, vx, vy);
    }

    @Override
    public List<Map.Entry<Figure, Double>> findFigures(double vx, double vy, boolean decompose, Predicate<Figure> predicate) {
        return this.drawingRenderer.findFigures(vx, vy, decompose, predicate);
    }

    @Override
    public List<Map.Entry<Figure, Double>> findFiguresInside(double vx, double vy, double vwidth, double vheight, boolean decompose) {
        return this.drawingRenderer.findFiguresInside(vx, vy, vwidth, vheight, decompose, Figure::isSelectable);
    }

    @Override
    public List<Map.Entry<Figure, Double>> findFiguresIntersecting(double vx, double vy, double vwidth, double vheight, boolean decompose, Predicate<Figure> predicate) {
        return this.drawingRenderer.findFiguresIntersecting(vx, vy, vwidth, vheight, decompose, predicate);
    }

    @Override
    public @Nullable Handle findHandle(double vx, double vy) {
        return this.handleRenderer.findHandle(vx, vy);
    }

    @Override
    public ReadOnlyBooleanProperty focusedProperty() {
        return this.focused.getReadOnlyProperty();
    }

    @Override
    public Set<Figure> getFiguresWithCompatibleHandle(Collection<Figure> figures, Handle handle) {
        return this.handleRenderer.getFiguresWithCompatibleHandle(figures, handle);
    }

    @Override
    public Node getNode() {
        return this.node;
    }

    @Override
    public @Nullable Node getNode(Figure f) {
        return this.drawingRenderer.getNode(f);
    }

    @Override
    public Transform getViewToWorld() {
        return this.zoomableScrollPane.getViewToContent();
    }

    @Override
    public Bounds getVisibleRect() {
        return this.worldToView(this.zoomableScrollPane.getVisibleContentRect());
    }

    @Override
    public Transform getWorldToView() {
        return this.zoomableScrollPane.getContentToView();
    }

    @Override
    public ReadOnlySetProperty<Handle> handlesProperty() {
        return this.handleRenderer.handlesProperty();
    }

    protected void initBehavior() {
        this.drawingRenderer.setRenderContext(this);
    }

    private void initBindings() {
        CustomBinding.bind(this.drawing, this.model, DrawingModel::drawingProperty);
        this.model.addListener(this::onDrawingModelChanged);
        ((DrawingModel)this.model.get()).setRoot(new SimpleDrawing());
        this.onDrawingModelChanged((Observable)this.model, null, (DrawingModel)this.model.getValue());
        this.drawingRenderer.modelProperty().bind(this.modelProperty());
        this.drawingRenderer.clipBoundsProperty().bind(this.zoomableScrollPane.visibleContentRectProperty());
        this.drawingRenderer.editorProperty().bind(this.editorProperty());
        this.drawingRenderer.setDrawingView(this);
        this.handleRenderer.modelProperty().bind(this.modelProperty());
        this.handleRenderer.setSelectedFigures((ObservableSet<Figure>)this.getSelectedFigures());
        this.handleRenderer.editorProperty().bind(this.editorProperty());
        this.handleRenderer.setDrawingView(this);
        this.zoomFactorProperty().addListener(this::onZoomFactorChanged);
        this.constrainer.addListener(this::onConstrainerChanged);
        this.zoomableScrollPane.visibleContentRectProperty().addListener(this::onViewRectChanged);
        this.zoomableScrollPane.contentToViewProperty().addListener(this::onContentToViewChanged);
        CustomBinding.bind(this.drawing, this.model, DrawingModel::drawingProperty);
        CustomBinding.bind((Property)this.focused, this.toolProperty(), Tool::focusedProperty);
    }

    private void initLayout() {
        this.node.setCenter(this.zoomableScrollPane.getNode());
        this.background.setManaged(false);
        this.zoomableScrollPane.getContentChildren().add((Object)this.drawingRenderer.getNode());
        this.zoomableScrollPane.getBackgroundChildren().add((Object)this.background);
        this.zoomableScrollPane.getForegroundChildren().addAll((Object[])new Node[]{this.handleRenderer.getNode(), this.foreground});
        this.foreground.setManaged(false);
    }

    protected void initStyle() {
        this.background.getStyleClass().add((Object)CANVAS_REGION_STYLE_CLASS);
        this.node.getStyleClass().add((Object)DRAWING_VIEW_STYLE_CLASS);
    }

    private void invalidateConstrainer() {
        this.constrainerNodeValid = false;
    }

    @Override
    protected void invalidateHandles() {
    }

    @Override
    public void jiggleHandles() {
        this.handleRenderer.jiggleHandles();
    }

    @Override
    public NonNullObjectProperty<DrawingModel> modelProperty() {
        return this.model;
    }

    private void onConstrainerChanged(Observable o, @Nullable Constrainer oldValue, @Nullable Constrainer newValue) {
        if (oldValue != null) {
            this.foreground.getChildren().remove((Object)oldValue.getNode());
            oldValue.removeListener(this::onConstrainerInvalidated);
        }
        if (newValue != null) {
            Node node = newValue.getNode();
            node.setManaged(false);
            this.foreground.getChildren().addFirst((Object)node);
            node.applyCss();
            newValue.updateNode(this);
            newValue.addListener(this::onConstrainerInvalidated);
            this.invalidateConstrainer();
            this.repaint();
        }
    }

    private void onConstrainerInvalidated(Observable o) {
        this.invalidateConstrainer();
        this.repaint();
    }

    private void onContentToViewChanged(Observable observable) {
        this.updateBackgroundNode();
    }

    private void onDrawingChanged() {
    }

    private void onDrawingModelChanged(Observable o, @Nullable DrawingModel oldValue, @Nullable DrawingModel newValue) {
        if (oldValue != null) {
            oldValue.removeTreeModelListener(this.treeModelListener);
        }
        if (newValue != null) {
            newValue.addTreeModelListener(this.treeModelListener);
            this.revalidateLayout();
        }
    }

    private void onNodeChanged(Figure f) {
        if (f == this.getDrawing()) {
            this.revalidateLayout();
        }
    }

    private void onNodeRemoved(Figure f) {
        ObservableSet selectedFigures = this.getSelectedFigures();
        for (Figure d : f.preorderIterable()) {
            selectedFigures.remove((Object)d);
        }
        this.repaint();
    }

    private void onRootChanged() {
        this.onDrawingChanged();
        this.clearSelection();
        this.revalidateLayout();
        this.repaint();
    }

    private void onSubtreeNodesChanged(Figure f) {
    }

    @Override
    protected void onToolChanged(Observable observable, @Nullable Tool oldValue, @Nullable Tool newValue) {
        if (oldValue != null) {
            this.foreground.getChildren().remove((Object)oldValue.getNode());
            oldValue.setDrawingView(null);
        }
        if (newValue != null) {
            Node node = newValue.getNode();
            node.setManaged(true);
            this.foreground.getChildren().add((Object)node);
            newValue.setDrawingView(this);
        }
    }

    private void onTreeModelEvent(TreeModelEvent<Figure> event) {
        Figure f = (Figure)event.getNode();
        switch (event.getEventType()) {
            case NODE_ADDED_TO_PARENT: 
            case NODE_REMOVED_FROM_PARENT: 
            case NODE_ADDED_TO_TREE: {
                break;
            }
            case NODE_REMOVED_FROM_TREE: {
                this.onNodeRemoved(f);
                break;
            }
            case NODE_CHANGED: {
                this.onNodeChanged(f);
                break;
            }
            case ROOT_CHANGED: {
                this.onRootChanged();
                break;
            }
            case SUBTREE_NODES_CHANGED: {
                this.onSubtreeNodesChanged(f);
                break;
            }
            default: {
                throw new UnsupportedOperationException(String.valueOf(event.getEventType()) + " not supported");
            }
        }
    }

    private void onViewRectChanged(Observable observable, @Nullable Bounds oldValue, @Nullable Bounds newValue) {
        this.revalidateLayout();
    }

    private void onZoomFactorChanged(Observable observable) {
        this.revalidateLayout();
    }

    private void paint() {
        this.repainter = null;
        if (!this.constrainerNodeValid) {
            this.updateConstrainerNode();
            this.constrainerNodeValid = true;
        }
    }

    public void paintImmediately() {
        this.drawingRenderer.paintImmediately();
        this.paint();
    }

    @Override
    public void recreateHandles() {
        this.handleRenderer.recreateHandles();
    }

    @Override
    protected void repaint() {
        if (this.repainter == null) {
            this.repainter = this::paint;
            Platform.runLater((Runnable)this.repainter);
        }
    }

    private void revalidateLayout() {
        if (this.isLayoutValid) {
            this.isLayoutValid = false;
            this.validateLayout();
        }
    }

    @Override
    public void scrollRectToVisible(Bounds boundsInView) {
        this.zoomableScrollPane.scrollViewRectToVisible(boundsInView);
    }

    public void selectAll() {
        ArrayList<Figure> figures = new ArrayList<Figure>();
        Drawing d = this.getDrawing();
        if (d != null) {
            for (Figure layer : d.getChildren()) {
                if (!layer.isEditable() || !layer.isVisible()) continue;
                for (Figure f : layer.getChildren()) {
                    if (!f.isSelectable()) continue;
                    figures.add(f);
                }
            }
        }
        this.getSelectedFigures().clear();
        this.getSelectedFigures().addAll(figures);
    }

    private void updateBackgroundNode() {
        Drawing drawing = this.getDrawing();
        BoundingBox bounds = drawing == null ? new BoundingBox(0.0, 0.0, 10.0, 10.0) : drawing.getLayoutBounds();
        Bounds bounds1 = this.worldToView((Bounds)bounds);
        double x = bounds1.getMinX();
        double y = bounds1.getMinY();
        double w = bounds1.getWidth();
        double h = bounds1.getHeight();
        double p = 0.0;
        this.background.resizeRelocate(x - p, y - p, w + 2.0 * p, h + 2.0 * p);
    }

    private void updateConstrainerNode() {
        Constrainer c = this.getConstrainer();
        if (c != null) {
            c.updateNode(this);
        }
    }

    private void updateLayout() {
        Drawing drawing = this.getDrawing();
        BoundingBox bounds = drawing == null ? new BoundingBox(0.0, 0.0, 10.0, 10.0) : drawing.getLayoutBounds();
        double f = this.getZoomFactor();
        double w = bounds.getWidth();
        double h = bounds.getHeight();
        this.zoomableScrollPane.setContentSize(w, h);
        Bounds vp = this.zoomableScrollPane.getViewportRect();
        this.foreground.resize(vp.getWidth(), vp.getHeight());
        this.handleRenderer.invalidateHandleNodes();
        this.handleRenderer.repaint();
        this.updateConstrainerNode();
        this.updateBackgroundNode();
    }

    private void validateLayout() {
        if (!this.isLayoutValid) {
            this.updateLayout();
            this.isLayoutValid = true;
        }
    }

    @Override
    public DoubleProperty zoomFactorProperty() {
        return this.zoomableScrollPane.zoomFactorProperty();
    }

    private class SimpleDrawingViewNode
    extends BorderPane
    implements EditableComponent {
        public SimpleDrawingViewNode() {
            this.setFocusTraversable(true);
        }

        public void clearSelection() {
            SimpleDrawingView.this.clearSelection();
        }

        public void copy() {
            SimpleDrawingView.this.copy();
        }

        public void cut() {
            SimpleDrawingView.this.cut();
        }

        public void deleteSelection() {
            SimpleDrawingView.this.deleteSelection();
        }

        public void duplicateSelection() {
            SimpleDrawingView.this.duplicateSelection();
        }

        public void paste() {
            SimpleDrawingView.this.paste();
        }

        public void selectAll() {
            SimpleDrawingView.this.selectAll();
        }

        public ReadOnlyBooleanProperty selectionEmptyProperty() {
            return SimpleDrawingView.this.selectedFiguresProperty().emptyProperty();
        }
    }
}

