/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.draw.action;

import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableSet;
import javafx.event.ActionEvent;
import javax.swing.event.UndoableEditEvent;
import org.jhotdraw8.application.action.AbstractAction;
import org.jhotdraw8.draw.DrawingEditor;
import org.jhotdraw8.draw.DrawingView;
import org.jhotdraw8.fxbase.binding.CustomBinding;
import org.jhotdraw8.fxbase.undo.UndoableEditHelper;
import org.jspecify.annotations.Nullable;

public abstract class AbstractDrawingViewAction
extends AbstractAction {
    private final DrawingEditor editor;
    protected final UndoableEditHelper undoHelper = new UndoableEditHelper((Object)this, this::forwardUndoableEdit);

    public AbstractDrawingViewAction(DrawingEditor editor) {
        this.editor = editor;
        SimpleBooleanProperty editorHasNoDrawingViewOrDrawingViewIsDisabledProperty = new SimpleBooleanProperty();
        CustomBinding.bind((Property)editorHasNoDrawingViewOrDrawingViewIsDisabledProperty, editor.activeDrawingViewProperty(), drawingView -> drawingView == null ? new SimpleBooleanProperty(true) : drawingView.getNode().disableProperty());
        CustomBinding.bindMembershipToBoolean((ObservableSet)this.disablers(), (Object)new Object(), (ObservableValue)editorHasNoDrawingViewOrDrawingViewIsDisabledProperty);
    }

    public void forwardUndoableEdit(UndoableEditEvent event) {
        this.editor.getUndoManager().undoableEditHappened(event);
    }

    public DrawingEditor getEditor() {
        return this.editor;
    }

    protected @Nullable DrawingView getView() {
        return this.editor.getActiveDrawingView();
    }

    protected void onActionPerformed(ActionEvent event) {
        DrawingView view = this.getView();
        if (view != null) {
            this.undoHelper.startCompositeEdit(null);
            this.onActionPerformed(event, view);
            this.undoHelper.stopCompositeEdit();
        }
    }

    protected abstract void onActionPerformed(ActionEvent var1, DrawingView var2);
}

